/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.SocketTimeoutException;
import java.util.LinkedHashMap;
import kafka.admin.AdminUtils$;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Replica;
import kafka.common.KafkaStorageException;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.NetworkClientBlockingOps$;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.LoginType;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestSend;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\tUf\u0001B\u0001\u0003\u0001\u001d\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\r\u0002\t9\fW.\u001a\t\u0003\u001fUq!\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\ta\u0001\u0015:fI\u00164\u0017B\u0001\f\u0018\u0005\u0019\u0019FO]5oO*\u0011A#E\u0005\u0003\u001beI!AG\u000e\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u00039\u0011\tQ!\u001e;jYND\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"\u0001\u0005\u0011\n\u0005\u0005\n\"aA%oi\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002&Q5\taE\u0003\u0002(\t\u000591\r\\;ti\u0016\u0014\u0018BA\u0015'\u00059\u0011%o\\6fe\u0016sG\rU8j]RD\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003\u00135J!A\f\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005Q!/\u001a9mS\u000e\fWj\u001a:\u0011\u0005%\u0011\u0014BA\u001a\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\b[\u0016$(/[2t!\t9\u0004)D\u00019\u0015\t)\u0014H\u0003\u0002;w\u000511m\\7n_:T!!\u0002\u001f\u000b\u0005ur\u0014AB1qC\u000eDWMC\u0001@\u0003\ry'oZ\u0005\u0003\u0003b\u0012q!T3ue&\u001c7\u000f\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0003\u0011!\u0018.\\3\u0011\u0005\u0015;U\"\u0001$\u000b\u0005qI\u0014B\u0001%G\u0005\u0011!\u0016.\\3\t\u0011)\u0003!\u0011!Q\u0001\n-\u000bQ!];pi\u0006\u0004\"!\u0003'\n\u00055\u0013!a\u0006*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011\u0015y\u0005\u0001\"\u0001Q\u0003\u0019a\u0014N\\5u}QI\u0011KU*U+Z;\u0006,\u0017\t\u0003\u0013\u0001AQ!\u0004(A\u00029AQA\b(A\u0002}AQa\t(A\u0002\u0011BQa\u000b(A\u00021BQ\u0001\r(A\u0002EBQ!\u000e(A\u0002YBQa\u0011(A\u0002\u0011CQA\u0013(A\u0002-+Aa\u0017\u0001\u00019\n\u0019!+R)\u0011\u0005uCgBA\u0005_\u000f\u0015y&\u0001#\u0001a\u0003Q\u0011V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bIB\u0011\u0011\"\u0019\u0004\u0006\u0003\tA\tAY\n\u0003C\u000e\u0004\"\u0001\u00053\n\u0005\u0015\f\"AB!osJ+g\rC\u0003PC\u0012\u0005q\rF\u0001a\r\u0015I\u0017\r\u0001\u0002k\u000511U\r^2i%\u0016\fX/Z:u'\rA7m\u001b\t\u0003Y>t!!C7\n\u00059\u0014\u0011!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0005\u0003SBT!A\u001c\u0002\t\u0011ID'Q1A\u0005\u0002M\f!\"\u001e8eKJd\u00170\u001b8h+\u0005!\bCA;y\u001b\u00051(BA<:\u0003!\u0011X-];fgR\u001c\u0018BA5w\u0011!Q\bN!A!\u0002\u0013!\u0018aC;oI\u0016\u0014H._5oO\u0002BQa\u00145\u0005\u0002q$\"!`@\u0011\u0005yDW\"A1\t\u000bI\\\b\u0019\u0001;\t\u000f\u0005\r\u0001\u000e\"\u0001\u0002\u0006\u00059\u0011n]#naRLXCAA\u0004!\r\u0001\u0012\u0011B\u0005\u0004\u0003\u0017\t\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u001fAG\u0011AA\t\u0003\u0019ygMZ:fiR!\u00111CA\r!\r\u0001\u0012QC\u0005\u0004\u0003/\t\"\u0001\u0002'p]\u001eD\u0001\"a\u0007\u0002\u000e\u0001\u0007\u0011QD\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\ty\"!\t\u000e\u0003eJ1!a\t:\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:4q!a\nb\u0001\t\tICA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/Y\n\u0006\u0003K\u0019\u00171\u0006\t\u0004Y\u00065\u0012bAA\u0014a\"Q!/!\n\u0003\u0006\u0004%\t!!\r\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003wq1!^A\u001c\u0013\r\tID^\u0001\u000e\r\u0016$8\r\u001b*fgB|gn]3\n\t\u0005\u001d\u0012Q\b\u0006\u0004\u0003s1\bB\u0003>\u0002&\t\u0005\t\u0015!\u0003\u00024!9q*!\n\u0005\u0002\u0005\rC\u0003BA#\u0003\u000f\u00022A`A\u0013\u0011\u001d\u0011\u0018\u0011\ta\u0001\u0003gA\u0001\"a\u0013\u0002&\u0011\u0005\u0011QJ\u0001\nKJ\u0014xN]\"pI\u0016,\"!a\u0014\u0011\u0007A\t\t&C\u0002\u0002TE\u0011Qa\u00155peRD\u0001\"a\u0016\u0002&\u0011\u0005\u0011\u0011L\u0001\u0017i>\u0014\u0015\u0010^3Ck\u001a4WM]'fgN\fw-Z*fiV\u0011\u00111\f\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011\r\u0003\u0002\u000f5,7o]1hK&!\u0011QMA0\u0005Q\u0011\u0015\u0010^3Ck\u001a4WM]'fgN\fw-Z*fi\"A\u0011\u0011NA\u0013\t\u0003\tY'A\u0007iS\u001eDw+\u0019;fe6\f'o[\u000b\u0003\u0003'A\u0001\"a\u001c\u0002&\u0011\u0005\u0011\u0011O\u0001\nKb\u001cW\r\u001d;j_:,\"!a\u001d\u0011\u000bA\t)(!\u001f\n\u0007\u0005]\u0014C\u0001\u0004PaRLwN\u001c\t\u0005\u0003w\nYI\u0004\u0003\u0002~\u0005\u001de\u0002BA@\u0003\u000bk!!!!\u000b\u0007\u0005\re!\u0001\u0004=e>|GOP\u0005\u0002%%\u0019\u0011\u0011R\t\u0002\u000fA\f7m[1hK&!\u0011QRAH\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\nF)a!a%\u0001\u0001\u0005U%A\u0001)E!\ri\u0016Q\u0005\u0005\n\u00033\u0003!\u0019!C\u0005\u0003\u001b\n1CZ3uG\"\u0014V-];fgR4VM]:j_:D\u0001\"!(\u0001A\u0003%\u0011qJ\u0001\u0015M\u0016$8\r\u001b*fcV,7\u000f\u001e,feNLwN\u001c\u0011\t\u0013\u0005\u0005\u0006A1A\u0005\n\u0005\r\u0016!D:pG.,G\u000fV5nK>,H/F\u0001 \u0011\u001d\t9\u000b\u0001Q\u0001\n}\tab]8dW\u0016$H+[7f_V$\b\u0005C\u0005\u0002,\u0002\u0011\r\u0011\"\u0003\u0002$\u0006I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\b\u0003_\u0003\u0001\u0015!\u0003 \u0003)\u0011X\r\u001d7jG\u0006LE\r\t\u0005\n\u0003g\u0003!\u0019!C\u0005\u0003k\u000bq!\\1y/\u0006LG/\u0006\u0002\u00028B!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016\u0001\u00027b]\u001eT!!!1\u0002\t)\fg/Y\u0005\u0005\u0003\u000b\fYLA\u0004J]R,w-\u001a:\t\u0011\u0005%\u0007\u0001)A\u0005\u0003o\u000b\u0001\"\\1y/\u0006LG\u000f\t\u0005\n\u0003\u001b\u0004!\u0019!C\u0005\u0003k\u000b\u0001\"\\5o\u0005f$Xm\u001d\u0005\t\u0003#\u0004\u0001\u0015!\u0003\u00028\u0006IQ.\u001b8CsR,7\u000f\t\u0005\n\u0003+\u0004!\u0019!C\u0005\u0003k\u000b\u0001\"\\1y\u0005f$Xm\u001d\u0005\t\u00033\u0004\u0001\u0015!\u0003\u00028\u0006IQ.\u0019=CsR,7\u000f\t\u0005\n\u0003;\u0004!\u0019!C\u0005\u0003k\u000b\u0011BZ3uG\"\u001c\u0016N_3\t\u0011\u0005\u0005\b\u0001)A\u0005\u0003o\u000b!BZ3uG\"\u001c\u0016N_3!\u0011\u001d\t)\u000f\u0001C\u0005\u0003O\f\u0001b\u00197jK:$\u0018\nZ\u000b\u0002\u001d!I\u00111\u001e\u0001C\u0002\u0013%\u0011Q^\u0001\u000bg>,(oY3O_\u0012,WCAAx!\u0011\ty\"!=\n\u0007\u0005M\u0018H\u0001\u0003O_\u0012,\u0007\u0002CA|\u0001\u0001\u0006I!a<\u0002\u0017M|WO]2f\u001d>$W\r\t\u0005\n\u0003w\u0004!\u0019!C\u0005\u0003{\fQB\\3uo>\u00148n\u00117jK:$XCAA\u0000!\u0011\u0011\tAa\u0002\u000e\u0005\t\r!b\u0001B\u0003w\u000591\r\\5f]R\u001c\u0018\u0002\u0002B\u0005\u0005\u0007\u0011QBT3uo>\u00148n\u00117jK:$\b\u0002\u0003B\u0007\u0001\u0001\u0006I!a@\u0002\u001d9,Go^8sW\u000ec\u0017.\u001a8uA!9!\u0011\u0003\u0001\u0005B\tM\u0011\u0001C:ikR$wn\u001e8\u0015\u0005\tU\u0001c\u0001\t\u0003\u0018%\u0019!\u0011D\t\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005;\u0001A\u0011\u0001B\u0010\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRA!Q\u0003B\u0011\u0005G\u00119\u0003\u0003\u0005\u0002\u001c\tm\u0001\u0019AA\u000f\u0011!\u0011)Ca\u0007A\u0002\u0005M\u0011a\u00034fi\u000eDwJ\u001a4tKRD\u0001B!\u000b\u0003\u001c\u0001\u0007\u0011QS\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\t\u000f\t5\u0002\u0001\"\u0001\u00030\u0005YR.Y=cK^\u000b'O\\%g\u001b\u0016\u001c8/Y4f\u001fZ,'o]5{K\u0012$bA!\u0006\u00032\tU\u0002\u0002\u0003B\u001a\u0005W\u0001\r!a\u0017\u0002\u00155,7o]1hKN+G\u000f\u0003\u0005\u0002\u001c\t-\u0002\u0019AA\u000f\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005w\ta\u0003[1oI2,wJ\u001a4tKR|U\u000f^(g%\u0006tw-\u001a\u000b\u0005\u0003'\u0011i\u0004\u0003\u0005\u0002\u001c\t]\u0002\u0019AA\u000f\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0007\n!\u0004[1oI2,\u0007+\u0019:uSRLwN\\:XSRDWI\u001d:peN$BA!\u0006\u0003F!A!q\tB \u0001\u0004\u0011I%\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!a\u001f\u0003L\u0005u\u0011\u0002\u0002B'\u0003\u001f\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0005#\u0002A\u0011\u0003B*\u0003\u00151W\r^2i)\u0011\u0011)F!\u0019\u0011\r\u0005m$q\u000bB.\u0013\u0011\u0011I&a$\u0003\u0007M+\u0017\u000fE\u0004\u0011\u0005;\ni\"!&\n\u0007\t}\u0013C\u0001\u0004UkBdWM\r\u0005\b\u0005G\u0012y\u00051\u0001]\u000311W\r^2i%\u0016\fX/Z:u\u0011\u001d\u00119\u0007\u0001C\u0005\u0005S\n1b]3oIJ+\u0017/^3tiRA!1\u000eB9\u0005\u0003\u00139\t\u0005\u0003\u0003\u0002\t5\u0014\u0002\u0002B8\u0005\u0007\u0011ab\u00117jK:$(+Z:q_:\u001cX\r\u0003\u0005\u0003t\t\u0015\u0004\u0019\u0001B;\u0003\u0019\t\u0007/[&fsB!!q\u000fB?\u001b\t\u0011IHC\u0002\u0003|e\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005\u007f\u0012IHA\u0004Ba&\\U-_:\t\u0011\t\r%Q\ra\u0001\u0005\u000b\u000b!\"\u00199j-\u0016\u00148/[8o!\u0015\u0001\u0012QOA(\u0011!\u0011II!\u001aA\u0002\t-\u0015a\u0002:fcV,7\u000f\u001e\t\u0004k\n5\u0015b\u0001BHm\ny\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0004\u0003\u0014\u0002!IA!&\u0002-\u0015\f'\u000f\\5fgR|%\u000fT1uKN$xJ\u001a4tKR$\u0002\"a\u0005\u0003\u0018\ne%Q\u0014\u0005\t\u00037\u0011\t\n1\u0001\u0002\u001e!A!1\u0014BI\u0001\u0004\t\u0019\"\u0001\tfCJd\u0017.Z:u\u001fJd\u0015\r^3ti\"9!q\u0014BI\u0001\u0004y\u0012AC2p]N,X.\u001a:JI\"9!1\u0015\u0001\u0005\u0012\t\u0015\u0016!\u00052vS2$g)\u001a;dQJ+\u0017/^3tiR\u0019ALa*\t\u0011\t%&\u0011\u0015a\u0001\u0005W\u000bA\u0002]1si&$\u0018n\u001c8NCB\u0004b!a\u001f\u0003X\t5\u0006c\u0002\t\u0003^\u0005u!q\u0016\t\u0004\u0013\tE\u0016b\u0001BZ\u0005\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\u0002")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    public final BrokerEndPoint kafka$server$ReplicaFetcherThread$$sourceBroker;
    public final KafkaConfig kafka$server$ReplicaFetcherThread$$brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Time time;
    public final ReplicationQuotaManager kafka$server$ReplicaFetcherThread$$quota;
    private final short fetchRequestVersion;
    private final int socketTimeout;
    private final int replicaId;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer kafka$server$ReplicaFetcherThread$$fetchSize;
    private final Node sourceNode;
    private final NetworkClient kafka$server$ReplicaFetcherThread$$networkClient;

    private short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    public Integer kafka$server$ReplicaFetcherThread$$fetchSize() {
        return this.kafka$server$ReplicaFetcherThread$$fetchSize;
    }

    private String clientId() {
        return super.name();
    }

    private Node sourceNode() {
        return this.sourceNode;
    }

    public NetworkClient kafka$server$ReplicaFetcherThread$$networkClient() {
        return this.kafka$server$ReplicaFetcherThread$$networkClient;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.kafka$server$ReplicaFetcherThread$$networkClient().close();
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        try {
            String topic = topicPartition.topic();
            int partitionId = topicPartition.partition();
            Replica replica = (Replica)this.replicaMgr.getReplica(topic, partitionId, this.replicaMgr.getReplica$default$3()).get();
            ByteBufferMessageSet messageSet = partitionData.toByteBufferMessageSet();
            this.maybeWarnIfMessageOversized(messageSet, topicPartition);
            if (fetchOffset != replica.logEndOffset().messageOffset()) {
                throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset())})));
            }
            if (this.logger().isTraceEnabled()) {
                this.trace((Function0<String>)new Serializable(this, topicPartition, partitionData, replica, messageSet){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$1;
                    private final PartitionData partitionData$1;
                    private final Replica replica$1;
                    private final ByteBufferMessageSet messageSet$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replica$1.brokerId()), BoxesRunTime.boxToLong((long)this.replica$1.logEndOffset().messageOffset()), this.topicPartition$1, BoxesRunTime.boxToInteger((int)this.messageSet$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.partitionData$1.highWatermark())}));
                    }
                    {
                        this.topicPartition$1 = topicPartition$1;
                        this.partitionData$1 = partitionData$1;
                        this.replica$1 = replica$1;
                        this.messageSet$1 = messageSet$1;
                    }
                });
            }
            ((Log)replica.log().get()).append(messageSet, false);
            if (this.logger().isTraceEnabled()) {
                this.trace((Function0<String>)new Serializable(this, topicPartition, replica, messageSet){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$1;
                    private final Replica replica$1;
                    private final ByteBufferMessageSet messageSet$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replica$1.brokerId()), BoxesRunTime.boxToLong((long)this.replica$1.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.messageSet$1.sizeInBytes()), this.topicPartition$1}));
                    }
                    {
                        this.topicPartition$1 = topicPartition$1;
                        this.replica$1 = replica$1;
                        this.messageSet$1 = messageSet$1;
                    }
                });
            }
            long followerHighWatermark = BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(replica.logEndOffset().messageOffset())).min((Object)BoxesRunTime.boxToLong((long)partitionData.highWatermark())));
            replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            if (this.logger().isTraceEnabled()) {
                this.trace((Function0<String>)new Serializable(this, topic, partitionId, replica, followerHighWatermark){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;
                    private final int partitionId$1;
                    private final Replica replica$1;
                    private final long followerHighWatermark$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Follower %d set replica high watermark for partition [%s,%d] to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replica$1.brokerId()), this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1), BoxesRunTime.boxToLong((long)this.followerHighWatermark$1)}));
                    }
                    {
                        this.topic$1 = topic$1;
                        this.partitionId$1 = partitionId$1;
                        this.replica$1 = replica$1;
                        this.followerHighWatermark$1 = followerHighWatermark$1;
                    }
                });
            }
            if (this.kafka$server$ReplicaFetcherThread$$quota.isThrottled(new TopicAndPartition(topic, partitionId))) {
                this.kafka$server$ReplicaFetcherThread$$quota.record(messageSet.sizeInBytes());
            }
        }
        catch (KafkaStorageException kafkaStorageException) {
            this.fatal((Function0<String>)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disk error while replicating data for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                }
            }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                public static final long serialVersionUID = 0L;
                private final KafkaStorageException e$1;

                public final KafkaStorageException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            Runtime.getRuntime().halt(1);
        }
    }

    public void maybeWarnIfMessageOversized(ByteBufferMessageSet messageSet, TopicPartition topicPartition) {
        if (this.fetchRequestVersion() <= 2 && messageSet.sizeInBytes() > 0 && messageSet.validBytes() <= 0) {
            this.error((Function0<String>)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2}))).append((Object)"This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append((Object)"message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append((Object)"equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString();
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                }
            });
        }
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topicPartition.topic(), topicPartition.partition());
        Replica replica = (Replica)this.replicaMgr.getReplica(topicPartition.topic(), topicPartition.partition(), this.replicaMgr.getReplica$default$3()).get();
        long leaderEndOffset = this.earliestOrLatestOffset(topicPartition, -1L, this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
        if (leaderEndOffset < replica.logEndOffset().messageOffset()) {
            if (!Predef$.MODULE$.Boolean2boolean(LogConfig$.MODULE$.fromProps(this.kafka$server$ReplicaFetcherThread$$brokerConfig.originals(), AdminUtils$.MODULE$.fetchEntityConfig(this.replicaMgr.zkUtils(), ConfigType$.MODULE$.Topic(), topicPartition.topic())).uncleanLeaderElectionEnable())) {
                this.fatal((Function0<String>)new Serializable(this, topicPartition, replica, leaderEndOffset){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcherThread $outer;
                    private final TopicPartition topicPartition$3;
                    private final Replica replica$2;
                    private final long leaderEndOffset$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Exiting because log truncation is not allowed for partition %s,")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$3}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(" Current leader %d's latest offset %d is less than replica %d's latest offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong((long)this.leaderEndOffset$1), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), BoxesRunTime.boxToLong((long)this.replica$2.logEndOffset().messageOffset())}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topicPartition$3 = topicPartition$3;
                        this.replica$2 = replica$2;
                        this.leaderEndOffset$1 = leaderEndOffset$1;
                    }
                });
                System.exit(1);
            }
            this.warn((Function0<String>)new Serializable(this, topicPartition, replica, leaderEndOffset){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcherThread $outer;
                private final TopicPartition topicPartition$3;
                private final Replica replica$2;
                private final long leaderEndOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset from %d to current leader %d's latest offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), this.topicPartition$3, BoxesRunTime.boxToLong((long)this.replica$2.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong((long)this.leaderEndOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topicPartition$3 = topicPartition$3;
                    this.replica$2 = replica$2;
                    this.leaderEndOffset$1 = leaderEndOffset$1;
                }
            });
            this.replicaMgr.logManager().truncateTo((Map<TopicAndPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)BoxesRunTime.boxToLong((long)leaderEndOffset))}))));
            l = leaderEndOffset;
        } else {
            long leaderStartOffset = this.earliestOrLatestOffset(topicPartition, -2L, this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
            this.warn((Function0<String>)new Serializable(this, topicPartition, replica, leaderStartOffset){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcherThread $outer;
                private final TopicPartition topicPartition$3;
                private final Replica replica$2;
                private final long leaderStartOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset from %d to current leader %d's start offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), this.topicPartition$3, BoxesRunTime.boxToLong((long)this.replica$2.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong((long)this.leaderStartOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topicPartition$3 = topicPartition$3;
                    this.replica$2 = replica$2;
                    this.leaderStartOffset$1 = leaderStartOffset$1;
                }
            });
            long offsetToFetch = Math.max(leaderStartOffset, replica.logEndOffset().messageOffset());
            if (leaderStartOffset > replica.logEndOffset().messageOffset()) {
                this.replicaMgr.logManager().truncateFullyAndStartAt(topicAndPartition, leaderStartOffset);
            }
            l = offsetToFetch;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        this.delayPartitions(partitions, Predef$.MODULE$.Integer2int(this.kafka$server$ReplicaFetcherThread$$brokerConfig.replicaFetchBackoffMs()));
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        ClientResponse clientResponse = this.sendRequest(ApiKeys.FETCH, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)this.fetchRequestVersion())), (AbstractRequest)fetchRequest.underlying());
        return (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)new FetchResponse(clientResponse.responseBody()).responseData()).asScala()).toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, PartitionData> apply(Tuple2<TopicPartition, FetchResponse.PartitionData> x0$1) {
                Tuple2<TopicPartition, FetchResponse.PartitionData> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition key = (TopicPartition)tuple2._1();
                    FetchResponse.PartitionData value2 = (FetchResponse.PartitionData)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)new PartitionData(value2));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ClientResponse sendRequest(ApiKeys apiKey, Option<Object> apiVersion, AbstractRequest request) {
        RequestHeader header = (RequestHeader)apiVersion.fold((Function0)new Serializable(this, apiKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;
            private final ApiKeys apiKey$1;

            public final RequestHeader apply() {
                return this.$outer.kafka$server$ReplicaFetcherThread$$networkClient().nextRequestHeader(this.apiKey$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.apiKey$1 = apiKey$1;
            }
        }, (Function1)new Serializable(this, apiKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;
            private final ApiKeys apiKey$1;

            public final RequestHeader apply(short x$1) {
                return this.$outer.kafka$server$ReplicaFetcherThread$$networkClient().nextRequestHeader(this.apiKey$1, x$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.apiKey$1 = apiKey$1;
            }
        });
        try {
            if (NetworkClientBlockingOps$.MODULE$.blockingReady$extension(NetworkClientBlockingOps$.MODULE$.networkClientBlockingOps(this.kafka$server$ReplicaFetcherThread$$networkClient()), this.sourceNode(), this.socketTimeout(), this.time)) {
                RequestSend send2 = new RequestSend(((Object)BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaFetcherThread$$sourceBroker.id())).toString(), header, request.toStruct());
                ClientRequest clientRequest = new ClientRequest(this.time.milliseconds(), true, send2, null);
                return NetworkClientBlockingOps$.MODULE$.blockingSendAndReceive$extension(NetworkClientBlockingOps$.MODULE$.networkClientBlockingOps(this.kafka$server$ReplicaFetcherThread$$networkClient()), clientRequest, this.time);
            }
            throw new SocketTimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to connect within ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.socketTimeout())})));
        }
        catch (Throwable throwable) {
            this.kafka$server$ReplicaFetcherThread$$networkClient().close(((Object)BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaFetcherThread$$sourceBroker.id())).toString());
            throw throwable;
        }
    }

    private long earliestOrLatestOffset(TopicPartition topicPartition, long earliestOrLatest, int consumerId) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$)) {
            Map partitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicPartition), (Object)earliestOrLatest)}));
            tuple22 = new Tuple2((Object)new ListOffsetRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava(), consumerId), (Object)BoxesRunTime.boxToInteger((int)1));
        } else {
            Map partitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(earliestOrLatest, 1))}));
            tuple22 = tuple2 = new Tuple2((Object)new ListOffsetRequest(consumerId, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava()), (Object)BoxesRunTime.boxToInteger((int)0));
        }
        if (tuple2 != null) {
            Tuple2 tuple23;
            ListOffsetRequest request = (ListOffsetRequest)tuple2._1();
            int apiVersion = tuple2._2$mcI$sp();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)request, (Object)BoxesRunTime.boxToInteger((int)apiVersion));
            ListOffsetRequest request2 = (ListOffsetRequest)tuple24._1();
            int apiVersion2 = tuple24._2$mcI$sp();
            ClientResponse clientResponse = this.sendRequest(ApiKeys.LIST_OFFSETS, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)((short)apiVersion2))), (AbstractRequest)request2);
            ListOffsetResponse response = new ListOffsetResponse(clientResponse.responseBody());
            ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(topicPartition);
            Errors errors = Errors.forCode((short)partitionData.errorCode);
            Errors errors2 = Errors.NONE;
            Errors errors3 = errors;
            if (!(errors2 != null ? !errors2.equals(errors3) : errors3 != null)) {
                long l = this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(partitionData.offset) : Predef$.MODULE$.Long2long((Long)partitionData.offsets.get(0));
                return l;
            }
            throw errors.exception();
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public FetchRequest buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        LinkedHashMap requestMap = new LinkedHashMap();
        boolean quotaExceeded = this.kafka$server$ReplicaFetcherThread$$quota.isQuotaExceeded();
        partitionMap.foreach((Function1)new Serializable(this, requestMap, quotaExceeded){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;
            private final LinkedHashMap requestMap$1;
            private final boolean quotaExceeded$1;

            public final Object apply(Tuple2<TopicPartition, PartitionFetchState> x0$2) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
                    TopicAndPartition topicAndPartition = new TopicAndPartition(topicPartition.topic(), topicPartition.partition());
                    BoxedUnit boxedUnit = partitionFetchState.isActive() && (!this.$outer.kafka$server$ReplicaFetcherThread$$quota.isThrottled(topicAndPartition) || !this.quotaExceeded$1) ? this.requestMap$1.put(topicPartition, new FetchRequest.PartitionData(partitionFetchState.offset(), Predef$.MODULE$.Integer2int(this.$outer.kafka$server$ReplicaFetcherThread$$fetchSize()))) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.requestMap$1 = requestMap$1;
                this.quotaExceeded$1 = quotaExceeded$1;
            }
        });
        org.apache.kafka.common.requests.FetchRequest request = this.fetchRequestVersion() >= 3 ? org.apache.kafka.common.requests.FetchRequest.fromReplica((int)this.replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (int)Predef$.MODULE$.Integer2int(this.maxBytes()), requestMap) : org.apache.kafka.common.requests.FetchRequest.fromReplica((int)this.replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), requestMap);
        return new FetchRequest(request);
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicationQuotaManager quota) {
        this.kafka$server$ReplicaFetcherThread$$sourceBroker = sourceBroker;
        this.kafka$server$ReplicaFetcherThread$$brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.time = time;
        this.kafka$server$ReplicaFetcherThread$$quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false);
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)));
        this.socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs());
        this.replicaId = brokerConfig.brokerId();
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.kafka$server$ReplicaFetcherThread$$fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
        ChannelBuilder channelBuilder = ChannelBuilders.create((SecurityProtocol)brokerConfig.interBrokerSecurityProtocol(), (Mode)Mode.CLIENT, (LoginType)LoginType.SERVER, (java.util.Map)brokerConfig.values(), (String)brokerConfig.saslMechanismInterBrokerProtocol(), (boolean)brokerConfig.saslInterBrokerHandshakeRequestEnable());
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig.connectionsMaxIdleMs()), metrics, time, "replica-fetcher", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"broker-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)sourceBroker.id())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"fetcher-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)fetcherId)).toString())}))).asJava(), false, channelBuilder);
        this.kafka$server$ReplicaFetcherThread$$networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), this.clientId(), 1, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig.requestTimeoutMs()), time);
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final org.apache.kafka.common.requests.FetchRequest underlying;

        public org.apache.kafka.common.requests.FetchRequest underlying() {
            return this.underlying;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().fetchData().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return ((FetchRequest.PartitionData)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.underlying().fetchData()).asScala()).apply((Object)topicPartition)).offset;
        }

        public FetchRequest(org.apache.kafka.common.requests.FetchRequest underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponse.PartitionData underlying;

        public FetchResponse.PartitionData underlying() {
            return this.underlying;
        }

        @Override
        public short errorCode() {
            return this.underlying().errorCode;
        }

        @Override
        public ByteBufferMessageSet toByteBufferMessageSet() {
            return new ByteBufferMessageSet(this.underlying().recordSet);
        }

        @Override
        public long highWatermark() {
            return this.underlying().highWatermark;
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = Errors.forCode((short)this.errorCode());
            Errors errors2 = Errors.NONE;
            Errors errors3 = errors;
            Object object = !(errors2 != null ? !errors2.equals(errors3) : errors3 != null) ? None$.MODULE$ : new Some((Object)errors.exception());
            return object;
        }

        public PartitionData(FetchResponse.PartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

