/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001B#G\u0001-CQ\u0001\u0018\u0001\u0005\u0002uCQa\u0018\u0001\u0005B\u0001Dqa\u001c\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004v\u0001\u0001\u0006I!\u001d\u0005\bm\u0002\u0011\r\u0011\"\u0003x\u0011\u0019Y\b\u0001)A\u0005q\"IA\u0010\u0001a\u0001\u0002\u0004%I! \u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0002\u0003\u0006\u0002(\u0001\u0001\r\u0011!Q!\nyD1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,!Y\u0011Q\t\u0001A\u0002\u0003\u0007I\u0011BA$\u0011-\tY\u0005\u0001a\u0001\u0002\u0003\u0006K!!\f\t\u0017\u00055\u0003\u00011AA\u0002\u0013%\u0011q\n\u0005\f\u0003C\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0007C\u0006\u0002h\u0001\u0001\r\u0011!Q!\n\u0005E\u0003\"CA5\u0001\t\u0007I\u0011BA6\u0011!\ti\b\u0001Q\u0001\n\u00055\u0004bBA@\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!!,\u0001\t\u0003\ty\u000bC\u0004\u00026\u0002!\t!a.\t\u0013\u0005\u0005\u0007!%A\u0005\u0002\u0005\r\u0007bBAm\u0001\u0011\u0005\u00111\u001c\u0005\b\u0003K\u0004A\u0011AAn\u0011\u001d\ty\u000f\u0001C\u0001\u00037Dq!!?\u0001\t\u0003\tY\u000eC\u0004\u0002~\u0002!\t!a7\t\u000f\t\u0005\u0001\u0001\"\u0001\u0002\\\"9!Q\u0001\u0001\u0005\u0002\u0005m\u0007b\u0002B\u0005\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005\u001b\u0001A\u0011AAn\u0011\u001d\u0011\t\u0002\u0001C\u0001\u00037DqA!\u0006\u0001\t\u0003\tY\u000eC\u0004\u0003\u001a\u0001!\t!a7\t\u000f\tu\u0001\u0001\"\u0001\u0002\\\"9!\u0011\u0005\u0001\u0005\u0002\u0005m\u0007b\u0002B\u0013\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005S\u0001A\u0011AAn\u0011\u001d\u0011i\u0003\u0001C\u0001\u00037DqA!\r\u0001\t\u0003\tY\u000eC\u0004\u00036\u0001!\t!a7\t\u000f\te\u0002\u0001\"\u0001\u0002\\\"9!Q\b\u0001\u0005\u0002\u0005m\u0007b\u0002B!\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005\u000b\u0002A\u0011AAn\u0011\u001d\u0011I\u0005\u0001C\u0001\u00037DqA!\u0014\u0001\t\u0003\tY\u000eC\u0004\u0003R\u0001!\t!a7\t\u000f\tU\u0003\u0001\"\u0001\u0002\\\"9!\u0011\f\u0001\u0005\u0002\u0005m\u0007b\u0002B/\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005C\u0002A\u0011AAn\u0011\u001d\u0011)\u0007\u0001C\u0001\u00037DqA!\u001b\u0001\t\u0003\tY\u000eC\u0004\u0003n\u0001!\t!a7\t\u000f\tE\u0004\u0001\"\u0001\u0002\\\"9!Q\u000f\u0001\u0005\u0002\u0005m\u0007b\u0002B=\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005{\u0002A\u0011AAn\u0011\u001d\u0011\t\t\u0001C\u0001\u00037DqA!\"\u0001\t\u0003\tY\u000eC\u0004\u0003\n\u0002!\t!a7\t\u000f\t5\u0005\u0001\"\u0001\u0002\\\"9!\u0011\u0013\u0001\u0005\u0002\u0005m\u0007b\u0002BK\u0001\u0011\u0005\u00111\u001c\u0005\b\u00053\u0003A\u0011AAn\u0011\u001d\u0011i\n\u0001C\u0001\u00037\u0014q\u0004V8qS\u000e\u001cu.\\7b]\u0012<\u0016\u000e\u001e5BI6Lgn\u00117jK:$H+Z:u\u0015\t9\u0005*A\u0003bI6LgNC\u0001J\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001'S1B\u0011Q\nU\u0007\u0002\u001d*\u0011q\nS\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002R\u001d\n12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002T-6\tAK\u0003\u0002V\u0011\u0006)Q\u000f^5mg&\u0011q\u000b\u0016\u0002\b\u0019><w-\u001b8h!\tI&,D\u0001G\u0013\tYfIA\u0007SC\u000e\\\u0017i^1sKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0003\"!\u0017\u0001\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012!\u0019\t\u0004E\u001eLW\"A2\u000b\u0005\u0011,\u0017AC2pY2,7\r^5p]*\ta-A\u0003tG\u0006d\u0017-\u0003\u0002iG\n\u00191+Z9\u0011\u0005)lW\"A6\u000b\u00051D\u0015AB:feZ,'/\u0003\u0002oW\nY1*\u00194lC\u000e{gNZ5h\u00035qW/\u001c)beRLG/[8ogV\t\u0011\u000f\u0005\u0002sg6\tQ-\u0003\u0002uK\n\u0019\u0011J\u001c;\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005AB-\u001a4bk2$(+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0016\u0003a\u0004\"A]=\n\u0005i,'!B*i_J$\u0018!\u00073fM\u0006,H\u000e\u001e*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\nA\u0002^8qS\u000e\u001cVM\u001d<jG\u0016,\u0012A \t\u0004\u007f\u0006Ma\u0002BA\u0001\u0003\u001fqA!a\u0001\u0002\u000e9!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n)\u000ba\u0001\u0010:p_Rt\u0014\"A%\n\u0005\u001dC\u0015bAA\t\r\u0006aAk\u001c9jG\u000e{W.\\1oI&!\u0011QCA\f\u0005]\tE-\\5o\u00072LWM\u001c;U_BL7mU3sm&\u001cWMC\u0002\u0002\u0012\u0019\u000b\u0001\u0003^8qS\u000e\u001cVM\u001d<jG\u0016|F%Z9\u0015\t\u0005u\u00111\u0005\t\u0004e\u0006}\u0011bAA\u0011K\n!QK\\5u\u0011!\t)\u0003CA\u0001\u0002\u0004q\u0018a\u0001=%c\u0005iAo\u001c9jGN+'O^5dK\u0002\n1\"\u00193nS:\u001cE.[3oiV\u0011\u0011Q\u0006\t\u0005\u0003_\t\t%\u0004\u0002\u00022)\u0019q)a\r\u000b\t\u0005U\u0012qG\u0001\bG2LWM\u001c;t\u0015\rI\u0015\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u007f\t1a\u001c:h\u0013\u0011\t\u0019%!\r\u0003\u000b\u0005#W.\u001b8\u0002\u001f\u0005$W.\u001b8DY&,g\u000e^0%KF$B!!\b\u0002J!I\u0011QE\u0006\u0002\u0002\u0003\u0007\u0011QF\u0001\rC\u0012l\u0017N\\\"mS\u0016tG\u000fI\u0001\u000ei\u0016\u001cH\u000fV8qS\u000et\u0015-\\3\u0016\u0005\u0005E\u0003\u0003BA*\u00037rA!!\u0016\u0002XA\u0019\u0011QA3\n\u0007\u0005eS-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\nyF\u0001\u0004TiJLgn\u001a\u0006\u0004\u00033*\u0017!\u0005;fgR$v\u000e]5d\u001d\u0006lWm\u0018\u0013fcR!\u0011QDA3\u0011%\t)CDA\u0001\u0002\u0004\t\t&\u0001\buKN$Hk\u001c9jG:\u000bW.\u001a\u0011\u0002\u0013}#Xm\u001d;OC6,WCAA7!\u0011\ty'!\u001f\u000e\u0005\u0005E$\u0002BA:\u0003k\nQA];mKNTA!a\u001e\u0002>\u0005)!.\u001e8ji&!\u00111PA9\u0005!!Vm\u001d;OC6,\u0017AC0uKN$h*Y7fA\u0005AA/Z:u\u001d\u0006lW\rK\u0002\u0013\u0003\u0007\u0003B!!\"\u0002\b6\u0011\u0011QO\u0005\u0005\u0003\u0013\u000b)H\u0001\u0003Sk2,\u0017AD1tg\u0016\u0014H/\u0012=ji\u000e{G-\u001a\u000b\u0007\u0003;\ty)a%\t\r\u0005E5\u00031\u0001r\u0003!)\u0007\u0010]3di\u0016$\u0007bBAK'\u0001\u0007\u0011qS\u0001\u0007[\u0016$\bn\u001c3\u0011\u000bI\fI*!\b\n\u0007\u0005mUMA\u0005Gk:\u001cG/[8oa\u00059\u0012m]:feR\u001c\u0005.Z2l\u0003J<7/\u0012=ji\u000e{G-\u001a\u000b\u0007\u0003;\t\t+a)\t\r\u0005EE\u00031\u0001r\u0011\u001d\t)\u000b\u0006a\u0001\u0003O\u000bqa\u001c9uS>t7\u000fE\u0002\u0000\u0003SKA!a+\u0002\u0018\t\u0019Bk\u001c9jG\u000e{W.\\1oI>\u0003H/[8og\u0006\u00112M]3bi\u0016\fe\u000eZ,bSR$v\u000e]5d)\u0011\ti\"!-\t\u000f\u0005MV\u00031\u0001\u0002(\u0006!q\u000e\u001d;t\u0003M9\u0018-\u001b;G_J$v\u000e]5d\u0007J,\u0017\r^3e)\u0019\ti\"!/\u0002>\"9\u00111\u0018\fA\u0002\u0005E\u0013!\u0003;pa&\u001cg*Y7f\u0011!\tyL\u0006I\u0001\u0002\u0004\t\u0018a\u0002;j[\u0016|W\u000f^\u0001\u001eo\u0006LGOR8s)>\u0004\u0018nY\"sK\u0006$X\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0019\u0016\u0004c\u0006\u001d7FAAe!\u0011\tY-!6\u000e\u0005\u00055'\u0002BAh\u0003#\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005MW-\u0001\u0006b]:|G/\u0019;j_:LA!a6\u0002N\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u000bM,G/\u001e9\u0015\u0005\u0005u\u0001f\u0001\r\u0002`B!\u0011QQAq\u0013\u0011\t\u0019/!\u001e\u0003\r\t+gm\u001c:f\u0003\u0015\u0019Gn\\:fQ\rI\u0012\u0011\u001e\t\u0005\u0003\u000b\u000bY/\u0003\u0003\u0002n\u0006U$!B!gi\u0016\u0014\u0018a\u0005;fgR\u0004\u0016M]:f\u0003N\u001c\u0018n\u001a8nK:$\bf\u0001\u000e\u0002tB!\u0011QQA{\u0013\u0011\t90!\u001e\u0003\tQ+7\u000f^\u0001$i\u0016\u001cH\u000fU1sg\u0016\f5o]5h]6,g\u000e\u001e#va2L7-\u0019;f\u000b:$(/[3tQ\rY\u00121_\u0001-i\u0016\u001cH\u000fU1sg\u0016\f5o]5h]6,g\u000e\u001e)beRLG/[8og>3G)\u001b4gKJ,g\u000e^*ju\u0016D3\u0001HAz\u0003\u0005\"Xm\u001d;D_:4\u0017nZ(qi^KG\u000f\u001b\"p_R\u001cHO]1q'\u0016\u0014h/\u001a:tQ\ri\u00121_\u0001\u000bi\u0016\u001cHo\u0011:fCR,\u0007f\u0001\u0010\u0002t\u00061B/Z:u\u0007J,\u0017\r^3XSRDG)\u001a4bk2$8\u000fK\u0002 \u0003g\f\u0001\u0005^3ti\u000e\u0013X-\u0019;f/&$\b\u000eR3gCVdGOU3qY&\u001c\u0017\r^5p]\"\u001a\u0001%a=\u0002?Q,7\u000f^\"sK\u0006$XmV5uQ\u0012+g-Y;miB\u000b'\u000f^5uS>t7\u000fK\u0002\"\u0003g\fQ\u0003^3ti\u000e\u0013X-\u0019;f/&$\bnQ8oM&<7\u000fK\u0002#\u0003g\f1\u0004^3ti\u000e\u0013X-\u0019;f\u0013\u001aLE/\u00117sK\u0006$\u00170\u0012=jgR\u001c\bfA\u0012\u0002t\u0006yB/Z:u\u0007J,\u0017\r^3XSRD'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;)\u0007\u0011\n\u00190\u0001\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]Z\fG.\u001b3SKBd\u0017nY1uS>tg)Y2u_JD3!JAz\u0003\u001d\"Xm\u001d;De\u0016\fG/Z,ji\"tUmZ1uSZ,'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:)\u0007\u0019\n\u00190A\u0015uKN$8I]3bi\u0016<\u0016\u000e\u001e5BgNLwM\\7f]R\fe\u000e\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0004O\u0005M\u0018\u0001\f;fgR\u001c%/Z1uK^KG\u000f[!tg&<g.\\3oi\u0006sGMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sQ\rA\u00131_\u0001%i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u001d\u0016<\u0017\r^5wKB\u000b'\u000f^5uS>t7i\\;oi\"\u001a\u0011&a=\u0002\u0007R,7\u000f^\"sK\u0006$XmV5uQVs7\u000f]3dS\u001aLW\r\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0006sG\rU1si&$\u0018n\u001c8t/&$\bNW6DY&,g\u000e\u001e\u0015\u0004U\u0005M\u0018a\u0007;fgRLeN^1mS\u0012$v\u000e]5d\u0019\u00164X\r\\\"p]\u001aLw\rK\u0002,\u0003g\fa\u0002^3ti2K7\u000f\u001e+pa&\u001c7\u000fK\u0002-\u0003g\f1\u0004^3ti2K7\u000f\u001e+pa&\u001c7oV5uQ^C\u0017\u000e^3mSN$\bfA\u0017\u0002t\u0006\tC/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i\u000bb\u001cG.\u001e3f\u0013:$XM\u001d8bY\"\u001aa&a=\u0002/Q,7\u000f^!mi\u0016\u0014\b+\u0019:uSRLwN\\\"pk:$\bfA\u0018\u0002t\u0006\u0019B/Z:u\u00032$XM]!tg&<g.\\3oi\"\u001a\u0001'a=\u0002gQ,7\u000f^!mi\u0016\u0014\u0018i]:jO:lWM\u001c;XSRDWj\u001c:f\u0003N\u001c\u0018n\u001a8nK:$H\u000b[1o!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0019\u0002t\u0006\u0019D/Z:u\u00032$XM]!tg&<g.\\3oi^KG\u000f['pe\u0016\u0004\u0016M\u001d;ji&|gn\u001d+iC:\f5o]5h]6,g\u000e\u001e\u0015\u0004e\u0005M\u0018A\t;fgR\fE\u000e^3s/&$\b.\u00138wC2LG\rU1si&$\u0018n\u001c8D_VtG\u000fK\u00024\u0003g\fa\u0005^3ti\u0006cG/\u001a:XSRDWK\\:qK\u000eLg-[3e!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\r!\u00141_\u0001\u001ei\u0016\u001cH/\u00117uKJ<\u0006.\u001a8U_BL7\rR8fg:$X\t_5ti\"\u001aQ'a=\u0002yQ,7\u000f^%g\u000bbL7\u000f^:B]\u0012LeMT8u\u000bbL7\u000f^:PaRLwN\\:J]Z\fG.\u001b3XSRD'i\\8ugR\u0014\u0018\r]*feZ,'o\u001d\u0015\u0004m\u0005M\u0018!\t;fgR\u001c%/Z1uK\u0006cG/\u001a:U_BL7mV5uQJ\u000b7m[!xCJ,\u0007fA\u001c\u0002t\u0006yC/Z:u\u0007>tg-[4Qe\u0016\u001cXM\u001d<bi&|g.Q2s_N\u001c\b+\u0019:uSRLwN\\!mi\u0016\u0014\u0018\r^5p]\"\u001a\u0001(a=\u0002#Q,7\u000f\u001e+pa&\u001cG)\u001a7fi&|g\u000eK\u0002:\u0003g\fq\u0003^3ti\u0012+G.\u001a;f\u0013:$XM\u001d8bYR{\u0007/[2)\u0007i\n\u00190\u0001\nuKN$H)\u001a7fi\u0016Le-\u0012=jgR\u001c\bfA\u001e\u0002t\u0006aA/Z:u\t\u0016\u001c8M]5cK\"\u001aA(a=\u0002CQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u00064\u0018-\u001b7bE2,\u0007+\u0019:uSRLwN\\:)\u0007u\n\u00190A\u0013uKN$H)Z:de&\u0014W-\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a)beRLG/[8og\"\u001aa(a=\u0002CQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u0012,'/T5o\u0013N\u0014\b+\u0019:uSRLwN\\:)\u0007}\n\u00190A!uKN$H)Z:de&\u0014W-\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a)beRLG/[8og^CWM\u001c*fCN\u001c\u0018n\u001a8nK:$\u0018j]%o!J|wM]3tg\"\u001a\u0001)a=\u0002=Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3Bi6Kg.S:s!\u0006\u0014H/\u001b;j_:\u001c\bfA!\u0002t\u00061C/Z:u\t\u0016\u001c8M]5cKVsG-\u001a:NS:L5O\u001d)beRLG/[8og6K\u00070\u001a3)\u0007\t\u000b\u00190A\u0012uKN$H)Z:de&\u0014WMU3q_J$xJ^3se&$G-\u001a8D_:4\u0017nZ:)\u0007\r\u000b\u00190\u0001\u0018uKN$H)Z:de&\u0014W-\u00118e\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i_V$\u0018J\u001c;fe:\fG\u000eV8qS\u000e\u001c\bf\u0001#\u0002t\u0002")
public class TopicCommandWithAdminClientTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor;
    private TopicCommand.AdminClientTopicService topicService;
    private Admin adminClient;
    private String testTopicName;
    private final TestName _testName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        int x$1 = 6;
        String x$2 = this.zkConnect();
        Tuple2[] tuple2Array = new Tuple2[6];
        String string = "rack1";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        String string2 = "rack2";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        String string3 = "rack2";
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        String string4 = "rack1";
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string5 = "rack3";
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string6 = "rack3";
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[5] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Map<Object, String>)x$3, x$15, x$16, x$4, x$5).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.AdminClientTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.AdminClientTopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    /*
     * WARNING - void declaration
     */
    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(exitCode, exitMessage) -> TopicCommandWithAdminClientTest.mockExitProcedure$1(BoxesRunTime.unboxToInt((Object)exitCode), exitMessage, expected);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Assertions$.MODULE$.intercept(method, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    public void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        this.assertExitCode(expected, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> options.checkArgs());
    }

    public void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    public void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topicName, 0, timeout);
    }

    public int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Before
    public void setup() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq(Admin.create((Properties)props));
        this.topicService_$eq(TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient()));
        this.testTopicName_$eq(new StringBuilder(1).append(this.testName().getMethodName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @After
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testParseAssignment() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        Tuple2[] tuple2Array = new Tuple2[3];
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        List list3 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Object)actualAssignment);
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:5"), ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1"), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--config", "cleanup.policy=compact"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--delete-config", "cleanup.policy"})));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--topic", this.testTopicName(), "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"}));
        opts.checkArgs();
        Assert.assertTrue((boolean)opts.hasCreateOption());
        Assert.assertEquals((Object)this.brokerList(), (Object)opts.bootstrapServer().get());
        Assert.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()})));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @Test
    public void testCreateWithDefaults() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultReplication() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)2L);
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultPartitions() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)2L);
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"})));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1000), (Object)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateIfItAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)3L, (long)partitions.size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)32768)).toString(), "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
    }

    @Test
    public void testCreateWithUnspecifiedReplicationFactorAndPartitionsWithZkClient() {
        this.assertExitCode(1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--create", "--zookeeper", "zk", "--topic", this.testTopicName()})).checkArgs());
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assert.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopicsWithWhitelist() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic2, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic3, 2, (short)2), (List)Nil$.MODULE$)))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)string.contains(topic1));
        Assert.assertTrue((boolean)string.contains(topic2));
        Assert.assertFalse((boolean)string.contains(topic3));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic("__consumer_offsets", 2, (short)2), (List)Nil$.MODULE$))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)string.contains(topic1));
        Assert.assertFalse((boolean)string.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"})));
        Assert.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAlterAssignment() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName()})));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1"}));
        TopicCommand.AdminClientTopicService topicService = TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicService.alterTopic(alterOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
    }

    @Test
    public void testIfExistsAndIfNotExistsOptionsInvalidWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--alter", "--if-exists", "--topic", this.testTopicName(), "--partitions", "1"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--create", "--if-not-exists", "--topic", this.testTopicName(), "--partitions", "1", "--replication-factor", "1"})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateAlterTopicWithRackAware() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        Tuple2[] tuple2Array = new Tuple2[6];
        String string = "rack1";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        String string2 = "rack2";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        String string3 = "rack2";
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        String string4 = "rack1";
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string5 = "rack3";
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string6 = "rack3";
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[5] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_$this;
            Seq replicas;
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                replicas = (Seq)x0$1._2();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition()));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)alteredNumPartitions)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void $minus$greater$extension_$this;
            Seq replicas;
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                replicas = (Seq)x0$2._2();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition()));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsModified)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.testTopicName(), 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "__consumer_offsets", 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteIfExists() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertEquals((long)3L, (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:2").toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            TopicDescription testTopicDescription = (TopicDescription)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).asScala()).apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(testTopicDescription.partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$1(x$5))).get()).partition();
            this.killBroker(0);
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$7(this), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderReplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitions$1(x$9)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Assert.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitions$1(x$10)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Assert.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress() {
        HashMap configMap = new HashMap();
        short replicationFactor = 1;
        int partitions = 1;
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), partitions, replicationFactor).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.servers().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$11)), Buffer$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).all().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(testTopicDesc.partitions()).asScala()).head();
        Buffer replicasOfFirstPartition = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(firstPartition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()), Buffer$.MODULE$.canBuildFrom());
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)brokerIds.diff((GenSeq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(targetReplica))))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] simpleDescribeOutputRows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
        Assert.assertEquals((long)2L, (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])simpleDescribeOutputRows)).size());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out2.toString();
        Assert.assertEquals((String)"--under-replicated-partitions shouldn't return anything", (Object)"", (Object)string);
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), TestUtils$.MODULE$.waitForAllReassignmentsToComplete$default$2());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeAtMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            this.killBroker(1);
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--at-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertEquals((long)1L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderMinIsrPartitionsMixed() {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})))})).all().get();
        this.waitForTopicCreated(underMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(notUnderMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(offlineTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(fullyReplicatedTopic, this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(x$13)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, underMinIsrTopic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assert.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assert.assertEquals((long)2L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeReportOverriddenConfigs() {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString(), (boolean)string.contains(config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString(), (boolean)string.contains(this.testTopicName()));
        Assert.assertFalse((boolean)string.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = grabConsoleOutput_out2.toString();
        Assert.assertTrue((boolean)string2.contains(this.testTopicName()));
        Assert.assertFalse((boolean)string2.contains("__consumer_offsets"));
    }

    private static final Nothing$ mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assert.assertEquals((long)expected$1, (long)exitCode);
        throw new RuntimeException();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$5) {
        return x$5.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaServer x$6) {
        return x$6.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandWithAdminClientTest $this, MetadataResponse.TopicMetadata x$7) {
        return x$7.topic().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponse.PartitionMetadata x$8) {
        return x$8.partition() == partitionOnBroker0$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1, boolean result, KafkaServer server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()}));
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)x$1, x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)topicMetadatas.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$7))).get()).partitionMetadata()).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$8)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw Assertions$.MODULE$.fail("Partition metadata is not found in metadata cache", new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
        }
        if (!(testPartitionMetadata instanceof Some)) throw new MatchError((Object)testPartitionMetadata);
        MetadataResponse.PartitionMetadata metadata = (MetadataResponse.PartitionMetadata)((Some)testPartitionMetadata).value();
        if (!result) return false;
        Errors errors = metadata.error;
        Errors errors2 = Errors.LEADER_NOT_AVAILABLE;
        if (errors != null) {
            if (!errors.equals(errors2)) return false;
            return true;
        }
        if (errors2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)$this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$3(x$6)))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandWithAdminClientTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitions$1(KafkaServer x$9) {
        return x$9.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(KafkaServer x$10) {
        return x$10.config().brokerId() == 0;
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaServer x$11) {
        return x$11.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandWithAdminClientTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(KafkaServer x$13) {
        return x$13.config().brokerId() == 0;
    }

    public TopicCommandWithAdminClientTest() {
        RackAwareTest.$init$(this);
        this.numPartitions = 1;
        this.defaultReplicationFactor = (short)1;
        this._testName = new TestName();
    }
}

