/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.zk.AclChangeNode;
import kafka.zk.ExtendedAclStore;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m3AAD\b\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003B\u0002\u0018\u0001A\u0003%\u0011\u0005C\u00040\u0001\t\u0007I\u0011\u0002\u0011\t\rA\u0002\u0001\u0015!\u0003\"\u0011\u001d\t\u0004A1A\u0005\nIBaA\u000e\u0001!\u0002\u0013\u0019\u0004\"B\u001c\u0001\t\u0003A\u0004\"B\"\u0001\t\u0003A\u0004\"B#\u0001\t\u0003A\u0004\"B+\u0001\t\u0003A\u0004\"B,\u0001\t\u0003A\u0004\"B-\u0001\t\u0003A$\u0001F#yi\u0016tG-\u001a3BG2\u001cFo\u001c:f)\u0016\u001cHO\u0003\u0002\u0011#\u0005\u0011!p\u001b\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011aD\u0001\u0010Y&$XM]1m%\u0016\u001cx.\u001e:dKV\t\u0011\u0005\u0005\u0002#Y5\t1E\u0003\u0002%K\u0005A!/Z:pkJ\u001cWM\u0003\u0002'O\u000511m\\7n_:T!A\u0005\u0015\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0005\u0003[\r\u0012qBU3t_V\u00148-\u001a)biR,'O\\\u0001\u0011Y&$XM]1m%\u0016\u001cx.\u001e:dK\u0002\n\u0001\u0003\u001d:fM&DX\r\u001a*fg>,(oY3\u0002#A\u0014XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007%A\u0003ti>\u0014X-F\u00014!\tqB'\u0003\u00026\u001f\t\u0001R\t\u001f;f]\u0012,G-Q2m'R|'/Z\u0001\u0007gR|'/\u001a\u0011\u0002-MDw.\u001e7e\u0011\u00064XmQ8se\u0016\u001cG\u000fU1uQN$\u0012!\u000f\t\u0003-iJ!aO\f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0011u\u0002\"AP!\u000e\u0003}R!\u0001\u0011\u0016\u0002\u000b),h.\u001b;\n\u0005\t{$\u0001\u0002+fgR\fAd\u001d5pk2$\u0007*\u0019<f\u0007>\u0014(/Z2u!\u0006$H/\u001a:o)f\u0004X\r\u000b\u0002\n{\u0005\u00193\u000f[8vY\u0012$\u0006N]8x\u0013\u001a\u001cuN\\:ueV\u001cG/\u001a3XSRDG*\u001b;fe\u0006d\u0007\u0006\u0002\u0006>\u000f\"\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002\u0013B\u0011!J\u0015\b\u0003\u0017Bs!\u0001T(\u000e\u00035S!AT\n\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0012BA)\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0015+\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gN\u0003\u0002R/\u0005q2\u000f[8vY\u0012$\u0006N]8x\rJ|W.\u00128d_\u0012,wJ\u001c'ji\u0016\u0014\u0018\r\u001c\u0015\u0005\u0017u:\u0005*\u0001\u0011tQ>,H\u000eZ,sSR,7\t[1oO\u0016\u001cHk\u001c+iK^\u0013\u0018\u000e^3QCRD\u0007F\u0001\u0007>\u0003e\u0019\bn\\;mIJ{WO\u001c3Ue&\u00048\t[1oO\u0016tu\u000eZ3)\u00055i\u0004")
public class ExtendedAclStoreTest {
    private final ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, "some-topic", PatternType.LITERAL);
    private final ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "some-topic", PatternType.PREFIXED);
    private final ExtendedAclStore store = new ExtendedAclStore(PatternType.PREFIXED);

    private ResourcePattern literalResource() {
        return this.literalResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ExtendedAclStore store() {
        return this.store;
    }

    @Test
    public void shouldHaveCorrectPaths() {
        Assert.assertEquals((Object)"/kafka-acl-extended/prefixed", (Object)this.store().aclPath());
        Assert.assertEquals((Object)"/kafka-acl-extended/prefixed/Topic", (Object)this.store().path(ResourceType.TOPIC));
        Assert.assertEquals((Object)"/kafka-acl-extended-changes", (Object)this.store().changeStore().aclChangePath());
    }

    @Test
    public void shouldHaveCorrectPatternType() {
        Assert.assertEquals((Object)PatternType.PREFIXED, (Object)this.store().patternType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfConstructedWithLiteral() {
        new ExtendedAclStore(PatternType.LITERAL);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowFromEncodeOnLiteral() {
        this.store().changeStore().createChangeNode(this.literalResource());
    }

    @Test
    public void shouldWriteChangesToTheWritePath() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.prefixedResource());
        Assert.assertEquals((Object)"/kafka-acl-extended-changes/acl_changes_", (Object)changeNode.path());
    }

    @Test
    public void shouldRoundTripChangeNode() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.prefixedResource());
        ResourcePattern actual = this.store().changeStore().decode(changeNode.bytes());
        Assert.assertEquals((Object)this.prefixedResource(), (Object)actual);
    }
}

