/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.math.VarLongWritable;

public class ItemFilterMapper
extends Mapper<LongWritable, Text, VarLongWritable, VarLongWritable> {
    private static final Pattern SEPARATOR = Pattern.compile("[\t,]");
    private final VarLongWritable itemIDWritable = new VarLongWritable();
    private final VarLongWritable userIDWritable = new VarLongWritable();

    protected void map(LongWritable key, Text line, Mapper.Context ctx) throws IOException, InterruptedException {
        String[] tokens = SEPARATOR.split(line.toString());
        long userID = Long.parseLong(tokens[0]);
        long itemID = Long.parseLong(tokens[1]);
        this.itemIDWritable.set(itemID);
        this.userIDWritable.set(userID);
        ctx.write((Object)this.itemIDWritable, (Object)this.userIDWritable);
    }
}

