/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import org.apache.commons.io.Charsets;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.model.IDMigrator;

public abstract class AbstractIDMigrator
implements IDMigrator {
    private final MessageDigest md5Digest;

    protected AbstractIDMigrator() {
        try {
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long hash(String value) {
        byte[] md5hash;
        MessageDigest messageDigest = this.md5Digest;
        synchronized (messageDigest) {
            md5hash = this.md5Digest.digest(value.getBytes(Charsets.UTF_8));
            this.md5Digest.reset();
        }
        long hash = 0L;
        for (int i = 0; i < 8; ++i) {
            hash = hash << 8 | (long)md5hash[i] & 0xFFL;
        }
        return hash;
    }

    @Override
    public long toLongID(String stringID) {
        return this.hash(stringID);
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }
}

