/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.file;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.AbstractDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericBooleanPrefDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.iterator.FileLineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataModel
extends AbstractDataModel {
    private static final Logger log = LoggerFactory.getLogger(FileDataModel.class);
    public static final long DEFAULT_MIN_RELOAD_INTERVAL_MS = 60000L;
    private static final char COMMENT_CHAR = '#';
    private static final char[] DELIMIETERS = new char[]{',', '\t'};
    private final File dataFile;
    private long lastModified;
    private long lastUpdateFileModified;
    private final transient Splitter delimiterPattern;
    private final boolean hasPrefValues;
    private DataModel delegate;
    private final ReentrantLock reloadLock;
    private final boolean transpose;
    private final long minReloadIntervalMS;

    public FileDataModel(File dataFile) throws IOException {
        this(dataFile, false, 60000L);
    }

    public FileDataModel(File dataFile, String delimiterRegex) throws IOException {
        this(dataFile, false, 60000L, delimiterRegex);
    }

    public FileDataModel(File dataFile, boolean transpose, long minReloadIntervalMS) throws IOException {
        this(dataFile, transpose, minReloadIntervalMS, null);
    }

    public FileDataModel(File dataFile, boolean transpose, long minReloadIntervalMS, String delimiterRegex) throws IOException {
        char delimiter;
        this.dataFile = (File)Preconditions.checkNotNull((Object)dataFile.getAbsoluteFile());
        if (!dataFile.exists() || dataFile.isDirectory()) {
            throw new FileNotFoundException(dataFile.toString());
        }
        Preconditions.checkArgument((dataFile.length() > 0L ? 1 : 0) != 0, (Object)"dataFile is empty");
        Preconditions.checkArgument((minReloadIntervalMS >= 0L ? 1 : 0) != 0, (Object)"minReloadIntervalMs must be non-negative");
        log.info("Creating FileDataModel for file {}", (Object)dataFile);
        this.lastModified = dataFile.lastModified();
        this.lastUpdateFileModified = this.readLastUpdateFileModified();
        FileLineIterator iterator = new FileLineIterator(dataFile, false);
        String firstLine = (String)iterator.peek();
        while (firstLine.isEmpty() || firstLine.charAt(0) == '#') {
            iterator.next();
            firstLine = (String)iterator.peek();
        }
        Closeables.close((Closeable)iterator, (boolean)true);
        if (delimiterRegex == null) {
            delimiter = FileDataModel.determineDelimiter(firstLine);
            this.delimiterPattern = Splitter.on((char)delimiter);
        } else {
            delimiter = '\u0000';
            this.delimiterPattern = Splitter.onPattern((String)delimiterRegex);
            if (!this.delimiterPattern.split((CharSequence)firstLine).iterator().hasNext()) {
                throw new IllegalArgumentException("Did not find a delimiter(pattern) in first line");
            }
        }
        ArrayList<String> firstLineSplit = new ArrayList<String>();
        for (String token : this.delimiterPattern.split((CharSequence)firstLine)) {
            firstLineSplit.add(token);
        }
        this.hasPrefValues = firstLineSplit.size() >= 3 && !((String)firstLineSplit.get(2)).isEmpty();
        this.reloadLock = new ReentrantLock();
        this.transpose = transpose;
        this.minReloadIntervalMS = minReloadIntervalMS;
        this.reload();
    }

    public File getDataFile() {
        return this.dataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reload() {
        if (this.reloadLock.tryLock()) {
            try {
                this.delegate = this.buildModel();
            }
            catch (IOException ioe) {
                log.warn("Exception while reloading", (Throwable)ioe);
            }
            finally {
                this.reloadLock.unlock();
            }
        }
    }

    protected DataModel buildModel() throws IOException {
        long newLastModified = this.dataFile.lastModified();
        long newLastUpdateFileModified = this.readLastUpdateFileModified();
        boolean loadFreshData = this.delegate == null || newLastModified > this.lastModified + this.minReloadIntervalMS;
        long oldLastUpdateFileModifieid = this.lastUpdateFileModified;
        this.lastModified = newLastModified;
        this.lastUpdateFileModified = newLastUpdateFileModified;
        FastByIDMap<FastByIDMap<Long>> timestamps = new FastByIDMap<FastByIDMap<Long>>();
        if (this.hasPrefValues) {
            if (loadFreshData) {
                FastByIDMap<Collection<Preference>> data = new FastByIDMap<Collection<Preference>>();
                FileLineIterator iterator = new FileLineIterator(this.dataFile, false);
                this.processFile(iterator, data, timestamps, false);
                for (File updateFile : this.findUpdateFilesAfter(newLastModified)) {
                    this.processFile(new FileLineIterator(updateFile, false), data, timestamps, false);
                }
                return new GenericDataModel(GenericDataModel.toDataMap(data, true), timestamps);
            }
            FastByIDMap<PreferenceArray> rawData = ((GenericDataModel)this.delegate).getRawUserData();
            for (File updateFile : this.findUpdateFilesAfter(Math.max(oldLastUpdateFileModifieid, newLastModified))) {
                this.processFile(new FileLineIterator(updateFile, false), rawData, timestamps, true);
            }
            return new GenericDataModel(rawData, timestamps);
        }
        if (loadFreshData) {
            FastByIDMap<FastIDSet> data = new FastByIDMap<FastIDSet>();
            FileLineIterator iterator = new FileLineIterator(this.dataFile, false);
            this.processFileWithoutID(iterator, data, timestamps);
            for (File updateFile : this.findUpdateFilesAfter(newLastModified)) {
                this.processFileWithoutID(new FileLineIterator(updateFile, false), data, timestamps);
            }
            return new GenericBooleanPrefDataModel(data, timestamps);
        }
        FastByIDMap<FastIDSet> rawData = ((GenericBooleanPrefDataModel)this.delegate).getRawUserData();
        for (File updateFile : this.findUpdateFilesAfter(Math.max(oldLastUpdateFileModifieid, newLastModified))) {
            this.processFileWithoutID(new FileLineIterator(updateFile, false), rawData, timestamps);
        }
        return new GenericBooleanPrefDataModel(rawData, timestamps);
    }

    private Iterable<File> findUpdateFilesAfter(long minimumLastModified) {
        String dataFileName = this.dataFile.getName();
        int period = dataFileName.indexOf(46);
        String startName = period < 0 ? dataFileName : dataFileName.substring(0, period);
        File parentDir = this.dataFile.getParentFile();
        TreeMap<Long, File> modTimeToUpdateFile = new TreeMap<Long, File>();
        FileFilter onlyFiles = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory();
            }
        };
        for (File updateFile : parentDir.listFiles(onlyFiles)) {
            String updateFileName = updateFile.getName();
            if (!updateFileName.startsWith(startName) || updateFileName.equals(dataFileName) || updateFile.lastModified() < minimumLastModified) continue;
            modTimeToUpdateFile.put(updateFile.lastModified(), updateFile);
        }
        return modTimeToUpdateFile.values();
    }

    private long readLastUpdateFileModified() {
        long mostRecentModification = Long.MIN_VALUE;
        for (File updateFile : this.findUpdateFilesAfter(0L)) {
            mostRecentModification = Math.max(mostRecentModification, updateFile.lastModified());
        }
        return mostRecentModification;
    }

    public static char determineDelimiter(String line) {
        for (char possibleDelimieter : DELIMIETERS) {
            if (line.indexOf(possibleDelimieter) < 0) continue;
            return possibleDelimieter;
        }
        throw new IllegalArgumentException("Did not find a delimiter in first line");
    }

    protected void processFile(FileLineIterator dataOrUpdateFileIterator, FastByIDMap<?> data, FastByIDMap<FastByIDMap<Long>> timestamps, boolean fromPriorData) {
        log.info("Reading file info...");
        int count = 0;
        while (dataOrUpdateFileIterator.hasNext()) {
            String line = (String)dataOrUpdateFileIterator.next();
            if (line.isEmpty()) continue;
            this.processLine(line, data, timestamps, fromPriorData);
            if (++count % 1000000 != 0) continue;
            log.info("Processed {} lines", (Object)count);
        }
        log.info("Read lines: {}", (Object)count);
    }

    /*
     * WARNING - void declaration
     */
    protected void processLine(String line, FastByIDMap<?> data, FastByIDMap<FastByIDMap<Long>> timestamps, boolean fromPriorData) {
        if (line.isEmpty() || line.charAt(0) == '#') {
            return;
        }
        Iterator tokens = this.delimiterPattern.split((CharSequence)line).iterator();
        String userIDString = (String)tokens.next();
        String itemIDString = (String)tokens.next();
        String preferenceValueString = (String)tokens.next();
        boolean hasTimestamp = tokens.hasNext();
        String timestampString = hasTimestamp ? (String)tokens.next() : null;
        long userID = this.readUserIDFromString(userIDString);
        long itemID = this.readItemIDFromString(itemIDString);
        if (this.transpose) {
            long tmp = userID;
            userID = itemID;
            itemID = tmp;
        }
        Object maybePrefs = data.get(userID);
        if (fromPriorData) {
            PreferenceArray prefs = (PreferenceArray)maybePrefs;
            if (!hasTimestamp && preferenceValueString.isEmpty()) {
                if (prefs != null) {
                    boolean exists = false;
                    int length = prefs.length();
                    for (int i = 0; i < length; ++i) {
                        if (prefs.getItemID(i) != itemID) continue;
                        exists = true;
                        break;
                    }
                    if (exists) {
                        if (length == 1) {
                            data.remove(userID);
                        } else {
                            void var20_31;
                            GenericUserPreferenceArray newPrefs = new GenericUserPreferenceArray(length - 1);
                            boolean bl = false;
                            int j = 0;
                            while (var20_31 < length) {
                                if (prefs.getItemID((int)var20_31) == itemID) {
                                    --j;
                                } else {
                                    newPrefs.set(j, prefs.get((int)var20_31));
                                }
                                ++var20_31;
                                ++j;
                            }
                            data.put(userID, newPrefs);
                        }
                    }
                }
                FileDataModel.removeTimestamp(userID, itemID, timestamps);
            } else {
                float preferenceValue = Float.parseFloat(preferenceValueString);
                boolean exists = false;
                if (prefs != null) {
                    for (int i = 0; i < prefs.length(); ++i) {
                        if (prefs.getItemID(i) != itemID) continue;
                        exists = true;
                        prefs.setValue(i, preferenceValue);
                        break;
                    }
                }
                if (!exists) {
                    if (prefs == null) {
                        prefs = new GenericUserPreferenceArray(1);
                    } else {
                        void var20_33;
                        GenericUserPreferenceArray newPrefs = new GenericUserPreferenceArray(prefs.length() + 1);
                        boolean bl = false;
                        int j = 1;
                        while (var20_33 < prefs.length()) {
                            newPrefs.set(j, prefs.get((int)var20_33));
                            ++var20_33;
                            ++j;
                        }
                        prefs = newPrefs;
                    }
                    prefs.setUserID(0, userID);
                    prefs.setItemID(0, itemID);
                    prefs.setValue(0, preferenceValue);
                    data.put(userID, prefs);
                }
            }
            this.addTimestamp(userID, itemID, timestampString, timestamps);
        } else {
            ArrayList<GenericPreference> prefs = (ArrayList<GenericPreference>)maybePrefs;
            if (!hasTimestamp && preferenceValueString.isEmpty()) {
                if (prefs != null) {
                    Iterator prefsIterator = prefs.iterator();
                    while (prefsIterator.hasNext()) {
                        Preference pref = (Preference)prefsIterator.next();
                        if (pref.getItemID() != itemID) continue;
                        prefsIterator.remove();
                        break;
                    }
                }
                FileDataModel.removeTimestamp(userID, itemID, timestamps);
            } else {
                float preferenceValue = Float.parseFloat(preferenceValueString);
                boolean exists = false;
                if (prefs != null) {
                    for (Preference preference : prefs) {
                        if (preference.getItemID() != itemID) continue;
                        exists = true;
                        preference.setValue(preferenceValue);
                        break;
                    }
                }
                if (!exists) {
                    if (prefs == null) {
                        prefs = new ArrayList<GenericPreference>(2);
                        data.put(userID, prefs);
                    }
                    prefs.add(new GenericPreference(userID, itemID, preferenceValue));
                }
                this.addTimestamp(userID, itemID, timestampString, timestamps);
            }
        }
    }

    protected void processFileWithoutID(FileLineIterator dataOrUpdateFileIterator, FastByIDMap<FastIDSet> data, FastByIDMap<FastByIDMap<Long>> timestamps) {
        log.info("Reading file info...");
        int count = 0;
        while (dataOrUpdateFileIterator.hasNext()) {
            String line = (String)dataOrUpdateFileIterator.next();
            if (line.isEmpty()) continue;
            this.processLineWithoutID(line, data, timestamps);
            if (++count % 100000 != 0) continue;
            log.info("Processed {} lines", (Object)count);
        }
        log.info("Read lines: {}", (Object)count);
    }

    protected void processLineWithoutID(String line, FastByIDMap<FastIDSet> data, FastByIDMap<FastByIDMap<Long>> timestamps) {
        if (line.isEmpty() || line.charAt(0) == '#') {
            return;
        }
        Iterator tokens = this.delimiterPattern.split((CharSequence)line).iterator();
        String userIDString = (String)tokens.next();
        String itemIDString = (String)tokens.next();
        boolean hasPreference = tokens.hasNext();
        String preferenceValueString = hasPreference ? (String)tokens.next() : "";
        boolean hasTimestamp = tokens.hasNext();
        String timestampString = hasTimestamp ? (String)tokens.next() : null;
        long userID = this.readUserIDFromString(userIDString);
        long itemID = this.readItemIDFromString(itemIDString);
        if (this.transpose) {
            long tmp = userID;
            userID = itemID;
            itemID = tmp;
        }
        if (hasPreference && !hasTimestamp && preferenceValueString.isEmpty()) {
            FastIDSet itemIDs = data.get(userID);
            if (itemIDs != null) {
                itemIDs.remove(itemID);
            }
            FileDataModel.removeTimestamp(userID, itemID, timestamps);
        } else {
            FastIDSet itemIDs = data.get(userID);
            if (itemIDs == null) {
                itemIDs = new FastIDSet(2);
                data.put(userID, itemIDs);
            }
            itemIDs.add(itemID);
            this.addTimestamp(userID, itemID, timestampString, timestamps);
        }
    }

    private void addTimestamp(long userID, long itemID, String timestampString, FastByIDMap<FastByIDMap<Long>> timestamps) {
        if (timestampString != null) {
            FastByIDMap<Long> itemTimestamps = timestamps.get(userID);
            if (itemTimestamps == null) {
                itemTimestamps = new FastByIDMap();
                timestamps.put(userID, itemTimestamps);
            }
            long timestamp = this.readTimestampFromString(timestampString);
            itemTimestamps.put(itemID, timestamp);
        }
    }

    private static void removeTimestamp(long userID, long itemID, FastByIDMap<FastByIDMap<Long>> timestamps) {
        FastByIDMap<Long> itemTimestamps = timestamps.get(userID);
        if (itemTimestamps != null) {
            itemTimestamps.remove(itemID);
        }
    }

    protected long readUserIDFromString(String value) {
        return Long.parseLong(value);
    }

    protected long readItemIDFromString(String value) {
        return Long.parseLong(value);
    }

    protected long readTimestampFromString(String value) {
        return Long.parseLong(value);
    }

    @Override
    public LongPrimitiveIterator getUserIDs() throws TasteException {
        return this.delegate.getUserIDs();
    }

    @Override
    public PreferenceArray getPreferencesFromUser(long userID) throws TasteException {
        return this.delegate.getPreferencesFromUser(userID);
    }

    @Override
    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        return this.delegate.getItemIDsFromUser(userID);
    }

    @Override
    public LongPrimitiveIterator getItemIDs() throws TasteException {
        return this.delegate.getItemIDs();
    }

    @Override
    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        return this.delegate.getPreferencesForItem(itemID);
    }

    @Override
    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        return this.delegate.getPreferenceValue(userID, itemID);
    }

    @Override
    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        return this.delegate.getPreferenceTime(userID, itemID);
    }

    @Override
    public int getNumItems() throws TasteException {
        return this.delegate.getNumItems();
    }

    @Override
    public int getNumUsers() throws TasteException {
        return this.delegate.getNumUsers();
    }

    @Override
    public int getNumUsersWithPreferenceFor(long itemID) throws TasteException {
        return this.delegate.getNumUsersWithPreferenceFor(itemID);
    }

    @Override
    public int getNumUsersWithPreferenceFor(long itemID1, long itemID2) throws TasteException {
        return this.delegate.getNumUsersWithPreferenceFor(itemID1, itemID2);
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.delegate.setPreference(userID, itemID, value);
    }

    @Override
    public void removePreference(long userID, long itemID) throws TasteException {
        this.delegate.removePreference(userID, itemID);
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        if (this.dataFile.lastModified() > this.lastModified + this.minReloadIntervalMS || this.readLastUpdateFileModified() > this.lastUpdateFileModified + this.minReloadIntervalMS) {
            log.debug("File has changed; reloading...");
            this.reload();
        }
    }

    @Override
    public boolean hasPreferenceValues() {
        return this.delegate.hasPreferenceValues();
    }

    @Override
    public float getMaxPreference() {
        return this.delegate.getMaxPreference();
    }

    @Override
    public float getMinPreference() {
        return this.delegate.getMinPreference();
    }

    public String toString() {
        return "FileDataModel[dataFile:" + this.dataFile + ']';
    }
}

