/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;
import org.apache.mahout.cf.taste.impl.recommender.AbstractRecommender;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemAverageRecommender
extends AbstractRecommender {
    private static final Logger log = LoggerFactory.getLogger(ItemAverageRecommender.class);
    private final FastByIDMap<RunningAverage> itemAverages = new FastByIDMap();
    private final ReadWriteLock buildAveragesLock = new ReentrantReadWriteLock();
    private final RefreshHelper refreshHelper = new RefreshHelper(new Callable<Object>(){

        @Override
        public Object call() throws TasteException {
            ItemAverageRecommender.this.buildAverageDiffs();
            return null;
        }
    });

    public ItemAverageRecommender(DataModel dataModel) throws TasteException {
        super(dataModel);
        this.refreshHelper.addDependency(dataModel);
        this.buildAverageDiffs();
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer, boolean includeKnownItems) throws TasteException {
        Preconditions.checkArgument((howMany >= 1 ? 1 : 0) != 0, (Object)"howMany must be at least 1");
        log.debug("Recommending items for user ID '{}'", (Object)userID);
        PreferenceArray preferencesFromUser = this.getDataModel().getPreferencesFromUser(userID);
        FastIDSet possibleItemIDs = this.getAllOtherItems(userID, preferencesFromUser, includeKnownItems);
        Estimator estimator = new Estimator();
        List<RecommendedItem> topItems = TopItems.getTopItems(howMany, possibleItemIDs.iterator(), rescorer, estimator);
        log.debug("Recommendations are: {}", topItems);
        return topItems;
    }

    @Override
    public float estimatePreference(long userID, long itemID) throws TasteException {
        DataModel dataModel = this.getDataModel();
        Float actualPref = dataModel.getPreferenceValue(userID, itemID);
        if (actualPref != null) {
            return actualPref.floatValue();
        }
        return this.doEstimatePreference(itemID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float doEstimatePreference(long itemID) {
        this.buildAveragesLock.readLock().lock();
        try {
            RunningAverage average = this.itemAverages.get(itemID);
            float f = average == null ? Float.NaN : (float)average.getAverage();
            return f;
        }
        finally {
            this.buildAveragesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildAverageDiffs() throws TasteException {
        try {
            this.buildAveragesLock.writeLock().lock();
            DataModel dataModel = this.getDataModel();
            LongPrimitiveIterator it = dataModel.getUserIDs();
            while (it.hasNext()) {
                PreferenceArray prefs = dataModel.getPreferencesFromUser(it.nextLong());
                int size = prefs.length();
                for (int i = 0; i < size; ++i) {
                    long itemID = prefs.getItemID(i);
                    RunningAverage average = this.itemAverages.get(itemID);
                    if (average == null) {
                        average = new FullRunningAverage();
                        this.itemAverages.put(itemID, average);
                    }
                    average.addDatum(prefs.getValue(i));
                }
            }
        }
        finally {
            this.buildAveragesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        double prefDelta;
        DataModel dataModel = this.getDataModel();
        try {
            Float oldPref = dataModel.getPreferenceValue(userID, itemID);
            prefDelta = oldPref == null ? (double)value : (double)(value - oldPref.floatValue());
        }
        catch (NoSuchUserException nsee) {
            prefDelta = value;
        }
        super.setPreference(userID, itemID, value);
        try {
            this.buildAveragesLock.writeLock().lock();
            RunningAverage average = this.itemAverages.get(itemID);
            if (average == null) {
                FullRunningAverage newAverage = new FullRunningAverage();
                newAverage.addDatum(prefDelta);
                this.itemAverages.put(itemID, newAverage);
            } else {
                average.changeDatum(prefDelta);
            }
        }
        finally {
            this.buildAveragesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePreference(long userID, long itemID) throws TasteException {
        DataModel dataModel = this.getDataModel();
        Float oldPref = dataModel.getPreferenceValue(userID, itemID);
        super.removePreference(userID, itemID);
        if (oldPref != null) {
            try {
                this.buildAveragesLock.writeLock().lock();
                RunningAverage average = this.itemAverages.get(itemID);
                if (average == null) {
                    throw new IllegalStateException("No preferences exist for item ID: " + itemID);
                }
                average.removeDatum(oldPref.floatValue());
            }
            finally {
                this.buildAveragesLock.writeLock().unlock();
            }
        }
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    public String toString() {
        return "ItemAverageRecommender";
    }

    private final class Estimator
    implements TopItems.Estimator<Long> {
        private Estimator() {
        }

        @Override
        public double estimate(Long itemID) {
            return ItemAverageRecommender.this.doEstimatePreference(itemID);
        }
    }
}

