/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.df.node.Node;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;

@Deprecated
public final class DFUtils {
    private DFUtils() {
    }

    public static void writeArray(DataOutput out, Node[] array) throws IOException {
        out.writeInt(array.length);
        for (Node w : array) {
            w.write(out);
        }
    }

    public static Node[] readNodeArray(DataInput in) throws IOException {
        int length = in.readInt();
        Node[] nodes = new Node[length];
        for (int index = 0; index < length; ++index) {
            nodes[index] = Node.read(in);
        }
        return nodes;
    }

    public static void writeArray(DataOutput out, double[] array) throws IOException {
        out.writeInt(array.length);
        for (double value : array) {
            out.writeDouble(value);
        }
    }

    public static double[] readDoubleArray(DataInput in) throws IOException {
        int length = in.readInt();
        double[] array = new double[length];
        for (int index = 0; index < length; ++index) {
            array[index] = in.readDouble();
        }
        return array;
    }

    public static void writeArray(DataOutput out, int[] array) throws IOException {
        out.writeInt(array.length);
        for (int value : array) {
            out.writeInt(value);
        }
    }

    public static int[] readIntArray(DataInput in) throws IOException {
        int length = in.readInt();
        int[] array = new int[length];
        for (int index = 0; index < length; ++index) {
            array[index] = in.readInt();
        }
        return array;
    }

    public static Path[] listOutputFiles(FileSystem fs, Path outputPath) throws IOException {
        ArrayList<Path> outputFiles = new ArrayList<Path>();
        for (FileStatus s : fs.listStatus(outputPath, PathFilters.logsCRCFilter())) {
            if (s.isDir() || s.getPath().getName().startsWith("_")) continue;
            outputFiles.add(s.getPath());
        }
        if (outputFiles.isEmpty()) {
            throw new IOException("No output found !");
        }
        return outputFiles.toArray(new Path[outputFiles.size()]);
    }

    public static String elapsedTime(long milli) {
        long seconds = milli / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        return hours + "h " + (minutes %= 60L) + "m " + (seconds %= 60L) + "s " + (milli %= 1000L);
    }

    public static void storeWritable(Configuration conf, Path path, Writable writable) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        try (FSDataOutputStream out = fs.create(path);){
            writable.write((DataOutput)out);
        }
    }

    public static void storeString(Configuration conf, Path path, String string) throws IOException {
        try (FSDataOutputStream out = path.getFileSystem(conf).create(path);){
            out.write(string.getBytes(Charset.defaultCharset()));
        }
    }
}

