/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.df.DFUtils;
import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.DataUtils;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.Instance;
import org.apache.mahout.classifier.df.node.Node;

@Deprecated
public class DecisionForest
implements Writable {
    private final List<Node> trees;

    private DecisionForest() {
        this.trees = new ArrayList<Node>();
    }

    public DecisionForest(List<Node> trees) {
        Preconditions.checkArgument((trees != null && !trees.isEmpty() ? 1 : 0) != 0, (Object)"trees argument must not be null or empty");
        this.trees = trees;
    }

    List<Node> getTrees() {
        return this.trees;
    }

    public void classify(Data data, double[][] predictions) {
        Preconditions.checkArgument((data.size() == predictions.length ? 1 : 0) != 0, (Object)"predictions.length must be equal to data.size()");
        if (data.isEmpty()) {
            return;
        }
        int treeId = 0;
        for (Node tree : this.trees) {
            for (int index = 0; index < data.size(); ++index) {
                if (predictions[index] == null) {
                    predictions[index] = new double[this.trees.size()];
                }
                predictions[index][treeId] = tree.classify(data.get(index));
            }
            ++treeId;
        }
    }

    public double classify(Dataset dataset, Random rng, Instance instance) {
        if (dataset.isNumerical(dataset.getLabelId())) {
            double sum = 0.0;
            int cnt = 0;
            for (Node tree : this.trees) {
                double prediction = tree.classify(instance);
                if (Double.isNaN(prediction)) continue;
                sum += prediction;
                ++cnt;
            }
            if (cnt > 0) {
                return sum / (double)cnt;
            }
            return Double.NaN;
        }
        int[] predictions = new int[dataset.nblabels()];
        for (Node tree : this.trees) {
            double prediction = tree.classify(instance);
            if (Double.isNaN(prediction)) continue;
            int n = (int)prediction;
            predictions[n] = predictions[n] + 1;
        }
        if (DataUtils.sum(predictions) == 0) {
            return Double.NaN;
        }
        return DataUtils.maxindex(rng, predictions);
    }

    public long meanNbNodes() {
        long sum = 0L;
        for (Node tree : this.trees) {
            sum += tree.nbNodes();
        }
        return sum / (long)this.trees.size();
    }

    public long nbNodes() {
        long sum = 0L;
        for (Node tree : this.trees) {
            sum += tree.nbNodes();
        }
        return sum;
    }

    public long meanMaxDepth() {
        long sum = 0L;
        for (Node tree : this.trees) {
            sum += tree.maxDepth();
        }
        return sum / (long)this.trees.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DecisionForest)) {
            return false;
        }
        DecisionForest rf = (DecisionForest)obj;
        return this.trees.size() == rf.getTrees().size() && this.trees.containsAll(rf.getTrees());
    }

    public int hashCode() {
        return this.trees.hashCode();
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.trees.size());
        for (Node tree : this.trees) {
            tree.write(dataOutput);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        for (int i = 0; i < size; ++i) {
            this.trees.add(Node.read(dataInput));
        }
    }

    public static DecisionForest read(DataInput dataInput) throws IOException {
        DecisionForest forest = new DecisionForest();
        forest.readFields(dataInput);
        return forest;
    }

    public static DecisionForest load(Configuration conf, Path forestPath) throws IOException {
        FileSystem fs = forestPath.getFileSystem(conf);
        Path[] files = fs.getFileStatus(forestPath).isDir() ? DFUtils.listOutputFiles(fs, forestPath) : new Path[]{forestPath};
        DecisionForest forest = null;
        for (Path path : files) {
            try (FSDataInputStream dataInput = new FSDataInputStream((InputStream)fs.open(path));){
                if (forest == null) {
                    forest = DecisionForest.read((DataInput)dataInput);
                    continue;
                }
                forest.readFields((DataInput)dataInput);
            }
        }
        return forest;
    }
}

