/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class NaiveBayesModel {
    private final Vector weightsPerLabel;
    private final Vector perlabelThetaNormalizer;
    private final Vector weightsPerFeature;
    private final Matrix weightsPerLabelAndFeature;
    private final float alphaI;
    private final double numFeatures;
    private final double totalWeightSum;
    private final boolean isComplementary;
    public static final String COMPLEMENTARY_MODEL = "COMPLEMENTARY_MODEL";

    public NaiveBayesModel(Matrix weightMatrix, Vector weightsPerFeature, Vector weightsPerLabel, Vector thetaNormalizer, float alphaI, boolean isComplementary) {
        this.weightsPerLabelAndFeature = weightMatrix;
        this.weightsPerFeature = weightsPerFeature;
        this.weightsPerLabel = weightsPerLabel;
        this.perlabelThetaNormalizer = thetaNormalizer;
        this.numFeatures = weightsPerFeature.getNumNondefaultElements();
        this.totalWeightSum = weightsPerLabel.zSum();
        this.alphaI = alphaI;
        this.isComplementary = isComplementary;
    }

    public double labelWeight(int label) {
        return this.weightsPerLabel.getQuick(label);
    }

    public double thetaNormalizer(int label) {
        return this.perlabelThetaNormalizer.get(label);
    }

    public double featureWeight(int feature) {
        return this.weightsPerFeature.getQuick(feature);
    }

    public double weight(int label, int feature) {
        return this.weightsPerLabelAndFeature.getQuick(label, feature);
    }

    public float alphaI() {
        return this.alphaI;
    }

    public double numFeatures() {
        return this.numFeatures;
    }

    public double totalWeightSum() {
        return this.totalWeightSum;
    }

    public int numLabels() {
        return this.weightsPerLabel.size();
    }

    public Vector createScoringVector() {
        return this.weightsPerLabel.like();
    }

    public boolean isComplemtary() {
        return this.isComplementary;
    }

    public static NaiveBayesModel materialize(Path output, Configuration conf) throws IOException {
        SparseRowMatrix weightsPerLabelAndFeature;
        DenseVector weightsPerLabel;
        Vector weightsPerFeature;
        boolean isComplementary;
        float alphaI;
        FileSystem fs = output.getFileSystem(conf);
        DenseVector perLabelThetaNormalizer = null;
        try (FSDataInputStream in = fs.open(new Path(output, "naiveBayesModel.bin"));){
            alphaI = in.readFloat();
            isComplementary = in.readBoolean();
            weightsPerFeature = VectorWritable.readVector((DataInput)in);
            weightsPerLabel = new DenseVector(VectorWritable.readVector((DataInput)in));
            if (isComplementary) {
                perLabelThetaNormalizer = new DenseVector(VectorWritable.readVector((DataInput)in));
            }
            weightsPerLabelAndFeature = new SparseRowMatrix(weightsPerLabel.size(), weightsPerFeature.size());
            for (int label = 0; label < weightsPerLabelAndFeature.numRows(); ++label) {
                weightsPerLabelAndFeature.assignRow(label, VectorWritable.readVector((DataInput)in));
            }
        }
        NaiveBayesModel model = new NaiveBayesModel((Matrix)weightsPerLabelAndFeature, weightsPerFeature, (Vector)weightsPerLabel, (Vector)perLabelThetaNormalizer, alphaI, isComplementary);
        model.validate();
        return model;
    }

    public void serialize(Path output, Configuration conf) throws IOException {
        FileSystem fs = output.getFileSystem(conf);
        try (FSDataOutputStream out = fs.create(new Path(output, "naiveBayesModel.bin"));){
            out.writeFloat(this.alphaI);
            out.writeBoolean(this.isComplementary);
            VectorWritable.writeVector((DataOutput)out, (Vector)this.weightsPerFeature);
            VectorWritable.writeVector((DataOutput)out, (Vector)this.weightsPerLabel);
            if (this.isComplementary) {
                VectorWritable.writeVector((DataOutput)out, (Vector)this.perlabelThetaNormalizer);
            }
            for (int row = 0; row < this.weightsPerLabelAndFeature.numRows(); ++row) {
                VectorWritable.writeVector((DataOutput)out, (Vector)this.weightsPerLabelAndFeature.viewRow(row));
            }
        }
    }

    public void validate() {
        Preconditions.checkState((this.alphaI > 0.0f ? 1 : 0) != 0, (Object)"alphaI has to be greater than 0!");
        Preconditions.checkArgument((this.numFeatures > 0.0 ? 1 : 0) != 0, (Object)"the vocab count has to be greater than 0!");
        Preconditions.checkArgument((this.totalWeightSum > 0.0 ? 1 : 0) != 0, (Object)"the totalWeightSum has to be greater than 0!");
        Preconditions.checkNotNull((Object)this.weightsPerLabel, (Object)"the number of labels has to be defined!");
        Preconditions.checkArgument((this.weightsPerLabel.getNumNondefaultElements() > 0 ? 1 : 0) != 0, (Object)"the number of labels has to be greater than 0!");
        Preconditions.checkNotNull((Object)this.weightsPerFeature, (Object)"the feature sums have to be defined");
        Preconditions.checkArgument((this.weightsPerFeature.getNumNondefaultElements() > 0 ? 1 : 0) != 0, (Object)"the feature sums have to be greater than 0!");
        if (this.isComplementary) {
            Preconditions.checkArgument((this.perlabelThetaNormalizer != null ? 1 : 0) != 0, (Object)"the theta normalizers have to be defined");
            Preconditions.checkArgument((this.perlabelThetaNormalizer.getNumNondefaultElements() > 0 ? 1 : 0) != 0, (Object)"the number of theta normalizers has to be greater than 0!");
            Preconditions.checkArgument((Math.signum(this.perlabelThetaNormalizer.minValue()) == Math.signum(this.perlabelThetaNormalizer.maxValue()) ? 1 : 0) != 0, (Object)"Theta normalizers do not all have the same sign");
            Preconditions.checkArgument((this.perlabelThetaNormalizer.getNumNonZeroElements() == this.perlabelThetaNormalizer.size() ? 1 : 0) != 0, (Object)"Theta normalizers can not have zero value.");
        }
    }
}

