/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmTrainer;
import org.apache.mahout.classifier.sequencelearning.hmm.LossyHmmSerializer;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;

public final class BaumWelchTrainer {
    private BaumWelchTrainer() {
    }

    public static void main(String[] args) throws IOException {
        DefaultOptionBuilder optionBuilder = new DefaultOptionBuilder();
        ArgumentBuilder argumentBuilder = new ArgumentBuilder();
        DefaultOption inputOption = DefaultOptionCreator.inputOption().create();
        DefaultOption outputOption = DefaultOptionCreator.outputOption().create();
        DefaultOption stateNumberOption = optionBuilder.withLongName("nrOfHiddenStates").withDescription("Number of hidden states").withShortName("nh").withArgument(argumentBuilder.withMaximum(1).withMinimum(1).withName("number").create()).withRequired(true).create();
        DefaultOption observedStateNumberOption = optionBuilder.withLongName("nrOfObservedStates").withDescription("Number of observed states").withShortName("no").withArgument(argumentBuilder.withMaximum(1).withMinimum(1).withName("number").create()).withRequired(true).create();
        DefaultOption epsilonOption = optionBuilder.withLongName("epsilon").withDescription("Convergence threshold").withShortName("e").withArgument(argumentBuilder.withMaximum(1).withMinimum(1).withName("number").create()).withRequired(true).create();
        DefaultOption iterationsOption = optionBuilder.withLongName("max-iterations").withDescription("Maximum iterations number").withShortName("m").withArgument(argumentBuilder.withMaximum(1).withMinimum(1).withName("number").create()).withRequired(true).create();
        Group optionGroup = new GroupBuilder().withOption((Option)inputOption).withOption((Option)outputOption).withOption((Option)stateNumberOption).withOption((Option)observedStateNumberOption).withOption((Option)epsilonOption).withOption((Option)iterationsOption).withName("Options").create();
        try {
            int i;
            Parser parser = new Parser();
            parser.setGroup(optionGroup);
            CommandLine commandLine = parser.parse(args);
            String input = (String)commandLine.getValue((Option)inputOption);
            String output = (String)commandLine.getValue((Option)outputOption);
            int nrOfHiddenStates = Integer.parseInt((String)commandLine.getValue((Option)stateNumberOption));
            int nrOfObservedStates = Integer.parseInt((String)commandLine.getValue((Option)observedStateNumberOption));
            double epsilon = Double.parseDouble((String)commandLine.getValue((Option)epsilonOption));
            int maxIterations = Integer.parseInt((String)commandLine.getValue((Option)iterationsOption));
            HmmModel model = new HmmModel(nrOfHiddenStates, nrOfObservedStates, new Date().getTime());
            ArrayList<Integer> observations = new ArrayList<Integer>();
            try (Scanner scanner = new Scanner((InputStream)new FileInputStream(input), "UTF-8");){
                while (scanner.hasNextInt()) {
                    observations.add(scanner.nextInt());
                }
            }
            int[] observationsArray = new int[observations.size()];
            for (int i2 = 0; i2 < observations.size(); ++i2) {
                observationsArray[i2] = (Integer)observations.get(i2);
            }
            HmmModel trainedModel = HmmTrainer.trainBaumWelch(model, observationsArray, epsilon, maxIterations, true);
            try (DataOutputStream stream = new DataOutputStream(new FileOutputStream(output));){
                LossyHmmSerializer.serialize(trainedModel, stream);
            }
            System.out.println("Initial probabilities: ");
            for (i = 0; i < trainedModel.getNrOfHiddenStates(); ++i) {
                System.out.print(i + " ");
            }
            System.out.println();
            for (i = 0; i < trainedModel.getNrOfHiddenStates(); ++i) {
                System.out.print(trainedModel.getInitialProbabilities().get(i) + " ");
            }
            System.out.println();
            System.out.println("Transition matrix:");
            System.out.print("  ");
            for (i = 0; i < trainedModel.getNrOfHiddenStates(); ++i) {
                System.out.print(i + " ");
            }
            System.out.println();
            for (i = 0; i < trainedModel.getNrOfHiddenStates(); ++i) {
                System.out.print(i + " ");
                for (int j = 0; j < trainedModel.getNrOfHiddenStates(); ++j) {
                    System.out.print(trainedModel.getTransitionMatrix().get(i, j) + " ");
                }
                System.out.println();
            }
            System.out.println("Emission matrix: ");
            System.out.print("  ");
            for (i = 0; i < trainedModel.getNrOfOutputStates(); ++i) {
                System.out.print(i + " ");
            }
            System.out.println();
            for (i = 0; i < trainedModel.getNrOfHiddenStates(); ++i) {
                System.out.print(i + " ");
                for (int j = 0; j < trainedModel.getNrOfOutputStates(); ++j) {
                    System.out.print(trainedModel.getEmissionMatrix().get(i, j) + " ");
                }
                System.out.println();
            }
        }
        catch (OptionException e) {
            CommandLineUtil.printHelp(optionGroup);
        }
    }
}

