/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.sgd.AdaptiveLogisticRegression;
import org.apache.mahout.classifier.sgd.CrossFoldLearner;
import org.apache.mahout.classifier.sgd.OnlineLogisticRegression;
import org.apache.mahout.classifier.sgd.PolymorphicWritable;

public final class ModelSerializer {
    private ModelSerializer() {
    }

    public static void writeBinary(String path, CrossFoldLearner model) throws IOException {
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(path));){
            PolymorphicWritable.write(out, model);
        }
    }

    public static void writeBinary(String path, OnlineLogisticRegression model) throws IOException {
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(path));){
            PolymorphicWritable.write(out, model);
        }
    }

    public static void writeBinary(String path, AdaptiveLogisticRegression model) throws IOException {
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(path));){
            PolymorphicWritable.write(out, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Writable> T readBinary(InputStream in, Class<T> clazz) throws IOException {
        DataInputStream dataIn = new DataInputStream(in);
        try {
            T t = PolymorphicWritable.read(dataIn, clazz);
            return t;
        }
        finally {
            Closeables.close((Closeable)in, (boolean)false);
        }
    }
}

