/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.fuzzykmeans;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.canopy.Canopy;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.kmeans.Kluster;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;

final class FuzzyKMeansUtil {
    private FuzzyKMeansUtil() {
    }

    public static void configureWithClusterInfo(Configuration conf, Path clusterPath, List<Cluster> clusters) {
        for (Writable value : new SequenceFileDirValueIterable(clusterPath, PathType.LIST, PathFilters.partFilter(), conf)) {
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(ClusterWritable.class)) {
                ClusterWritable clusterWritable = (ClusterWritable)value;
                value = clusterWritable.getValue();
                valueClass = value.getClass();
            }
            if (valueClass.equals(Kluster.class)) {
                Kluster cluster = (Kluster)value;
                clusters.add(new SoftCluster(cluster.getCenter(), cluster.getId(), cluster.getMeasure()));
                continue;
            }
            if (valueClass.equals(SoftCluster.class)) {
                clusters.add((SoftCluster)value);
                continue;
            }
            if (valueClass.equals(Canopy.class)) {
                Canopy canopy = (Canopy)value;
                clusters.add(new SoftCluster(canopy.getCenter(), canopy.getId(), canopy.getMeasure()));
                continue;
            }
            throw new IllegalStateException("Bad value class: " + valueClass);
        }
    }
}

