/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.topdown.postprocessor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.classify.WeightedVectorWritable;
import org.apache.mahout.clustering.topdown.PathDirectory;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.math.VectorWritable;

public final class ClusterOutputPostProcessor {
    private Path clusteredPoints;
    private final FileSystem fileSystem;
    private final Configuration conf;
    private final Path clusterPostProcessorOutput;
    private final Map<String, Path> postProcessedClusterDirectories = new HashMap<String, Path>();
    private long uniqueVectorId = 0L;
    private final Map<String, SequenceFile.Writer> writersForClusters;

    public ClusterOutputPostProcessor(Path clusterOutputToBeProcessed, Path output, Configuration hadoopConfiguration) throws IOException {
        this.clusterPostProcessorOutput = output;
        this.clusteredPoints = PathDirectory.getClusterOutputClusteredPoints(clusterOutputToBeProcessed);
        this.conf = hadoopConfiguration;
        this.writersForClusters = new HashMap<String, SequenceFile.Writer>();
        this.fileSystem = this.clusteredPoints.getFileSystem(this.conf);
    }

    public void process() throws IOException {
        this.createPostProcessDirectory();
        for (Pair record : new SequenceFileDirIterable(this.clusteredPoints, PathType.GLOB, PathFilters.partFilter(), null, false, this.conf)) {
            String clusterId = record.getFirst().toString().trim();
            this.putVectorInRespectiveCluster(clusterId, (WeightedVectorWritable)record.getSecond());
        }
        IOUtils.close(this.writersForClusters.values());
        this.writersForClusters.clear();
    }

    private void createPostProcessDirectory() throws IOException {
        if (!this.fileSystem.exists(this.clusterPostProcessorOutput) && !this.fileSystem.mkdirs(this.clusterPostProcessorOutput)) {
            throw new IOException("Error creating cluster post processor directory");
        }
    }

    private void putVectorInRespectiveCluster(String clusterId, WeightedVectorWritable point) throws IOException {
        SequenceFile.Writer writer = this.findWriterForVector(clusterId);
        this.postProcessedClusterDirectories.put(clusterId, PathDirectory.getClusterPathForClusterId(this.clusterPostProcessorOutput, clusterId));
        this.writeVectorToCluster(writer, point);
    }

    private SequenceFile.Writer findWriterForVector(String clusterId) throws IOException {
        Path clusterDirectory = PathDirectory.getClusterPathForClusterId(this.clusterPostProcessorOutput, clusterId);
        SequenceFile.Writer writer = this.writersForClusters.get(clusterId);
        if (writer == null) {
            Path pathToWrite = new Path(clusterDirectory, new Path("part-m-0"));
            writer = new SequenceFile.Writer(this.fileSystem, this.conf, pathToWrite, LongWritable.class, VectorWritable.class);
            this.writersForClusters.put(clusterId, writer);
        }
        return writer;
    }

    private void writeVectorToCluster(SequenceFile.Writer writer, WeightedVectorWritable point) throws IOException {
        writer.append((Writable)new LongWritable(this.uniqueVectorId++), (Writable)new VectorWritable(point.getVector()));
        writer.sync();
    }

    public Map<String, Path> getPostProcessedClusterDirectories() {
        return this.postProcessedClusterDirectories;
    }

    public void setClusteredPoints(Path clusteredPoints) {
        this.clusteredPoints = clusteredPoints;
    }
}

