/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.io.WritableComparable;

public final class IntegerTuple
implements WritableComparable<IntegerTuple> {
    private List<Integer> tuple = Lists.newArrayList();

    public IntegerTuple() {
    }

    public IntegerTuple(Integer firstEntry) {
        this.add(firstEntry);
    }

    public IntegerTuple(Iterable<Integer> entries) {
        for (Integer entry : entries) {
            this.add(entry);
        }
    }

    public IntegerTuple(Integer[] entries) {
        for (Integer entry : entries) {
            this.add(entry);
        }
    }

    public boolean add(Integer entry) {
        return this.tuple.add(entry);
    }

    public Integer integerAt(int index) {
        return this.tuple.get(index);
    }

    public Integer replaceAt(int index, Integer newInteger) {
        return this.tuple.set(index, newInteger);
    }

    public List<Integer> getEntries() {
        return Collections.unmodifiableList(this.tuple);
    }

    public int length() {
        return this.tuple.size();
    }

    public String toString() {
        return this.tuple.toString();
    }

    public int hashCode() {
        return this.tuple.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerTuple other = (IntegerTuple)obj;
        return !(this.tuple == null ? other.tuple != null : !this.tuple.equals(other.tuple));
    }

    public void readFields(DataInput in) throws IOException {
        int len = in.readInt();
        this.tuple = Lists.newArrayListWithCapacity((int)len);
        for (int i = 0; i < len; ++i) {
            int data = in.readInt();
            this.tuple.add(data);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.tuple.size());
        for (Integer entry : this.tuple) {
            out.writeInt(entry);
        }
    }

    public int compareTo(IntegerTuple otherTuple) {
        int thisLength = this.length();
        int otherLength = otherTuple.length();
        int min = Math.min(thisLength, otherLength);
        for (int i = 0; i < min; ++i) {
            int ret = this.tuple.get(i).compareTo(otherTuple.integerAt(i));
            if (ret == 0) continue;
            return ret;
        }
        if (thisLength < otherLength) {
            return -1;
        }
        if (thisLength > otherLength) {
            return 1;
        }
        return 0;
    }
}

