/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator;

import com.google.common.base.Charsets;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.mahout.cf.taste.impl.common.SkippingIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileLineIterator
extends AbstractIterator<String>
implements SkippingIterator<String>,
Closeable {
    private final BufferedReader reader;
    private static final Logger log = LoggerFactory.getLogger(FileLineIterator.class);

    public FileLineIterator(File file) throws IOException {
        this(file, Charsets.UTF_8, false);
    }

    public FileLineIterator(File file, boolean skipFirstLine) throws IOException {
        this(file, Charsets.UTF_8, skipFirstLine);
    }

    public FileLineIterator(File file, Charset encoding, boolean skipFirstLine) throws IOException {
        this(FileLineIterator.getFileInputStream(file), encoding, skipFirstLine);
    }

    public FileLineIterator(InputStream is) throws IOException {
        this(is, Charsets.UTF_8, false);
    }

    public FileLineIterator(InputStream is, boolean skipFirstLine) throws IOException {
        this(is, Charsets.UTF_8, skipFirstLine);
    }

    public FileLineIterator(InputStream is, Charset encoding, boolean skipFirstLine) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(is, encoding));
        if (skipFirstLine) {
            this.reader.readLine();
        }
    }

    public FileLineIterator(InputStream is, Charset encoding, boolean skipFirstLine, String filename) throws IOException {
        InputStream compressedInputStream = "gz".equalsIgnoreCase(Files.getFileExtension((String)filename.toLowerCase())) ? new GZIPInputStream(is) : ("zip".equalsIgnoreCase(Files.getFileExtension((String)filename.toLowerCase())) ? new ZipInputStream(is) : is);
        this.reader = new BufferedReader(new InputStreamReader(compressedInputStream, encoding));
        if (skipFirstLine) {
            this.reader.readLine();
        }
    }

    static InputStream getFileInputStream(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        String name = file.getName();
        if ("gz".equalsIgnoreCase(Files.getFileExtension((String)name.toLowerCase()))) {
            return new GZIPInputStream(is);
        }
        if ("zip".equalsIgnoreCase(Files.getFileExtension((String)name.toLowerCase()))) {
            return new ZipInputStream(is);
        }
        return is;
    }

    protected String computeNext() {
        String line;
        try {
            line = this.reader.readLine();
        }
        catch (IOException ioe) {
            try {
                this.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            throw new IllegalStateException(ioe);
        }
        return line == null ? (String)this.endOfData() : line;
    }

    @Override
    public void skip(int n) {
        try {
            for (int i = 0; i < n && this.reader.readLine() != null; ++i) {
            }
        }
        catch (IOException ioe) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.endOfData();
        Closeables.close((Closeable)this.reader, (boolean)true);
    }
}

