/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.solver;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.apache.mahout.math.solver.ConjugateGradientSolver;
import org.apache.mahout.math.solver.Preconditioner;

public class DistributedConjugateGradientSolver
extends ConjugateGradientSolver
implements Tool {
    private Configuration conf;
    private Map<String, List<String>> parsedArgs;

    public Vector runJob(Path inputPath, Path tempPath, int numRows, int numCols, Vector b, Preconditioner preconditioner, int maxIterations, double maxError) {
        DistributedRowMatrix matrix = new DistributedRowMatrix(inputPath, tempPath, numRows, numCols);
        matrix.setConf(this.conf);
        return this.solve(matrix, b, preconditioner, maxIterations, maxError);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public int run(String[] strings) throws Exception {
        Path inputPath = new Path(AbstractJob.getOption(this.parsedArgs, "--input"));
        Path outputPath = new Path(AbstractJob.getOption(this.parsedArgs, "--output"));
        Path tempPath = new Path(AbstractJob.getOption(this.parsedArgs, "--tempDir"));
        Path vectorPath = new Path(AbstractJob.getOption(this.parsedArgs, "--vector"));
        int numRows = Integer.parseInt(AbstractJob.getOption(this.parsedArgs, "--numRows"));
        int numCols = Integer.parseInt(AbstractJob.getOption(this.parsedArgs, "--numCols"));
        int maxIterations = this.parsedArgs.containsKey("--maxIter") ? Integer.parseInt(AbstractJob.getOption(this.parsedArgs, "--maxIter")) : numCols + 2;
        double maxError = this.parsedArgs.containsKey("--maxError") ? Double.parseDouble(AbstractJob.getOption(this.parsedArgs, "--maxError")) : 1.0E-9;
        Vector b = this.loadInputVector(vectorPath);
        Vector x = this.runJob(inputPath, tempPath, numRows, numCols, b, null, maxIterations, maxError);
        this.saveOutputVector(outputPath, x);
        tempPath.getFileSystem(this.conf).delete(tempPath, true);
        return 0;
    }

    public DistributedConjugateGradientSolverJob job() {
        return new DistributedConjugateGradientSolverJob();
    }

    private Vector loadInputVector(Path path) throws IOException {
        FileSystem fs = path.getFileSystem(this.conf);
        try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, path, this.conf);){
            VectorWritable value = new VectorWritable();
            if (!reader.next((Writable)new IntWritable(), (Writable)value)) {
                throw new IOException("Input vector file is empty.");
            }
            Vector vector = value.get();
            return vector;
        }
    }

    private void saveOutputVector(Path path, Vector v) throws IOException {
        FileSystem fs = path.getFileSystem(this.conf);
        try (SequenceFile.Writer writer = new SequenceFile.Writer(fs, this.conf, path, IntWritable.class, VectorWritable.class);){
            writer.append((Writable)new IntWritable(0), (Writable)new VectorWritable(v));
        }
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new DistributedConjugateGradientSolver().job(), (String[])args);
    }

    public class DistributedConjugateGradientSolverJob
    extends AbstractJob {
        @Override
        public void setConf(Configuration conf) {
            DistributedConjugateGradientSolver.this.setConf(conf);
        }

        @Override
        public Configuration getConf() {
            return DistributedConjugateGradientSolver.this.getConf();
        }

        public int run(String[] args) throws Exception {
            this.addInputOption();
            this.addOutputOption();
            this.addOption("numRows", "nr", "Number of rows in the input matrix", true);
            this.addOption("numCols", "nc", "Number of columns in the input matrix", true);
            this.addOption("vector", "b", "Vector to solve against", true);
            this.addOption("lambda", "l", "Scalar in A + lambda * I [default = 0]", "0.0");
            this.addOption("symmetric", "sym", "Is the input matrix square and symmetric?", "true");
            this.addOption("maxIter", "x", "Maximum number of iterations to run");
            this.addOption("maxError", "err", "Maximum residual error to allow before stopping");
            DistributedConjugateGradientSolver.this.parsedArgs = this.parseArguments(args);
            if (DistributedConjugateGradientSolver.this.parsedArgs == null) {
                return -1;
            }
            Configuration conf = this.getConf();
            if (conf == null) {
                conf = new Configuration();
            }
            DistributedConjugateGradientSolver.this.setConf(conf);
            return DistributedConjugateGradientSolver.this.run(args);
        }
    }
}

