/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.random.Multinomial;
import org.apache.mahout.math.random.Normal;

public final class RandomProjector {
    private RandomProjector() {
    }

    public static Matrix generateBasisNormal(int projectedVectorSize, int vectorSize) {
        DenseMatrix basisMatrix = new DenseMatrix(projectedVectorSize, vectorSize);
        basisMatrix.assign((DoubleFunction)new Normal());
        for (MatrixSlice row : basisMatrix) {
            row.vector().assign(row.normalize());
        }
        return basisMatrix;
    }

    public static Matrix generateBasisPlusMinusOne(int projectedVectorSize, int vectorSize) {
        DenseMatrix basisMatrix = new DenseMatrix(projectedVectorSize, vectorSize);
        for (int i = 0; i < projectedVectorSize; ++i) {
            for (int j = 0; j < vectorSize; ++j) {
                basisMatrix.set(i, j, RandomUtils.nextInt((int)2) == 0 ? 1.0 : -1.0);
            }
        }
        for (MatrixSlice row : basisMatrix) {
            row.vector().assign(row.normalize());
        }
        return basisMatrix;
    }

    public static Matrix generateBasisZeroPlusMinusOne(int projectedVectorSize, int vectorSize) {
        DenseMatrix basisMatrix = new DenseMatrix(projectedVectorSize, vectorSize);
        Multinomial choice = new Multinomial();
        choice.add((Object)0.0, 0.6666666666666666);
        choice.add((Object)Math.sqrt(3.0), 0.16666666666666666);
        choice.add((Object)(-Math.sqrt(3.0)), 0.16666666666666666);
        for (int i = 0; i < projectedVectorSize; ++i) {
            for (int j = 0; j < vectorSize; ++j) {
                basisMatrix.set(i, j, ((Double)choice.sample()).doubleValue());
            }
        }
        for (MatrixSlice row : basisMatrix) {
            row.vector().assign(row.normalize());
        }
        return basisMatrix;
    }

    public static List<Vector> generateVectorBasis(int projectedVectorSize, int vectorSize) {
        Normal random = new Normal();
        ArrayList basisVectors = Lists.newArrayList();
        for (int i = 0; i < projectedVectorSize; ++i) {
            DenseVector basisVector = new DenseVector(vectorSize);
            basisVector.assign((DoubleFunction)random);
            basisVector.normalize();
            basisVectors.add(basisVector);
        }
        return basisVectors;
    }
}

