/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.JsonObjectParser$;
import org.apache.pekko.stream.scaladsl.Framing;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005UtA\u0002\u00180\u0011\u0003\u0019\u0014H\u0002\u0004<_!\u00051\u0007\u0010\u0005\u0006\u0007\u0006!\t!\u0012\u0005\b\r\u0006\u0011\r\u0011\"\u0002H\u0011\u0019Y\u0015\u0001)A\u0007\u0011\"9A*\u0001b\u0001\n\u000b9\u0005BB'\u0002A\u00035\u0001\nC\u0004O\u0003\t\u0007IQA$\t\r=\u000b\u0001\u0015!\u0004I\u0011\u001d\u0001\u0016A1A\u0005\u0006\u001dCa!U\u0001!\u0002\u001bA\u0005b\u0002*\u0002\u0005\u0004%)a\u0012\u0005\u0007'\u0006\u0001\u000bQ\u0002%\t\u000fQ\u000b!\u0019!C\u0003\u000f\"1Q+\u0001Q\u0001\u000e!CqAV\u0001C\u0002\u0013\u0015q\t\u0003\u0004X\u0003\u0001\u0006i\u0001\u0013\u0005\b1\u0006\u0011\r\u0011\"\u0002Z\u0011\u0019a\u0016\u0001)A\u00075\"9Q,\u0001b\u0001\n\u000bq\u0006BB1\u0002A\u00035q\fC\u0004c\u0003\t\u0007IQA2\t\r\u0019\f\u0001\u0015!\u0004e\u0011\u001d9\u0017A1A\u0005\u0006!Daa[\u0001!\u0002\u001bI\u0007\"\u00027\u0002\t\u0003i\u0007bB:\u0002#\u0003%\t\u0001\u001e\u0004\u0007w=\u00021'a\u0005\t\u0013\u0005U1D!A!\u0002\u00131\bBB\"\u001c\t\u0003\t9\u0002\u0003\u0005\u0002\u001em\u0001\u000b\u0015BA\u0010\u0011\u001d\t)c\u0007Q!\nYDq!a\n\u001cA\u0003&a\u000fC\u0004\u0002*m\u0001\u000b\u0015\u0002<\t\u000f\u0005-2\u0004)Q\u0005]\"9\u0011QF\u000e!B\u0013q\u0007bBA\u00187\u0001\u0006KA\u001c\u0005\b\u0003cYB\u0011AA\u001a\u0011\u001d\tYe\u0007C\u0001\u0003\u001bBq!a\u0014\u001c\t\u0003\ti\u0005C\u0004\u0002Rm!\t!a\u0015\t\u000f\u0005m3\u0004\"\u0003\u0002^!9\u0011qL\u000e\u0005\n\u0005\u0005\u0004bBA47\u0011%\u0011\u0011\u000e\u0005\n\u0003[Z\"\u0019!C\u0005\u0003_B\u0001\"!\u001d\u001cA\u0003%\u0011qD\u0001\u0011\u0015N|gn\u00142kK\u000e$\b+\u0019:tKJT!\u0001M\u0019\u0002\t%l\u0007\u000f\u001c\u0006\u0003eM\naa\u001d;sK\u0006l'B\u0001\u001b6\u0003\u0015\u0001Xm[6p\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\u0011\u0005i\nQ\"A\u0018\u0003!)\u001bxN\\(cU\u0016\u001cG\u000fU1sg\u0016\u00148CA\u0001>!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001:\u0003A\u0019\u0016/^1sK\n\u0013\u0018mY3Ti\u0006\u0014H/F\u0001I!\tq\u0014*\u0003\u0002K\u007f\t!!)\u001f;f\u0003E\u0019\u0016/^1sK\n\u0013\u0018mY3Ti\u0006\u0014H\u000fI\u0001\u000f'F,\u0018M]3Ce\u0006\u001cW-\u00128e\u0003=\u0019\u0016/^1sK\n\u0013\u0018mY3F]\u0012\u0004\u0013aD\"ve2L(I]1dKN#\u0018M\u001d;\u0002!\r+(\u000f\\=Ce\u0006\u001cWm\u0015;beR\u0004\u0013!D\"ve2L(I]1dK\u0016sG-\u0001\bDkJd\u0017P\u0011:bG\u0016,e\u000e\u001a\u0011\u0002\u0017\u0011{WO\u00197f#V|G/Z\u0001\r\t>,(\r\\3Rk>$X\rI\u0001\n\u0005\u0006\u001c7n\u001d7bg\"\f!BQ1dWNd\u0017m\u001d5!\u0003\u0015\u0019u.\\7b\u0003\u0019\u0019u.\\7bA\u0005IA*\u001b8f\u0005J,\u0017m[\u000b\u00025>\t1,H\u0001\u000b\u0003)a\u0015N\\3Ce\u0016\f7\u000eI\u0001\u000b\u0019&tWM\u0011:fC.\u0014T#A0\u0010\u0003\u0001l\u0012!D\u0001\f\u0019&tWM\u0011:fC.\u0014\u0004%A\u0002UC\n,\u0012\u0001Z\b\u0002Kv\t\u0011\"\u0001\u0003UC\n\u0004\u0013!B*qC\u000e,W#A5\u0010\u0003)l\u0012\u0001I\u0001\u0007'B\f7-\u001a\u0011\u0002\u0019%\u001cx\u000b[5uKN\u0004\u0018mY3\u0015\u00059\f\bC\u0001 p\u0013\t\u0001xHA\u0004C_>dW-\u00198\t\u000bIL\u0002\u0019\u0001%\u0002\u0003\t\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT#A;+\u0005YL\bC\u0001 x\u0013\tAxHA\u0002J]R\\\u0013A\u001f\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018!C;oG\",7m[3e\u0015\tyx(\u0001\u0006b]:|G/\u0019;j_:L1!a\u0001}\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0004\u0003\u0005\u001d\u0001\u0003BA\u0005\u0003\u001bi!!a\u0003\u000b\u0005}\u001c\u0014\u0002BA\b\u0003\u0017\u00111\"\u00138uKJt\u0017\r\\!qS\"\u001a\u0001!a\u0002\u0014\u0005mi\u0014aE7bq&lW/\\(cU\u0016\u001cG\u000fT3oORDG\u0003BA\r\u00037\u0001\"AO\u000e\t\u0011\u0005UQ\u0004%AA\u0002Y\faAY;gM\u0016\u0014\b\u0003\u0002 \u0002\"!K1!a\t@\u0005\u0015\t%O]1z\u0003\r\u0001xn]\u0001\u0006gR\f'\u000f^\u0001\u0006I\u0016\u0004H\u000f[\u0001\u0010G>l\u0007\u000f\\3uK\u0012|%M[3di\u0006\u0011\u0012N\\*ue&tw-\u0012=qe\u0016\u001c8/[8o\u0003EIgNQ1dWNd\u0017m\u001d5Fg\u000e\f\u0007/Z\u0001\u0006_\u001a4WM\u001d\u000b\u0005\u0003k\tY\u0004E\u0002?\u0003oI1!!\u000f@\u0005\u0011)f.\u001b;\t\u000f\u0005uR\u00051\u0001\u0002@\u0005)\u0011N\u001c9viB!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002FM\nA!\u001e;jY&!\u0011\u0011JA\"\u0005)\u0011\u0015\u0010^3TiJLgnZ\u0001\bSN,U\u000e\u001d;z+\u0005q\u0017aC2b]\u000e{W\u000e\u001d7fi\u0016\fA\u0001]8mYR\u0011\u0011Q\u000b\t\u0006}\u0005]\u0013qH\u0005\u0004\u00033z$AB(qi&|g.\u0001\u0006tK\u0016\\wJ\u00196fGR$\u0012A\\\u0001\u0011g.L\u0007\u000fV8OKb$xJ\u00196fGR$B!!\u000e\u0002d!1\u0011Q\r\u0016A\u0002Y\fqAY;g'&TX-A\u0004qe>\u001cW-\u001a3\u0015\t\u0005U\u00121\u000e\u0005\u0007\u0003{Y\u0003\u0019\u0001%\u0002\u0015=,H/\u001a:DQ\u0006\u00148/\u0006\u0002\u0002 \u0005Yq.\u001e;fe\u000eC\u0017M]:!Q\rY\u0012q\u0001")
@InternalApi
public class JsonObjectParser {
    private final int maximumObjectLength;
    private byte[] buffer;
    private int pos;
    private int start;
    private int depth;
    private boolean completedObject;
    private boolean inStringExpression;
    private boolean inBackslashEscape;
    private final byte[] outerChars;

    public static int $lessinit$greater$default$1() {
        return JsonObjectParser$.MODULE$.$lessinit$greater$default$1();
    }

    public static boolean isWhitespace(byte by) {
        return JsonObjectParser$.MODULE$.isWhitespace(by);
    }

    public static int Space() {
        return JsonObjectParser$.MODULE$.Space();
    }

    public static int Tab() {
        return JsonObjectParser$.MODULE$.Tab();
    }

    public static int LineBreak2() {
        return JsonObjectParser$.MODULE$.LineBreak2();
    }

    public static int LineBreak() {
        return JsonObjectParser$.MODULE$.LineBreak();
    }

    public static byte Comma() {
        return JsonObjectParser$.MODULE$.Comma();
    }

    public static byte Backslash() {
        return JsonObjectParser$.MODULE$.Backslash();
    }

    public static byte DoubleQuote() {
        return JsonObjectParser$.MODULE$.DoubleQuote();
    }

    public static byte CurlyBraceEnd() {
        return JsonObjectParser$.MODULE$.CurlyBraceEnd();
    }

    public static byte CurlyBraceStart() {
        return JsonObjectParser$.MODULE$.CurlyBraceStart();
    }

    public static byte SquareBraceEnd() {
        return JsonObjectParser$.MODULE$.SquareBraceEnd();
    }

    public static byte SquareBraceStart() {
        return JsonObjectParser$.MODULE$.SquareBraceStart();
    }

    public void offer(ByteString input) {
        byte[] oldBuffer = this.buffer;
        this.buffer = new byte[oldBuffer.length - this.start + input.size()];
        System.arraycopy(oldBuffer, this.start, this.buffer, 0, oldBuffer.length - this.start);
        input.copyToArray((Object)this.buffer, oldBuffer.length - this.start);
        this.pos -= this.start;
        this.start = 0;
    }

    public boolean isEmpty() {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.buffer)).isEmpty();
    }

    public boolean canComplete() {
        return this.depth == 0;
    }

    public Option<ByteString> poll() {
        None$ none$;
        try {
            boolean foundObject = this.seekObject();
            if (!foundObject) {
                none$ = None$.MODULE$;
            } else {
                int n = this.pos;
                switch (n) {
                    case -1: 
                    case 0: {
                        none$ = None$.MODULE$;
                        break;
                    }
                    default: {
                        if (this.start == this.pos) {
                            none$ = None$.MODULE$;
                            break;
                        }
                        ByteString res = ByteString$.MODULE$.fromArrayUnsafe(this.buffer, this.start, this.pos - this.start);
                        this.start = this.pos;
                        none$ = new Some((Object)res);
                        break;
                    }
                }
            }
        }
        catch (ArithmeticException arithmeticException) {
            throw new Framing.FramingException(new StringBuilder(45).append("Invalid JSON encountered at position [").append(this.pos).append("] of [").append(ByteString$.MODULE$.apply(this.buffer).utf8String()).append("]").toString());
        }
        return none$;
    }

    private boolean seekObject() {
        int maxObjectLengthIndex;
        this.completedObject = false;
        int bufSize = this.buffer.length;
        this.skipToNextObject(bufSize);
        int n = maxObjectLengthIndex = this.pos + this.maximumObjectLength < 0 ? Integer.MAX_VALUE : this.pos + this.maximumObjectLength;
        while (this.pos < bufSize && this.pos < maxObjectLengthIndex && !this.completedObject) {
            byte input = this.buffer[this.pos];
            this.proceed(input);
            ++this.pos;
        }
        if (this.pos >= maxObjectLengthIndex) {
            throw new Framing.FramingException(new StringBuilder(51).append("JSON element exceeded maximumObjectLength (").append(this.maximumObjectLength).append(" bytes)!").toString());
        }
        return this.completedObject;
    }

    private void skipToNextObject(int bufSize) {
        while (this.pos != -1 && this.pos < bufSize && this.depth == 0) {
            byte outer = this.outerChars()[this.buffer[this.pos] & 0xFF];
            this.start += outer & 1;
            this.depth = (outer & 2) >> 1;
            int cfr_ignored_0 = 1 / outer;
            ++this.pos;
        }
    }

    private void proceed(byte input) {
        if (this.inStringExpression) {
            byte by = input;
            if (JsonObjectParser$.MODULE$.DoubleQuote() == by) {
                this.inStringExpression = this.inBackslashEscape;
                this.inBackslashEscape = false;
                return;
            }
            if (JsonObjectParser$.MODULE$.Backslash() == by) {
                this.inBackslashEscape = !this.inBackslashEscape;
                return;
            }
            this.inBackslashEscape = false;
            return;
        }
        byte by = input;
        if (JsonObjectParser$.MODULE$.DoubleQuote() == by) {
            this.inStringExpression = true;
            return;
        }
        if (JsonObjectParser$.MODULE$.CurlyBraceStart() == by) {
            ++this.depth;
            return;
        }
        if (JsonObjectParser$.MODULE$.CurlyBraceEnd() == by) {
            --this.depth;
            this.completedObject = this.depth == 0;
            return;
        }
    }

    private byte[] outerChars() {
        return this.outerChars;
    }

    public static final /* synthetic */ byte $anonfun$outerChars$1(int i) {
        byte by = (byte)i;
        if (JsonObjectParser$.MODULE$.CurlyBraceStart() == by) {
            return 2;
        }
        if (JsonObjectParser$.MODULE$.SquareBraceStart() == by ? true : (JsonObjectParser$.MODULE$.SquareBraceEnd() == by ? true : JsonObjectParser$.MODULE$.Comma() == by)) {
            return 1;
        }
        if (JsonObjectParser$.MODULE$.isWhitespace(by)) {
            return 1;
        }
        return 0;
    }

    public JsonObjectParser(int maximumObjectLength) {
        this.maximumObjectLength = maximumObjectLength;
        this.buffer = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        this.pos = 0;
        this.start = 0;
        this.depth = 0;
        this.completedObject = false;
        this.inStringExpression = false;
        this.inBackslashEscape = false;
        this.outerChars = (byte[])Array$.MODULE$.tabulate(256, (Function1 & java.io.Serializable & Serializable)i -> BoxesRunTime.boxToByte((byte)JsonObjectParser.$anonfun$outerChars$1(BoxesRunTime.unboxToInt((Object)i))), ClassTag$.MODULE$.Byte());
    }
}

