/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.ResizableMultiReaderRingBuffer$NothingToReadException$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Me!B\u0013'\u0001)\u0002\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011u\u0002!\u0011!Q\u0001\niB\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\n\u0003\u001b\u0001!\u0011!Q\u0001\n\u0001CaA\u0012\u0001\u0005\u0002\u0005=\u0001bBA\u0018\u0001\u0001\u0006IA\u000f\u0005\t\u0003c\u0001\u0001\u0015)\u0003\u00024!9\u0011\u0011\b\u0001!B\u0013Q\u0004bBA\u001e\u0001\u0001\u0006KA\u000f\u0005\u0007\u0003{\u0001A\u0011\u0002<\t\r\u0005}\u0002\u0001\"\u0003w\u0011\u0019\t\t\u0005\u0001C\u0001m\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA'\u0001\u0011\u0005\u0011Q\t\u0005\u0007\u0003\u001f\u0002A\u0011\u0001<\t\r\u0005E\u0003\u0001\"\u0001w\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBA;\u0001\u0011%\u0011q\u000f\u0005\b\u0003s\u0002A\u0011CA>\u0011\u001d\ti\b\u0001C!\u0003\u007f:aa\u0011\u0014\t\u0002)\"eAB\u0013'\u0011\u0003QS\tC\u0003G5\u0011\u0005qiB\u0003I5!\u0005\u0011JB\u0003L5!\u0005A\nC\u0003G;\u0011\u0005\u0011\rC\u0004c;\u0005\u0005I\u0011B2\u0007\u000f1T\u0002\u0013aI\u0001[\")a\b\tD\u0001]\u001a91O\u0007I\u0001$\u0003!\b\"B;#\r\u00031\b\"B<#\r\u0003A(A\b*fg&T\u0018M\u00197f\u001bVdG/\u001b*fC\u0012,'OU5oO\n+hMZ3s\u0015\t9\u0003&\u0001\u0003j[Bd'BA\u0015+\u0003\u0019\u0019HO]3b[*\u00111\u0006L\u0001\u0006a\u0016\\7n\u001c\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014x-F\u00022\u0003/\u0019\"\u0001\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g\u0003-Ig.\u001b;jC2\u001c\u0016N_3\u0004\u0001A\u00111gO\u0005\u0003yQ\u00121!\u00138u\u0003\u001di\u0017\r_*ju\u0016\fqaY;sg>\u00148/F\u0001A!\t\t\u0005E\u0004\u0002C35\ta%\u0001\u0010SKNL'0\u00192mK6+H\u000e^5SK\u0006$WM\u001d*j]\u001e\u0014UO\u001a4feB\u0011!IG\n\u00035I\na\u0001P5oSRtD#\u0001#\u0002-9{G\u000f[5oOR{'+Z1e\u000bb\u001cW\r\u001d;j_:\u0004\"AS\u000f\u000e\u0003i\u0011aCT8uQ&tw\rV8SK\u0006$W\t_2faRLwN\\\n\u0004;5K\u0006C\u0001(W\u001d\tyEK\u0004\u0002Q'6\t\u0011K\u0003\u0002Ss\u00051AH]8pizJ\u0011!N\u0005\u0003+R\nq\u0001]1dW\u0006<W-\u0003\u0002X1\n\u0001\"+\u001e8uS6,W\t_2faRLwN\u001c\u0006\u0003+R\u0002\"AW0\u000e\u0003mS!\u0001X/\u0002\u000f\r|g\u000e\u001e:pY*\u0011a\fN\u0001\u0005kRLG.\u0003\u0002a7\naaj\\*uC\u000e\\GK]1dKR\t\u0011*A\u0006sK\u0006$'+Z:pYZ,G#\u00013\u0011\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017\u0001\u00027b]\u001eT\u0011![\u0001\u0005U\u00064\u0018-\u0003\u0002lM\n1qJ\u00196fGR\u0014qaQ;sg>\u00148o\u0005\u0002!eU\tq\u000eE\u0002OaJL!!\u001d-\u0003\t1K7\u000f\u001e\t\u0003\u0015\n\u0012aaQ;sg>\u00148C\u0001\u00123\u0003\u0019\u0019WO]:peV\t!(\u0001\u0006dkJ\u001cxN]0%KF$\"!\u001f?\u0011\u0005MR\u0018BA>5\u0005\u0011)f.\u001b;\t\u000bu$\u0003\u0019\u0001\u001e\u0002\u0005%D\bF\u0001\u000e\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003U\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u00111\u0001\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e\u000b\u0002\u001a\u007f\u0006A1-\u001e:t_J\u001c\b\u0005\u0006\u0005\u0002\u0012\u0005%\u00121FA\u0017!\u0011\u0011\u0005!a\u0005\u0011\t\u0005U\u0011q\u0003\u0007\u0001\t\u001d\tI\u0002\u0001b\u0001\u00037\u0011\u0011\u0001V\t\u0005\u0003;\t\u0019\u0003E\u00024\u0003?I1!!\t5\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aMA\u0013\u0013\r\t9\u0003\u000e\u0002\u0004\u0003:L\b\"\u0002\u001d\u0006\u0001\u0004Q\u0004\"B\u001f\u0006\u0001\u0004Q\u0004\"\u0002 \u0006\u0001\u0004\u0001\u0015AC7bqNK'0\u001a\"ji\u0006)\u0011M\u001d:bsB)1'!\u000e\u0002$%\u0019\u0011q\u0007\u001b\u0003\u000b\u0005\u0013(/Y=\u0002\u000f]\u0014\u0018\u000e^3Jq\u00061!/Z1e\u0013b\fa\u0001\\3o\u0005&$\u0018\u0001B7bg.\fAa]5{K\u00069\u0011n]#naRLXCAA$!\r\u0019\u0014\u0011J\u0005\u0004\u0003\u0017\"$a\u0002\"p_2,\u0017M\\\u0001\t]>tW)\u001c9us\u0006!\u0012.\\7fI&\fG/\u001a7z\u0003Z\f\u0017\u000e\\1cY\u0016\fA\"\\1y\u0003Z\f\u0017\u000e\\1cY\u0016\fQaY8v]R$2AOA,\u0011\u0019)\u0018\u00031\u0001\u0002ZA\u0011\u0011II\u0001\u000bS:LGoQ;sg>\u0014HcA=\u0002`!1QO\u0005a\u0001\u00033\nQa\u001e:ji\u0016$B!a\u0012\u0002f!9\u0011qM\nA\u0002\u0005M\u0011!\u0002<bYV,\u0017\u0001\u0002:fC\u0012$B!a\u0005\u0002n!1Q\u000f\u0006a\u0001\u00033\nqb\u001c8DkJ\u001cxN\u001d*f[>4X\r\u001a\u000b\u0004s\u0006M\u0004BB;\u0016\u0001\u0004\tI&\u0001\u0007va\u0012\fG/\u001a*fC\u0012L\u0005\u0010F\u0001z\u0003=)h\u000eZ3sYfLgnZ!se\u0006LXCAA\u001a\u0003!!xn\u0015;sS:<GCAAA!\u0011\t\u0019)a#\u000f\t\u0005\u0015\u0015q\u0011\t\u0003!RJ1!!#5\u0003\u0019\u0001&/\u001a3fM&!\u0011QRAH\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0012\u001b)\u0005\u0001y\b")
@InternalApi
public class ResizableMultiReaderRingBuffer<T> {
    private final Cursors cursors;
    private final int maxSizeBit;
    private Object[] array;
    private int writeIx;
    private int readIx;

    public Cursors cursors() {
        return this.cursors;
    }

    private int lenBit() {
        return Integer.numberOfTrailingZeros(this.array.length);
    }

    private int mask() {
        return Integer.MAX_VALUE >> 31 - this.lenBit();
    }

    public int size() {
        return this.writeIx - this.readIx;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int immediatelyAvailable() {
        return this.array.length - this.size();
    }

    public int maxAvailable() {
        return (1 << this.maxSizeBit) - this.size();
    }

    public int count(Cursor cursor) {
        return this.writeIx - cursor.cursor();
    }

    public void initCursor(Cursor cursor) {
        cursor.cursor_$eq(this.readIx);
    }

    public boolean write(T value) {
        if (this.size() < this.array.length) {
            this.array[this.writeIx & this.mask()] = value;
            ++this.writeIx;
            return true;
        }
        if (this.lenBit() < this.maxSizeBit) {
            int r = this.readIx & this.mask();
            Object[] newArray = new Object[this.array.length << 1];
            System.arraycopy(this.array, r, newArray, 0, this.array.length - r);
            System.arraycopy(this.array, 0, newArray, this.array.length - r, r);
            this.rebaseCursors$1(this.cursors().cursors());
            this.array = newArray;
            int w = this.size();
            this.array[w & this.mask()] = value;
            this.writeIx = w + 1;
            this.readIx = 0;
            return true;
        }
        return false;
    }

    public T read(Cursor cursor) {
        int c = cursor.cursor();
        if (c - this.writeIx < 0) {
            cursor.cursor_$eq(cursor.cursor() + 1);
            Object ret = this.array[c & this.mask()];
            if (c == this.readIx) {
                this.updateReadIx();
            }
            return (T)ret;
        }
        throw ResizableMultiReaderRingBuffer$NothingToReadException$.MODULE$;
    }

    public void onCursorRemoved(Cursor cursor) {
        if (cursor.cursor() == this.readIx) {
            this.updateReadIx();
            return;
        }
    }

    private void updateReadIx() {
        int newReadIx = this.writeIx + this.minCursor$1(this.cursors().cursors(), 0);
        while (this.readIx != newReadIx) {
            this.array[this.readIx & this.mask()] = null;
            ++this.readIx;
        }
    }

    public Object[] underlyingArray() {
        return this.array;
    }

    public String toString() {
        return new StringBuilder(66).append("ResizableMultiReaderRingBuffer(size=").append(this.size()).append(", writeIx=").append(this.writeIx).append(", readIx=").append(this.readIx).append(", cursors=").append(this.cursors().cursors().size()).append(")").toString();
    }

    private final void rebaseCursors$1(List remaining) {
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Cursor head = (Cursor)colon2.head();
            List tail = colon2.tl$access$1();
            head.cursor_$eq(head.cursor() - this.readIx);
            remaining = tail;
        }
    }

    private final int minCursor$1(List remaining, int result) {
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Cursor head = (Cursor)colon2.head();
            List tail = colon2.tl$access$1();
            result = package$.MODULE$.min(head.cursor() - this.writeIx, result);
            remaining = tail;
        }
        return result;
    }

    public ResizableMultiReaderRingBuffer(int initialSize, int maxSize, Cursors cursors) {
        this.cursors = cursors;
        Predef$.MODULE$.require(Integer.lowestOneBit(maxSize) == maxSize && 0 < maxSize && maxSize <= 0x3FFFFFFF, (Function0 & java.io.Serializable & Serializable)() -> "maxSize must be a power of 2 that is > 0 and < Int.MaxValue/2");
        Predef$.MODULE$.require(Integer.lowestOneBit(initialSize) == initialSize && 0 < initialSize && initialSize <= maxSize, (Function0 & java.io.Serializable & Serializable)() -> "initialSize must be a power of 2 that is > 0 and <= maxSize");
        this.maxSizeBit = Integer.numberOfTrailingZeros(maxSize);
        this.array = new Object[initialSize];
        this.writeIx = 0;
        this.readIx = 0;
    }

    public static interface Cursor {
        public int cursor();

        public void cursor_$eq(int var1);
    }

    public static interface Cursors {
        public List<Cursor> cursors();
    }
}

