/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.topic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class TopicValidator {
    private static final String VALID_PATTERN_STR = "^[%|a-zA-Z0-9_-]+$";
    private static final Pattern PATTERN = Pattern.compile("^[%|a-zA-Z0-9_-]+$");
    private static final int TOPIC_MAX_LENGTH = 127;

    private static boolean regularExpressionMatcher(String origin, Pattern pattern) {
        if (pattern == null) {
            return true;
        }
        Matcher matcher = pattern.matcher(origin);
        return matcher.matches();
    }

    public static boolean validateTopic(String topic, RemotingCommand response) {
        if (UtilAll.isBlank((String)topic)) {
            response.setCode(1);
            response.setRemark("The specified topic is blank.");
            return false;
        }
        if (!TopicValidator.regularExpressionMatcher(topic, PATTERN)) {
            response.setCode(1);
            response.setRemark("The specified topic contains illegal characters, allowing only ^[%|a-zA-Z0-9_-]+$");
            return false;
        }
        if (topic.length() > 127) {
            response.setCode(1);
            response.setRemark("The specified topic is longer than topic max length.");
            return false;
        }
        if (topic.equals("TBW102")) {
            response.setCode(1);
            response.setRemark("The specified topic is conflict with AUTO_CREATE_TOPIC_KEY_TOPIC.");
            return false;
        }
        return true;
    }
}

