/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.rmq;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.test.clientinterface.AbstractMQProducer;
import org.apache.rocketmq.test.sendresult.SendResult;
import org.apache.rocketmq.test.util.RandomUtil;
import org.apache.rocketmq.test.util.TestUtil;

public class RMQAsyncSendProducer
extends AbstractMQProducer {
    private static Logger logger = Logger.getLogger(RMQAsyncSendProducer.class);
    private String nsAddr = null;
    private DefaultMQProducer producer = null;
    private SendCallback sendCallback = null;
    private List<org.apache.rocketmq.client.producer.SendResult> successSendResult = new ArrayList<org.apache.rocketmq.client.producer.SendResult>();
    private AtomicInteger exceptionMsgCount = new AtomicInteger(0);
    private int msgSize = 0;

    public RMQAsyncSendProducer(String nsAddr, String topic) {
        super(topic);
        this.nsAddr = nsAddr;
        this.sendCallback = new SendCallback(){

            public void onSuccess(org.apache.rocketmq.client.producer.SendResult sendResult) {
                RMQAsyncSendProducer.this.successSendResult.add(sendResult);
            }

            public void onException(Throwable throwable) {
                RMQAsyncSendProducer.this.exceptionMsgCount.getAndIncrement();
            }
        };
        this.create();
        this.start();
    }

    public int getSuccessMsgCount() {
        return this.successSendResult.size();
    }

    public List<org.apache.rocketmq.client.producer.SendResult> getSuccessSendResult() {
        return this.successSendResult;
    }

    public int getExceptionMsgCount() {
        return this.exceptionMsgCount.get();
    }

    private void create() {
        this.producer = new DefaultMQProducer();
        this.producer.setProducerGroup(RandomUtil.getStringByUUID());
        this.producer.setInstanceName(RandomUtil.getStringByUUID());
        if (this.nsAddr != null) {
            this.producer.setNamesrvAddr(this.nsAddr);
        }
    }

    private void start() {
        try {
            this.producer.start();
        }
        catch (MQClientException e) {
            logger.error((Object)"producer start failed!");
            e.printStackTrace();
        }
    }

    @Override
    public SendResult send(Object msg, Object arg) {
        return null;
    }

    @Override
    public void shutdown() {
        this.producer.shutdown();
    }

    public void asyncSend(Object msg) {
        Message metaqMsg = (Message)msg;
        try {
            this.producer.send(metaqMsg, this.sendCallback);
            this.msgBodys.addData(new String(metaqMsg.getBody()));
            this.originMsgs.addData(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void asyncSend(int msgSize) {
        this.msgSize = msgSize;
        for (int i = 0; i < msgSize; ++i) {
            Message msg = new Message(this.topic, RandomUtil.getStringByUUID().getBytes());
            this.asyncSend(msg);
        }
    }

    public void asyncSend(Object msg, MessageQueueSelector selector, Object arg) {
        Message metaqMsg = (Message)msg;
        try {
            this.producer.send(metaqMsg, selector, arg, this.sendCallback);
            this.msgBodys.addData(new String(metaqMsg.getBody()));
            this.originMsgs.addData(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void asyncSend(int msgSize, MessageQueueSelector selector) {
        this.msgSize = msgSize;
        for (int i = 0; i < msgSize; ++i) {
            Message msg = new Message(this.topic, RandomUtil.getStringByUUID().getBytes());
            this.asyncSend(msg, selector, i);
        }
    }

    public void asyncSend(Object msg, MessageQueue mq) {
        Message metaqMsg = (Message)msg;
        try {
            this.producer.send(metaqMsg, mq, this.sendCallback);
            this.msgBodys.addData(new String(metaqMsg.getBody()));
            this.originMsgs.addData(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void asyncSend(int msgSize, MessageQueue mq) {
        this.msgSize = msgSize;
        for (int i = 0; i < msgSize; ++i) {
            Message msg = new Message(this.topic, RandomUtil.getStringByUUID().getBytes());
            this.asyncSend(msg, mq);
        }
    }

    public void waitForResponse(int timeoutMills) {
        long startTime = System.currentTimeMillis();
        while (this.successSendResult.size() != this.msgSize) {
            if (System.currentTimeMillis() - startTime < (long)timeoutMills) {
                TestUtil.waitForMonment(100L);
                continue;
            }
            logger.info((Object)"timeout but still not recv all response!");
            break;
        }
    }

    public void sendOneWay(Object msg) {
        Message metaqMsg = (Message)msg;
        try {
            this.producer.sendOneway(metaqMsg);
            this.msgBodys.addData(new String(metaqMsg.getBody()));
            this.originMsgs.addData(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendOneWay(int msgSize) {
        for (int i = 0; i < msgSize; ++i) {
            Message msg = new Message(this.topic, RandomUtil.getStringByUUID().getBytes());
            this.sendOneWay(msg);
        }
    }

    public void sendOneWay(Object msg, MessageQueue mq) {
        Message metaqMsg = (Message)msg;
        try {
            this.producer.sendOneway(metaqMsg, mq);
            this.msgBodys.addData(new String(metaqMsg.getBody()));
            this.originMsgs.addData(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendOneWay(int msgSize, MessageQueue mq) {
        for (int i = 0; i < msgSize; ++i) {
            Message msg = new Message(this.topic, RandomUtil.getStringByUUID().getBytes());
            this.sendOneWay(msg, mq);
        }
    }

    public void sendOneWay(Object msg, MessageQueueSelector selector, Object arg) {
        Message metaqMsg = (Message)msg;
        try {
            this.producer.sendOneway(metaqMsg, selector, arg);
            this.msgBodys.addData(new String(metaqMsg.getBody()));
            this.originMsgs.addData(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendOneWay(int msgSize, MessageQueueSelector selector) {
        for (int i = 0; i < msgSize; ++i) {
            Message msg = new Message(this.topic, RandomUtil.getStringByUUID().getBytes());
            this.sendOneWay(msg, selector, i);
        }
    }
}

