/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.client;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolFactory;

public class ClientPoolManager<CLIENT_POOL> {
    private Vertx vertx;
    private String id = UUID.randomUUID().toString();
    private ClientPoolFactory<CLIENT_POOL> factory;
    private List<CLIENT_POOL> pools = new CopyOnWriteArrayList<CLIENT_POOL>();
    private AtomicInteger reactiveNextIndex = new AtomicInteger();

    public ClientPoolManager(Vertx vertx, ClientPoolFactory<CLIENT_POOL> factory) {
        this.vertx = vertx;
        this.factory = factory;
    }

    public CLIENT_POOL createClientPool() {
        CLIENT_POOL pool = this.factory.createClientPool();
        this.addPool(pool);
        return pool;
    }

    protected void addPool(CLIENT_POOL pool) {
        Vertx.currentContext().put(this.id, pool);
        this.pools.add(pool);
    }

    public CLIENT_POOL findClientPool(boolean sync) {
        if (sync) {
            return this.findThreadBindClientPool();
        }
        return this.findByContext();
    }

    protected CLIENT_POOL findByContext() {
        Context currentContext = Vertx.currentContext();
        if (currentContext != null && currentContext.owner() == this.vertx && currentContext.isEventLoopContext()) {
            Object clientPool = currentContext.get(this.id);
            if (clientPool != null) {
                return (CLIENT_POOL)clientPool;
            }
            return this.createClientPool();
        }
        int idx = this.reactiveNextIndex.getAndIncrement() % this.pools.size();
        if (idx < 0) {
            idx = -idx;
        }
        return this.pools.get(idx);
    }

    public CLIENT_POOL findThreadBindClientPool() {
        int idx = (int)(Thread.currentThread().getId() % (long)this.pools.size());
        return this.pools.get(idx);
    }
}

