/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamToReadStream
implements ReadStream<Buffer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamToReadStream.class);
    public static final int DEFAULT_READ_BUFFER_SIZE = 8192;
    private Vertx vertx;
    private InputStream inputStream;
    private boolean closed;
    private boolean paused;
    private boolean readInProgress;
    private int readBufferSize = 8192;
    private Handler<Throwable> exceptionHandler = this::unhandledException;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;

    public InputStreamToReadStream(Vertx vertx, InputStream inputStream) {
        this.vertx = vertx;
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public synchronized InputStreamToReadStream readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    private void check() {
        if (this.closed) {
            throw new IllegalStateException("inputStream is closed");
        }
    }

    private void unhandledException(Throwable t) {
        LOGGER.error("Unhandled exception", t);
    }

    public synchronized InputStreamToReadStream exceptionHandler(Handler<Throwable> handler) {
        this.check();
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized InputStreamToReadStream handler(Handler<Buffer> handler) {
        this.check();
        this.dataHandler = handler;
        if (this.dataHandler != null && !this.paused && !this.closed) {
            this.doRead();
        }
        return this;
    }

    private synchronized void doRead() {
        if (!this.readInProgress) {
            this.readInProgress = true;
            this.vertx.executeBlocking(this::readInWorker, false, this::afterReadInEventloop);
        }
    }

    private synchronized void readInWorker(Future<ReadResult> future) {
        try {
            ReadResult readResult = new ReadResult();
            readResult.doRead();
            future.complete((Object)readResult);
        }
        catch (Throwable e) {
            future.fail(e);
        }
    }

    private synchronized void afterReadInEventloop(AsyncResult<ReadResult> ar) {
        if (ar.failed()) {
            this.exceptionHandler.handle((Object)ar.cause());
            return;
        }
        this.readInProgress = false;
        ReadResult readResult = (ReadResult)ar.result();
        if (readResult.readed < 0) {
            this.handleEnd();
            return;
        }
        this.handleData(readResult.toBuffer());
        if (!this.paused && this.dataHandler != null) {
            this.doRead();
        }
    }

    public synchronized InputStreamToReadStream pause() {
        this.check();
        this.paused = true;
        return this;
    }

    public synchronized InputStreamToReadStream resume() {
        this.check();
        if (this.paused && !this.closed) {
            this.paused = false;
            if (this.dataHandler != null) {
                this.doRead();
            }
        }
        return this;
    }

    private synchronized void handleData(Buffer buffer) {
        if (this.dataHandler != null) {
            this.dataHandler.handle((Object)buffer);
        }
    }

    private synchronized void handleEnd() {
        this.dataHandler = null;
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    public ReadStream<Buffer> endHandler(Handler<Void> handler) {
        this.check();
        this.endHandler = handler;
        return this;
    }

    class ReadResult {
        int readed;
        byte[] bytes;

        ReadResult() {
            this.bytes = new byte[InputStreamToReadStream.this.readBufferSize];
        }

        void doRead() throws IOException {
            this.readed = InputStreamToReadStream.this.inputStream.read(this.bytes);
        }

        Buffer toBuffer() {
            return Buffer.buffer((ByteBuf)Unpooled.wrappedBuffer((byte[])this.bytes).writerIndex(this.readed));
        }
    }
}

