/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodePath;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.ServerStatisticsAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.domain.ServerBriefInfo;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ServerStatisticsAPIImpl
implements ServerStatisticsAPI {
    private final CoordinatorRegistryCenter regCenter;

    @Override
    public int getServersTotalCount() {
        HashSet servers = new HashSet();
        for (String jobName : this.regCenter.getChildrenKeys("/")) {
            JobNodePath jobNodePath = new JobNodePath(jobName);
            servers.addAll(this.regCenter.getChildrenKeys(jobNodePath.getServerNodePath()));
        }
        return servers.size();
    }

    @Override
    public Collection<ServerBriefInfo> getAllServersBriefInfo() {
        ConcurrentHashMap<String, ServerBriefInfo> servers = new ConcurrentHashMap<String, ServerBriefInfo>();
        for (String jobName : this.regCenter.getChildrenKeys("/")) {
            JobNodePath jobNodePath = new JobNodePath(jobName);
            for (String each : this.regCenter.getChildrenKeys(jobNodePath.getServerNodePath())) {
                servers.putIfAbsent(each, new ServerBriefInfo(each));
                ServerBriefInfo serverInfo = (ServerBriefInfo)servers.get(each);
                if ("DISABLED".equalsIgnoreCase(this.regCenter.get(jobNodePath.getServerNodePath(each)))) {
                    serverInfo.getDisabledJobsNum().incrementAndGet();
                }
                serverInfo.getJobNames().add(jobName);
                serverInfo.setJobsNum(serverInfo.getJobNames().size());
            }
            List instances = this.regCenter.getChildrenKeys(jobNodePath.getInstancesNodePath());
            for (String each : instances) {
                JobInstance jobInstance = (JobInstance)YamlEngine.unmarshal((String)this.regCenter.get(jobNodePath.getInstanceNodePath(each)), JobInstance.class);
                ServerBriefInfo serverInfo = (ServerBriefInfo)servers.get(jobInstance.getServerIp());
                if (null == serverInfo) continue;
                serverInfo.getInstances().add(each);
                serverInfo.setInstancesNum(serverInfo.getInstances().size());
            }
        }
        ArrayList<ServerBriefInfo> result = new ArrayList<ServerBriefInfo>(servers.values());
        Collections.sort(result);
        return result;
    }

    @Generated
    public ServerStatisticsAPIImpl(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }
}

