/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.encrypt.merge.dal.DALEncryptMergeEngine;
import org.apache.shardingsphere.encrypt.merge.dql.DQLEncryptMergeEngine;
import org.apache.shardingsphere.encrypt.merge.dql.EncryptorMetaData;
import org.apache.shardingsphere.sharding.merge.MergeEngineFactory;
import org.apache.shardingsphere.shardingproxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.QueryHeaderEncryptorMetaData;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.ConnectionStatus;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.JDBCExecuteEngine;
import org.apache.shardingsphere.shardingproxy.backend.exception.TableModifyInTransactionException;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.update.UpdateResponse;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.EncryptSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.ShardingSchema;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;
import org.apache.shardingsphere.spi.database.DatabaseType;
import org.apache.shardingsphere.spi.encrypt.ShardingEncryptor;
import org.apache.shardingsphere.sql.parser.relation.metadata.RelationMetas;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.sql.parser.relation.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.DDLStatement;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.underlying.merge.MergedResult;

public final class JDBCDatabaseCommunicationEngine
implements DatabaseCommunicationEngine {
    private final LogicSchema logicSchema;
    private final String sql;
    private final JDBCExecuteEngine executeEngine;
    private BackendResponse response;
    private MergedResult mergedResult;

    @Override
    public BackendResponse execute() {
        try {
            SQLRouteResult routeResult = this.executeEngine.getJdbcExecutorWrapper().route(this.sql);
            return this.execute(routeResult);
        }
        catch (SQLException ex) {
            return new ErrorResponse(ex);
        }
    }

    private BackendResponse execute(SQLRouteResult routeResult) throws SQLException {
        if (routeResult.getRouteUnits().isEmpty()) {
            return new UpdateResponse();
        }
        SQLStatementContext sqlStatementContext = routeResult.getSqlStatementContext();
        if (this.isExecuteDDLInXATransaction(sqlStatementContext.getSqlStatement())) {
            return new ErrorResponse(new TableModifyInTransactionException(sqlStatementContext.getTablesContext().isSingleTable() ? sqlStatementContext.getTablesContext().getSingleTableName() : "unknown_table"));
        }
        this.response = this.executeEngine.execute(routeResult);
        if (this.logicSchema instanceof ShardingSchema) {
            this.logicSchema.refreshTableMetaData(routeResult.getSqlStatementContext());
        }
        return this.merge(routeResult);
    }

    private boolean isExecuteDDLInXATransaction(SQLStatement sqlStatement) {
        BackendConnection connection = this.executeEngine.getBackendConnection();
        return TransactionType.XA == connection.getTransactionType() && sqlStatement instanceof DDLStatement && ConnectionStatus.TRANSACTION == connection.getStateHandler().getStatus();
    }

    private BackendResponse merge(SQLRouteResult routeResult) throws SQLException {
        if (this.response instanceof UpdateResponse) {
            this.mergeUpdateCount(routeResult);
            return this.response;
        }
        this.mergedResult = this.getMergedResult(routeResult);
        this.handleColumnsForQueryHeader(routeResult);
        return this.response;
    }

    private void mergeUpdateCount(SQLRouteResult routeResult) {
        if (!this.isAllBroadcastTables(routeResult.getSqlStatementContext())) {
            ((UpdateResponse)this.response).mergeUpdateCount();
        }
    }

    private boolean isAllBroadcastTables(SQLStatementContext sqlStatementContext) {
        return this.logicSchema instanceof ShardingSchema && this.logicSchema.getShardingRule().isAllBroadcastTables(sqlStatementContext.getTablesContext().getTableNames());
    }

    private MergedResult getMergedResult(SQLRouteResult routeResult) throws SQLException {
        EncryptRule encryptRule = this.getEncryptRule();
        if (null != encryptRule && routeResult.getSqlStatementContext() instanceof DALStatement) {
            return new DALEncryptMergeEngine(encryptRule, ((QueryResponse)this.response).getQueryResults(), routeResult.getSqlStatementContext()).merge();
        }
        MergedResult mergedResult = MergeEngineFactory.newInstance((DatabaseType)LogicSchemas.getInstance().getDatabaseType(), (ShardingRule)this.logicSchema.getShardingRule(), (SQLRouteResult)routeResult, (RelationMetas)this.logicSchema.getMetaData().getRelationMetas(), ((QueryResponse)this.response).getQueryResults()).merge();
        if (null == encryptRule) {
            return mergedResult;
        }
        boolean queryWithCipherColumn = (Boolean)ShardingProxyContext.getInstance().getShardingProperties().getValue(ShardingPropertiesConstant.QUERY_WITH_CIPHER_COLUMN);
        DQLEncryptMergeEngine mergeEngine = new DQLEncryptMergeEngine((EncryptorMetaData)new QueryHeaderEncryptorMetaData(this.getEncryptRule(), ((QueryResponse)this.response).getQueryHeaders()), mergedResult, queryWithCipherColumn);
        return mergeEngine.merge();
    }

    private void handleColumnsForQueryHeader(SQLRouteResult routeResult) {
        this.removeDerivedColumns();
        this.removeAssistedQueryColumns(routeResult);
        this.setLogicColumns();
    }

    private void removeDerivedColumns() {
        LinkedList<QueryHeader> toRemove = new LinkedList<QueryHeader>();
        List<QueryHeader> queryHeaders = ((QueryResponse)this.response).getQueryHeaders();
        for (QueryHeader each : queryHeaders) {
            if (!DerivedColumn.isDerivedColumn((String)each.getColumnLabel())) continue;
            toRemove.add(each);
        }
        queryHeaders.removeAll(toRemove);
    }

    private void removeAssistedQueryColumns(SQLRouteResult routeResult) {
        LinkedList<QueryHeader> toRemove = new LinkedList<QueryHeader>();
        List<QueryHeader> queryHeaders = ((QueryResponse)this.response).getQueryHeaders();
        Collection<String> assistedQueryColumns = this.getAssistedQueryColumns(routeResult);
        for (QueryHeader each : queryHeaders) {
            if (!assistedQueryColumns.contains(each.getColumnName())) continue;
            toRemove.add(each);
        }
        queryHeaders.removeAll(toRemove);
    }

    private Collection<String> getAssistedQueryColumns(SQLRouteResult routeResult) {
        LinkedList<String> result = new LinkedList<String>();
        EncryptRule encryptRule = this.getEncryptRule();
        for (String each : routeResult.getSqlStatementContext().getTablesContext().getTableNames()) {
            result.addAll(encryptRule.getAssistedQueryColumns(each));
        }
        return result;
    }

    private EncryptRule getEncryptRule() {
        return this.logicSchema instanceof EncryptSchema ? ((EncryptSchema)this.logicSchema).getEncryptRule() : this.logicSchema.getShardingRule().getEncryptRule();
    }

    private void setLogicColumns() {
        List<QueryHeader> queryHeaders = ((QueryResponse)this.response).getQueryHeaders();
        EncryptRule encryptRule = this.getEncryptRule();
        for (QueryHeader each : queryHeaders) {
            if (!encryptRule.isCipherColumn(each.getTable(), each.getColumnName())) continue;
            each.setColumnLabelAndName(encryptRule.getLogicColumnOfCipher(each.getTable(), each.getColumnName()));
        }
    }

    @Override
    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public QueryData getQueryData() throws SQLException {
        Optional<EncryptRule> encryptRule = this.findEncryptRule();
        boolean isQueryWithCipherColumn = (Boolean)ShardingProxyContext.getInstance().getShardingProperties().getValue(ShardingPropertiesConstant.QUERY_WITH_CIPHER_COLUMN);
        List<QueryHeader> queryHeaders = ((QueryResponse)this.response).getQueryHeaders();
        ArrayList<Object> row = new ArrayList<Object>(queryHeaders.size());
        for (int columnIndex = 1; columnIndex <= queryHeaders.size(); ++columnIndex) {
            Object value = this.mergedResult.getValue(columnIndex, Object.class);
            if (isQueryWithCipherColumn && encryptRule.isPresent()) {
                QueryHeader queryHeader = ((QueryResponse)this.response).getQueryHeaders().get(columnIndex - 1);
                Optional shardingEncryptor = ((EncryptRule)encryptRule.get()).findShardingEncryptor(queryHeader.getTable(), queryHeader.getColumnName());
                if (shardingEncryptor.isPresent()) {
                    value = ((ShardingEncryptor)shardingEncryptor.get()).decrypt(this.getCiphertext(value));
                }
            }
            row.add(value);
        }
        return new QueryData(this.getColumnTypes(queryHeaders), row);
    }

    private Optional<EncryptRule> findEncryptRule() {
        if (this.logicSchema instanceof ShardingSchema) {
            return Optional.of((Object)this.logicSchema.getShardingRule().getEncryptRule());
        }
        if (this.logicSchema instanceof EncryptSchema) {
            return Optional.of((Object)((EncryptSchema)this.logicSchema).getEncryptRule());
        }
        return Optional.absent();
    }

    private String getCiphertext(Object value) {
        return null == value ? null : value.toString();
    }

    private List<Integer> getColumnTypes(List<QueryHeader> queryHeaders) {
        ArrayList<Integer> result = new ArrayList<Integer>(queryHeaders.size());
        for (QueryHeader each : queryHeaders) {
            result.add(each.getColumnType());
        }
        return result;
    }

    @ConstructorProperties(value={"logicSchema", "sql", "executeEngine"})
    public JDBCDatabaseCommunicationEngine(LogicSchema logicSchema, String sql, JDBCExecuteEngine executeEngine) {
        this.logicSchema = logicSchema;
        this.sql = sql;
        this.executeEngine = executeEngine;
    }
}

