/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema;

import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.shardingsphere.core.config.DatabaseAccessConfiguration;
import org.apache.shardingsphere.core.constant.properties.ShardingProperties;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.database.DatabaseTypes;
import org.apache.shardingsphere.core.execute.metadata.TableMetaDataConnectionManager;
import org.apache.shardingsphere.core.execute.metadata.TableMetaDataInitializer;
import org.apache.shardingsphere.core.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.core.metadata.datasource.DataSourceMetas;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.orchestration.internal.eventbus.ShardingOrchestrationEventBus;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.DataSourceChangedEvent;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.datasource.JDBCBackendDataSource;
import org.apache.shardingsphere.shardingproxy.backend.executor.BackendExecutorContext;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.backend.schema.ProxyTableMetaDataConnectionManager;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;
import org.apache.shardingsphere.shardingproxy.util.DataSourceConverter;
import org.apache.shardingsphere.spi.database.DatabaseType;
import org.apache.shardingsphere.sql.parser.SQLParseEngine;
import org.apache.shardingsphere.sql.parser.SQLParseEngineFactory;
import org.apache.shardingsphere.sql.parser.relation.statement.SQLStatementContext;

public abstract class LogicSchema {
    private final String name;
    private final SQLParseEngine parseEngine;
    private JDBCBackendDataSource backendDataSource;

    public LogicSchema(String name, Map<String, YamlDataSourceParameter> dataSources) {
        this.name = name;
        this.parseEngine = SQLParseEngineFactory.getSQLParseEngine((String)DatabaseTypes.getTrunkDatabaseTypeName((DatabaseType)LogicSchemas.getInstance().getDatabaseType()));
        this.backendDataSource = new JDBCBackendDataSource(dataSources);
        ShardingOrchestrationEventBus.getInstance().register((Object)this);
    }

    protected final Map<String, DatabaseAccessConfiguration> getDatabaseAccessConfigurationMap() {
        HashMap<String, DatabaseAccessConfiguration> result = new HashMap<String, DatabaseAccessConfiguration>(this.backendDataSource.getDataSourceParameters().size(), 1.0f);
        for (Map.Entry<String, YamlDataSourceParameter> entry : this.backendDataSource.getDataSourceParameters().entrySet()) {
            YamlDataSourceParameter dataSource = entry.getValue();
            DatabaseAccessConfiguration dataSourceInfo = new DatabaseAccessConfiguration(dataSource.getUrl(), null, null);
            result.put(entry.getKey(), dataSourceInfo);
        }
        return result;
    }

    public abstract ShardingSphereMetaData getMetaData();

    public abstract ShardingRule getShardingRule();

    public Map<String, YamlDataSourceParameter> getDataSources() {
        return this.backendDataSource.getDataSourceParameters();
    }

    protected final TableMetaDataInitializer getTableMetaDataInitializer(DataSourceMetas dataSourceMetas) {
        ShardingProperties shardingProperties = ShardingProxyContext.getInstance().getShardingProperties();
        return new TableMetaDataInitializer(dataSourceMetas, BackendExecutorContext.getInstance().getExecuteEngine(), (TableMetaDataConnectionManager)new ProxyTableMetaDataConnectionManager(this.getBackendDataSource()), ((Integer)shardingProperties.getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue(), ((Boolean)shardingProperties.getValue(ShardingPropertiesConstant.CHECK_TABLE_METADATA_ENABLED)).booleanValue());
    }

    @Subscribe
    public final synchronized void renew(DataSourceChangedEvent dataSourceChangedEvent) throws Exception {
        if (!this.name.equals(dataSourceChangedEvent.getShardingSchemaName())) {
            return;
        }
        this.backendDataSource.renew(DataSourceConverter.getDataSourceParameterMap((Map)dataSourceChangedEvent.getDataSourceConfigurations()));
    }

    public void refreshTableMetaData(SQLStatementContext sqlStatementContext) throws SQLException {
    }

    public String getName() {
        return this.name;
    }

    public SQLParseEngine getParseEngine() {
        return this.parseEngine;
    }

    public JDBCBackendDataSource getBackendDataSource() {
        return this.backendDataSource;
    }
}

