/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema.impl;

import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Map;
import org.apache.shardingsphere.api.config.encrypt.EncryptRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.config.log.ConfigurationLogger;
import org.apache.shardingsphere.core.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.core.metadata.datasource.DataSourceMetas;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.EncryptRuleChangedEvent;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class EncryptSchema
extends LogicSchema {
    private final ShardingSphereMetaData metaData;
    private final ShardingRule shardingRule;
    private EncryptRule encryptRule;

    public EncryptSchema(String name, Map<String, YamlDataSourceParameter> dataSources, EncryptRuleConfiguration encryptRuleConfiguration) throws SQLException {
        super(name, dataSources);
        this.encryptRule = new EncryptRule(encryptRuleConfiguration);
        this.shardingRule = new ShardingRule(new ShardingRuleConfiguration(), this.getDataSources().keySet());
        this.metaData = this.createMetaData();
    }

    private ShardingSphereMetaData createMetaData() throws SQLException {
        DataSourceMetas dataSourceMetas = new DataSourceMetas(LogicSchemas.getInstance().getDatabaseType(), this.getDatabaseAccessConfigurationMap());
        TableMetas tableMetas = new TableMetas(this.getTableMetaDataInitializer(dataSourceMetas).load(this.shardingRule));
        return new ShardingSphereMetaData(dataSourceMetas, tableMetas);
    }

    @Subscribe
    public synchronized void renew(EncryptRuleChangedEvent encryptRuleChangedEvent) {
        ConfigurationLogger.log((EncryptRuleConfiguration)encryptRuleChangedEvent.getEncryptRuleConfiguration());
        this.encryptRule = new EncryptRule(encryptRuleChangedEvent.getEncryptRuleConfiguration());
    }

    @Override
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public EncryptRule getEncryptRule() {
        return this.encryptRule;
    }
}

