/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema.impl;

import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Map;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.config.log.ConfigurationLogger;
import org.apache.shardingsphere.core.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.core.metadata.datasource.DataSourceMetas;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.MasterSlaveRuleChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.schema.OrchestrationShardingSchema;
import org.apache.shardingsphere.orchestration.internal.rule.OrchestrationMasterSlaveRule;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class MasterSlaveSchema
extends LogicSchema {
    private MasterSlaveRule masterSlaveRule;
    private final ShardingRule shardingRule;
    private final ShardingSphereMetaData metaData;

    public MasterSlaveSchema(String name, Map<String, YamlDataSourceParameter> dataSources, MasterSlaveRuleConfiguration masterSlaveRuleConfig, boolean isUsingRegistry) throws SQLException {
        super(name, dataSources);
        this.masterSlaveRule = this.createMasterSlaveRule(masterSlaveRuleConfig, isUsingRegistry);
        this.shardingRule = new ShardingRule(new ShardingRuleConfiguration(), this.getDataSources().keySet());
        this.metaData = this.createMetaData();
    }

    private MasterSlaveRule createMasterSlaveRule(MasterSlaveRuleConfiguration masterSlaveRuleConfig, boolean isUsingRegistry) {
        return isUsingRegistry ? new OrchestrationMasterSlaveRule(masterSlaveRuleConfig) : new MasterSlaveRule(masterSlaveRuleConfig);
    }

    private ShardingSphereMetaData createMetaData() throws SQLException {
        DataSourceMetas dataSourceMetas = new DataSourceMetas(LogicSchemas.getInstance().getDatabaseType(), this.getDatabaseAccessConfigurationMap());
        TableMetas tableMetas = new TableMetas(this.getTableMetaDataInitializer(dataSourceMetas).load(this.shardingRule));
        return new ShardingSphereMetaData(dataSourceMetas, tableMetas);
    }

    @Subscribe
    public synchronized void renew(MasterSlaveRuleChangedEvent masterSlaveRuleChangedEvent) {
        if (this.getName().equals(masterSlaveRuleChangedEvent.getShardingSchemaName())) {
            ConfigurationLogger.log((MasterSlaveRuleConfiguration)masterSlaveRuleChangedEvent.getMasterSlaveRuleConfiguration());
            this.masterSlaveRule = new OrchestrationMasterSlaveRule(masterSlaveRuleChangedEvent.getMasterSlaveRuleConfiguration());
        }
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if (this.getName().equals(shardingSchema.getSchemaName())) {
            ((OrchestrationMasterSlaveRule)this.masterSlaveRule).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
        }
    }

    public MasterSlaveRule getMasterSlaveRule() {
        return this.masterSlaveRule;
    }

    @Override
    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    @Override
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }
}

