/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.HintCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.HintCommandExecutor;
import org.apache.shardingsphere.underlying.merge.MergedResult;

public abstract class AbstractHintQueryExecutor<T extends HintCommand>
implements HintCommandExecutor<T> {
    private List<QueryHeader> queryHeaders;
    private MergedResult mergedResult;

    @Override
    public final BackendResponse execute(T command) {
        this.queryHeaders = this.createQueryHeaders();
        this.mergedResult = this.createMergedResult();
        return new QueryResponse(this.queryHeaders);
    }

    protected abstract List<QueryHeader> createQueryHeaders();

    protected abstract MergedResult createMergedResult();

    @Override
    public final boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public final QueryData getQueryData() throws SQLException {
        ArrayList<Integer> columnTypes = new ArrayList<Integer>(this.queryHeaders.size());
        ArrayList<Object> row = new ArrayList<Object>(this.queryHeaders.size());
        for (int i = 0; i < this.queryHeaders.size(); ++i) {
            columnTypes.add(this.queryHeaders.get(i).getColumnType());
            row.add(this.mergedResult.getValue(i + 1, Object.class));
        }
        return new QueryData(columnTypes, row);
    }
}

