/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.atomikos.manager;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.config.UserTransactionServiceImp;
import com.atomikos.icatch.jta.UserTransactionManager;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.shardingsphere.transaction.xa.atomikos.manager.AtomikosXARecoverableResource;
import org.apache.shardingsphere.transaction.xa.spi.SingleXAResource;
import org.apache.shardingsphere.transaction.xa.spi.XATransactionManager;

public final class AtomikosTransactionManager
implements XATransactionManager {
    private final UserTransactionManager transactionManager = new UserTransactionManager();
    private final UserTransactionService userTransactionService = new UserTransactionServiceImp();

    public void init() {
        this.userTransactionService.init();
    }

    public void registerRecoveryResource(String dataSourceName, XADataSource xaDataSource) {
        this.userTransactionService.registerResource((RecoverableResource)new AtomikosXARecoverableResource(dataSourceName, xaDataSource));
    }

    public void removeRecoveryResource(String dataSourceName, XADataSource xaDataSource) {
        this.userTransactionService.removeResource((RecoverableResource)new AtomikosXARecoverableResource(dataSourceName, xaDataSource));
    }

    public void enlistResource(SingleXAResource xaResource) {
        this.transactionManager.getTransaction().enlistResource((XAResource)xaResource);
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void close() {
        this.userTransactionService.shutdown(true);
    }
}

