/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.metadata.url;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.database.metadata.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.infra.database.metadata.url.JdbcUrl;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;

public final class StandardJdbcUrlParser {
    private static final String SCHEMA_PATTERN = "(?<schema>[\\w+:%]+)\\s*";
    private static final String AUTHORITY_PATTERN = "(?://(?<authority>[^/?#]*))?\\s*";
    private static final String PATH_PATTERN = "(?:/(?!\\s*/)(?<path>[^?#]*))?";
    private static final String QUERY_PATTERN = "(?:\\?(?!\\s*\\?)(?<query>[^#]*))?";
    private static final Pattern CONNECTION_URL_PATTERN = Pattern.compile("(?<schema>[\\w+:%]+)\\s*(?://(?<authority>[^/?#]*))?\\s*(?:/(?!\\s*/)(?<path>[^?#]*))?(?:\\?(?!\\s*\\?)(?<query>[^#]*))?", 2);
    private static final String AUTHORITY_GROUP_KEY = "authority";
    private static final String PATH_GROUP_KEY = "path";
    private static final String QUERY_GROUP_KEY = "query";

    public JdbcUrl parse(String jdbcUrl) {
        Matcher matcher = CONNECTION_URL_PATTERN.matcher(jdbcUrl);
        if (matcher.matches()) {
            String authority = matcher.group(AUTHORITY_GROUP_KEY);
            ShardingSpherePreconditions.checkNotNull((Object)authority, () -> new UnrecognizedDatabaseURLException(jdbcUrl, CONNECTION_URL_PATTERN.pattern().replaceAll("%", "%%")));
            return new JdbcUrl(this.parseHostname(authority), this.parsePort(authority), matcher.group(PATH_GROUP_KEY), this.parseQueryProperties(matcher.group(QUERY_GROUP_KEY)));
        }
        throw new UnrecognizedDatabaseURLException(jdbcUrl, CONNECTION_URL_PATTERN.pattern().replaceAll("%", "%%"));
    }

    private String parseHostname(String authority) {
        if (!authority.contains(":")) {
            return authority;
        }
        return authority.split(":")[0];
    }

    private int parsePort(String authority) {
        if (!authority.contains(":")) {
            return -1;
        }
        String port = authority.split(":")[1];
        if (port.contains(",")) {
            port = port.split(",")[0];
        }
        return Integer.parseInt(port);
    }

    private Properties parseQueryProperties(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return new Properties();
        }
        Properties result = new Properties();
        for (String each : Splitter.on((String)"&").split((CharSequence)query)) {
            String[] property = each.split("=", 2);
            result.setProperty(property[0], property[1]);
        }
        return result;
    }
}

