/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.hint;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.hint.SQLHintProperties;
import org.apache.shardingsphere.infra.hint.SQLHintPropertiesKey;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.AbstractSQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SQLHintExtractor {
    private static final SQLHintProperties DEFAULT_SQL_HINT_PROPERTIES = new SQLHintProperties(new Properties());
    private final SQLHintProperties sqlHintProperties;

    public SQLHintExtractor(SQLStatement sqlStatement) {
        this.sqlHintProperties = sqlStatement instanceof AbstractSQLStatement && !((AbstractSQLStatement)sqlStatement).getCommentSegments().isEmpty() ? this.extract((AbstractSQLStatement)sqlStatement) : DEFAULT_SQL_HINT_PROPERTIES;
    }

    private SQLHintProperties extract(AbstractSQLStatement statement) {
        Properties props = new Properties();
        for (CommentSegment each : statement.getCommentSegments()) {
            props.putAll((Map<?, ?>)SQLHintUtils.getSQLHintProps(each.getText()));
        }
        return new SQLHintProperties(props);
    }

    public boolean isHintWriteRouteOnly() {
        return (Boolean)this.sqlHintProperties.getValue(SQLHintPropertiesKey.WRITE_ROUTE_ONLY_KEY);
    }

    public boolean isHintSkipEncryptRewrite() {
        return (Boolean)this.sqlHintProperties.getValue(SQLHintPropertiesKey.SKIP_ENCRYPT_REWRITE_KEY);
    }

    public Collection<String> findDisableAuditNames() {
        return SQLHintUtils.getSplitterSQLHintValue((String)this.sqlHintProperties.getValue(SQLHintPropertiesKey.DISABLE_AUDIT_NAMES_KEY));
    }

    public Comparable<?> getHintShardingDatabaseValue(String tableName) {
        Object result;
        String key = String.join((CharSequence)".", tableName.toUpperCase(), SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey());
        Object object = result = this.sqlHintProperties.getProps().containsKey(key) ? this.sqlHintProperties.getProps().get(key) : this.sqlHintProperties.getProps().get(SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey());
        if (result instanceof Comparable) {
            return (Comparable)result;
        }
        return this.sqlHintProperties.getProps().containsKey(key) ? this.sqlHintProperties.getProps().getProperty(key) : (Comparable)this.sqlHintProperties.getValue(SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY);
    }

    public boolean containsHintShardingDatabaseValue(String tableName) {
        String key = Joiner.on((String)".").join((Object)tableName.toUpperCase(), (Object)SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey(), new Object[0]);
        return this.sqlHintProperties.getProps().containsKey(key) || this.sqlHintProperties.getProps().containsKey(SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey());
    }

    public Comparable<?> getHintShardingTableValue(String tableName) {
        Object result;
        String key = String.join((CharSequence)".", tableName.toUpperCase(), SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey());
        Object object = result = this.sqlHintProperties.getProps().containsKey(key) ? this.sqlHintProperties.getProps().get(key) : this.sqlHintProperties.getProps().get(SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey());
        if (result instanceof Comparable) {
            return (Comparable)result;
        }
        return this.sqlHintProperties.getProps().containsKey(key) ? this.sqlHintProperties.getProps().getProperty(key) : (Comparable)this.sqlHintProperties.getValue(SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY);
    }

    public boolean containsHintShardingTableValue(String tableName) {
        String key = Joiner.on((String)".").join((Object)tableName.toUpperCase(), (Object)SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey(), new Object[0]);
        return this.sqlHintProperties.getProps().containsKey(key) || this.sqlHintProperties.getProps().containsKey(SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey());
    }

    @Generated
    public SQLHintProperties getSqlHintProperties() {
        return this.sqlHintProperties;
    }
}

