/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.decorator.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereView;

public final class ShardingSphereSchema {
    private final Map<String, ShardingSphereTable> tables;
    private final Map<String, ShardingSphereView> views;

    public ShardingSphereSchema() {
        this.tables = new ConcurrentHashMap<String, ShardingSphereTable>();
        this.views = new ConcurrentHashMap<String, ShardingSphereView>();
    }

    public ShardingSphereSchema(Map<String, ShardingSphereTable> tables, Map<String, ShardingSphereView> views) {
        this.tables = new ConcurrentHashMap<String, ShardingSphereTable>(tables.size(), 1.0f);
        this.views = new ConcurrentHashMap<String, ShardingSphereView>(views.size(), 1.0f);
        tables.forEach((key, value) -> this.tables.put(key.toLowerCase(), (ShardingSphereTable)value));
        views.forEach((key, value) -> this.views.put(key.toLowerCase(), (ShardingSphereView)value));
    }

    public Collection<String> getAllTableNames() {
        return this.tables.keySet();
    }

    public Collection<String> getAllViewNames() {
        return this.views.keySet();
    }

    public ShardingSphereTable getTable(String tableName) {
        return this.tables.get(tableName.toLowerCase());
    }

    public ShardingSphereView getView(String viewName) {
        return this.views.get(viewName.toLowerCase());
    }

    public void putTable(String tableName, ShardingSphereTable table) {
        this.tables.put(tableName.toLowerCase(), table);
    }

    public void putView(String viewName, ShardingSphereView view) {
        this.views.put(viewName.toLowerCase(), view);
    }

    public void putAll(Map<String, ShardingSphereTable> tables) {
        for (Map.Entry<String, ShardingSphereTable> entry : tables.entrySet()) {
            this.putTable(entry.getKey(), entry.getValue());
        }
    }

    public void removeTable(String tableName) {
        this.tables.remove(tableName.toLowerCase());
    }

    public void removeView(String viewName) {
        this.views.remove(viewName.toLowerCase());
    }

    public boolean containsTable(String tableName) {
        return this.tables.containsKey(tableName.toLowerCase());
    }

    public boolean containsColumn(String tableName, String columnName) {
        return this.containsTable(tableName) && this.getTable(tableName).getColumns().containsKey(columnName.toLowerCase());
    }

    public boolean containsIndex(String tableName, String indexName) {
        return this.containsTable(tableName) && this.getTable(tableName).getIndexes().containsKey(indexName.toLowerCase());
    }

    public boolean containsView(String viewName) {
        return this.views.containsKey(viewName.toLowerCase());
    }

    public List<String> getAllColumnNames(String tableName) {
        return this.containsTable(tableName) ? this.getTable(tableName).getColumnNames() : Collections.emptyList();
    }

    public List<String> getVisibleColumnNames(String tableName) {
        return this.containsTable(tableName) ? this.getTable(tableName).getVisibleColumns() : Collections.emptyList();
    }

    @Generated
    public Map<String, ShardingSphereTable> getTables() {
        return this.tables;
    }

    @Generated
    public Map<String, ShardingSphereView> getViews() {
        return this.views;
    }
}

