/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.exception.external.sql;

import java.sql.SQLException;
import org.apache.shardingsphere.infra.util.exception.external.ShardingSphereExternalException;
import org.apache.shardingsphere.infra.util.exception.external.sql.sqlstate.SQLState;

public abstract class ShardingSphereSQLException
extends ShardingSphereExternalException {
    private static final long serialVersionUID = -8238061892944243621L;
    private final String sqlState;
    private final int vendorCode;
    private final String reason;

    public ShardingSphereSQLException(SQLState sqlState, int typeOffset, int errorCode, String reason, Object ... messageArguments) {
        this(sqlState.getValue(), typeOffset, errorCode, reason, messageArguments);
    }

    public ShardingSphereSQLException(String sqlState, int typeOffset, int errorCode, String reason, Object ... messageArguments) {
        this.sqlState = sqlState;
        this.vendorCode = typeOffset * 10000 + errorCode;
        this.reason = null == reason ? null : String.format(reason, messageArguments);
    }

    public final SQLException toSQLException() {
        return new SQLException(this.reason, this.sqlState, this.vendorCode);
    }
}

