/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, fmt) - Converts `timestamp` to a value of string in the format specified by the date format `fmt`.", arguments="\n    Arguments:\n      * timestamp - A date/timestamp or string to be converted to the given format.\n      * fmt - Date/time format pattern to follow. See `java.text.SimpleDateFormat` for valid date\n              and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'y');\n       2016\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005L\u0001\tE\t\u0015!\u0003G\u0011!a\u0005A!f\u0001\n\u0003i\u0005\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011\u0002(\t\u000bu\u0003A\u0011\u00010\t\u000bu\u0003A\u0011A2\t\u000b\u0019\u0004A\u0011I4\t\u000b9\u0004A\u0011I8\t\u000bq\u0004A\u0011I?\t\r}\u0004A\u0011KA\u0001\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!a\f\u0001\t\u0003\n\t\u0004C\u0005\u00024\u0001\t\t\u0011\"\u0001\u00026!I\u0011Q\b\u0001\u0012\u0002\u0013\u0005\u0011q\b\u0005\n\u0003+\u0002\u0011\u0013!C\u0001\u0003\u007fA\u0011\"a\u0016\u0001#\u0003%\t!!\u0017\t\u0013\u0005u\u0003!!A\u0005B\u0005}\u0003\"CA8\u0001\u0005\u0005I\u0011AA9\u0011%\tI\bAA\u0001\n\u0003\tY\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0011\u0002\u0004\"I\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u0005\u00111\u0013\u0005\n\u0003;\u0003\u0011\u0011!C!\u0003?;\u0011\"a1$\u0003\u0003E\t!!2\u0007\u0011\t\u001a\u0013\u0011!E\u0001\u0003\u000fDa!\u0018\u000e\u0005\u0002\u0005U\u0007\"CAl5\u0005\u0005IQIAm\u0011%\tYNGA\u0001\n\u0003\u000bi\u000eC\u0005\u0002fj\t\n\u0011\"\u0001\u0002Z!I\u0011q\u001d\u000e\u0002\u0002\u0013\u0005\u0015\u0011\u001e\u0005\n\u0003oT\u0012\u0013!C\u0001\u00033B\u0011\"!?\u001b\u0003\u0003%I!a?\u0003\u001f\u0011\u000bG/\u001a$pe6\fGo\u00117bgNT!\u0001J\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003M\u001d\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003Q%\n1a]9m\u0015\tQ3&A\u0003ta\u0006\u00148N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7\u0001A\n\u0007\u0001E*\u0004hO!\u0011\u0005I\u001aT\"A\u0012\n\u0005Q\u001a#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0011d'\u0003\u00028G\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003eeJ!AO\u0012\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002=\u0005&\u00111)\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u0001G!\t\u0011t)\u0003\u0002IG\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002\u001dB\u0019AhT)\n\u0005Ak$AB(qi&|g\u000e\u0005\u0002S3:\u00111k\u0016\t\u0003)vj\u0011!\u0016\u0006\u0003->\na\u0001\u0010:p_Rt\u0014B\u0001->\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ak\u0014a\u0003;j[\u0016TvN\\3JI\u0002\na\u0001P5oSRtD\u0003B0aC\n\u0004\"A\r\u0001\t\u000b\u0011;\u0001\u0019\u0001$\t\u000b);\u0001\u0019\u0001$\t\u000f1;\u0001\u0013!a\u0001\u001dR\u0019q\fZ3\t\u000b\u0011C\u0001\u0019\u0001$\t\u000b)C\u0001\u0019\u0001$\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003W\u001e\nQ\u0001^=qKNL!!\u001c6\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0001\bcA9ws:\u0011!\u000f\u001e\b\u0003)NL\u0011AP\u0005\u0003kv\nq\u0001]1dW\u0006<W-\u0003\u0002xq\n\u00191+Z9\u000b\u0005Ul\u0004CA5{\u0013\tY(N\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006aq/\u001b;i)&lWMW8oKR\u0011QG \u0005\u0006\u0019.\u0001\r!U\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007\u0003\u0007\tI!!\u0004\u0011\u0007q\n)!C\u0002\u0002\bu\u00121!\u00118z\u0011\u001d\tY\u0001\u0004a\u0001\u0003\u0007\t\u0011\u0002^5nKN$\u0018-\u001c9\t\u000f\u0005=A\u00021\u0001\u0002\u0004\u00051am\u001c:nCR\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005U\u0011\u0011EA\u0016!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000eG\u000591m\u001c3fO\u0016t\u0017\u0002BA\u0010\u00033\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003Gi\u0001\u0019AA\u0013\u0003\r\u0019G\u000f\u001f\t\u0005\u0003/\t9#\u0003\u0003\u0002*\u0005e!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003[i\u0001\u0019AA\u000b\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!U\u0001\u0005G>\u0004\u0018\u0010F\u0004`\u0003o\tI$a\u000f\t\u000f\u0011{\u0001\u0013!a\u0001\r\"9!j\u0004I\u0001\u0002\u00041\u0005b\u0002'\u0010!\u0003\u0005\rAT\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tEK\u0002G\u0003\u0007Z#!!\u0012\u0011\t\u0005\u001d\u0013\u0011K\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001fj\u0014AC1o]>$\u0018\r^5p]&!\u00111KA%\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a\u0017+\u00079\u000b\u0019%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003C\u0002B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'\u0001\u0003mC:<'BAA6\u0003\u0011Q\u0017M^1\n\u0007i\u000b)'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002tA\u0019A(!\u001e\n\u0007\u0005]THA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0004\u0005u\u0004\"CA@+\u0005\u0005\t\u0019AA:\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0011\t\u0007\u0003\u000f\u000bi)a\u0001\u000e\u0005\u0005%%bAAF{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0015\u0011\u0012\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0016\u0006m\u0005c\u0001\u001f\u0002\u0018&\u0019\u0011\u0011T\u001f\u0003\u000f\t{w\u000e\\3b]\"I\u0011qP\f\u0002\u0002\u0003\u0007\u00111A\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U\u0015\u0011\u0015\u0005\n\u0003\u007fB\u0012\u0011!a\u0001\u0003\u0007A3\u0003AAS\u0003W\u000bi+!-\u00024\u0006]\u0016\u0011XA_\u0003\u007f\u00032AMAT\u0013\r\tIk\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty+\u0001;`\rVs5i\u0018\u0015uS6,7\u000f^1na2\u0002c-\u001c;*A5\u00023i\u001c8wKJ$8\u000f\t1uS6,7\u000f^1na\u0002\u0004Co\u001c\u0011bAY\fG.^3!_\u001a\u00043\u000f\u001e:j]\u001e\u0004\u0013N\u001c\u0011uQ\u0016\u0004cm\u001c:nCR\u00043\u000f]3dS\u001aLW\r\u001a\u0011cs\u0002\"\b.\u001a\u0011eCR,\u0007EZ8s[\u0006$\b\u0005\u00194ni\u0002t\u0013!C1sOVlWM\u001c;tC\t\t),AAq\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002C/[7fgR\fW\u000e\u001d\u0011.A\u0005\u0003C-\u0019;f_QLW.Z:uC6\u0004\be\u001c:!gR\u0014\u0018N\\4!i>\u0004#-\u001a\u0011d_:4XM\u001d;fI\u0002\"x\u000e\t;iK\u0002:\u0017N^3oA\u0019|'/\\1u])\u0001\u0003\u0005\t\u0011!A)\u0002c-\u001c;![\u0001\"\u0015\r^30i&lW\r\t4pe6\fG\u000f\t9biR,'O\u001c\u0011u_\u00022w\u000e\u001c7po:\u00023+Z3!A*\fg/\u0019\u0018uKb$hfU5na2,G)\u0019;f\r>\u0014X.\u0019;aA\u0019|'\u000f\t<bY&$\u0007\u0005Z1uK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\ng\u000e\u001a\u0011uS6,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014hn\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003w\u000bqI\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'\f\u00195[ABt\u0005\f\u0011(s\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0003\fQ!\r\u00186]A\nq\u0002R1uK\u001a{'/\\1u\u00072\f7o\u001d\t\u0003ei\u0019BAGAe\u0003BA\u00111ZAi\r\u001asu,\u0004\u0002\u0002N*\u0019\u0011qZ\u001f\u0002\u000fI,h\u000e^5nK&!\u00111[Ag\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003\u000b\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003C\nQ!\u00199qYf$raXAp\u0003C\f\u0019\u000fC\u0003E;\u0001\u0007a\tC\u0003K;\u0001\u0007a\tC\u0004M;A\u0005\t\u0019\u0001(\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002l\u0006M\b\u0003\u0002\u001fP\u0003[\u0004b\u0001PAx\r\u001as\u0015bAAy{\t1A+\u001e9mKNB\u0001\"!> \u0003\u0003\u0005\raX\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u0006sK\u0006$'+Z:pYZ,GCAA\u007f!\u0011\t\u0019'a@\n\t\t\u0005\u0011Q\r\u0002\u0007\u001f\nTWm\u0019;")
public class DateFormatClass
extends BinaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return DateFormatClass$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(DateFormatClass dateFormatClass) {
        return DateFormatClass$.MODULE$.unapply(dateFormatClass);
    }

    public static Option<String> apply$default$3() {
        return DateFormatClass$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, DateFormatClass> tupled() {
        return DateFormatClass$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, DateFormatClass>>> curried() {
        return DateFormatClass$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return !this.bitmap$trans$0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object timestamp, Object format) {
        DateFormat df = DateTimeUtils$.MODULE$.newDateFormat(format.toString(), this.timeZone());
        return UTF8String.fromString((String)df.format(new Date(BoxesRunTime.unboxToLong((Object)timestamp) / 1000L)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, format) -> new StringBuilder(99).append("UTF8String.fromString(").append(dtu).append(".newDateFormat(").append((String)format).append(".toString(), ").append(tz).append(")\n          .format(new java.util.Date(").append((String)timestamp).append(" / 1000)))").toString());
    }

    @Override
    public String prettyName() {
        return "date_format";
    }

    public DateFormatClass copy(Expression left, Expression right, Option<String> timeZoneId) {
        return new DateFormatClass(left, right, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "DateFormatClass";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.left();
                break;
            }
            case 1: {
                option = this.right();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateFormatClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateFormatClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateFormatClass dateFormatClass = (DateFormatClass)x$1;
        Expression expression = this.left();
        Expression expression2 = dateFormatClass.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = dateFormatClass.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = dateFormatClass.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!dateFormatClass.canEqual(this)) return false;
        return true;
    }

    public DateFormatClass(Expression left, Expression right, Option<String> timeZoneId) {
        this.left = left;
        this.right = right;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public DateFormatClass(Expression left, Expression right) {
        this(left, right, (Option<String>)None$.MODULE$);
    }
}

