/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, search[, replace]) - Replaces all occurrences of `search` with `replace`.", arguments="\n    Arguments:\n      * str - a string expression\n      * search - a string expression. If `search` is not found in `str`, `str` is returned unchanged.\n      * replace - a string expression. If `replace` is not specified or is an empty string, nothing replaces\n          the string that is removed from `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ABCabc', 'abc', 'DEF');\n       ABCDEF\n  ", since="2.3.0")
@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011!9\u0005A!f\u0001\n\u0003\u0001\u0005\u0002\u0003%\u0001\u0005#\u0005\u000b\u0011B!\t\u000b%\u0003A\u0011\u0001&\t\u000b%\u0003A\u0011A(\t\u000bI\u0003A\u0011I*\t\u000bu\u0003A\u0011\t0\t\u000b1\u0004A\u0011I7\t\u000bQ\u0004A\u0011I;\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u00111\u0002\u0001\u0005B\u00055\u0001\"CA\u0010\u0001\u0005\u0005I\u0011AA\u0011\u0011%\tI\u0003AI\u0001\n\u0003\tY\u0003C\u0005\u0002B\u0001\t\n\u0011\"\u0001\u0002,!I\u00111\t\u0001\u0012\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003\u000b\u0002\u0011\u0011!C!\u0003\u000fB\u0011\"a\u0016\u0001\u0003\u0003%\t!!\u0017\t\u0013\u0005\u0005\u0004!!A\u0005\u0002\u0005\r\u0004\"CA5\u0001\u0005\u0005I\u0011IA6\u0011%\tI\bAA\u0001\n\u0003\tY\bC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0011\u0002\b\u001eI\u00111V\u0011\u0002\u0002#\u0005\u0011Q\u0016\u0004\tA\u0005\n\t\u0011#\u0001\u00020\"1\u0011J\u0007C\u0001\u0003{C\u0011\"a0\u001b\u0003\u0003%)%!1\t\u0013\u0005\r'$!A\u0005\u0002\u0006\u0015\u0007\"CAg5\u0005\u0005I\u0011QAh\u0011%\t\tOGA\u0001\n\u0013\t\u0019OA\u0007TiJLgn\u001a*fa2\f7-\u001a\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M)\u0001aL\u001a7yA\u0011\u0001'M\u0007\u0002C%\u0011!'\t\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00195\u0013\t)\u0014E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u001d\u0001&o\u001c3vGR\u0004\"aN\u001f\n\u0005yB$\u0001D*fe&\fG.\u001b>bE2,\u0017aB:sG\u0016C\bO]\u000b\u0002\u0003B\u0011\u0001GQ\u0005\u0003\u0007\u0006\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003!\u0019(oY#yaJ\u0004\u0013AC:fCJ\u001c\u0007.\u0012=qe\u0006Y1/Z1sG\",\u0005\u0010\u001d:!\u0003-\u0011X\r\u001d7bG\u0016,\u0005\u0010\u001d:\u0002\u0019I,\u0007\u000f\\1dK\u0016C\bO\u001d\u0011\u0002\rqJg.\u001b;?)\u0011YE*\u0014(\u0011\u0005A\u0002\u0001\"B \b\u0001\u0004\t\u0005\"B#\b\u0001\u0004\t\u0005\"B$\b\u0001\u0004\tEcA&Q#\")q\b\u0003a\u0001\u0003\")Q\t\u0003a\u0001\u0003\u0006aa.\u001e7m'\u00064W-\u0012<bYR!AkV-\\!\t9T+\u0003\u0002Wq\t\u0019\u0011I\\=\t\u000baK\u0001\u0019\u0001+\u0002\u000fM\u00148-\u0012<bY\")!,\u0003a\u0001)\u0006Q1/Z1sG\",e/\u00197\t\u000bqK\u0001\u0019\u0001+\u0002\u0017I,\u0007\u000f\\1dK\u00163\u0018\r\\\u0001\nI><UM\\\"pI\u0016$2aX3k!\t\u00017-D\u0001b\u0015\t\u0011\u0017%A\u0004d_\u0012,w-\u001a8\n\u0005\u0011\f'\u0001C#yaJ\u001cu\u000eZ3\t\u000b\u0019T\u0001\u0019A4\u0002\u0007\r$\b\u0010\u0005\u0002aQ&\u0011\u0011.\u0019\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015Y'\u00021\u0001`\u0003\t)g/\u0001\u0005eCR\fG+\u001f9f+\u0005q\u0007CA8s\u001b\u0005\u0001(BA9&\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\bO\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002mB\u0019qo 8\u000f\u0005alhBA=}\u001b\u0005Q(BA>.\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u0002\u007fq\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0001\u0003\u0007\u00111aU3r\u0015\tq\b(\u0001\u0005dQ&dGM]3o+\t\tI\u0001E\u0002x\u007f\u0006\u000b!\u0002\u001d:fiRLh*Y7f+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005ea\u0002BA\n\u0003+\u0001\"!\u001f\u001d\n\u0007\u0005]\u0001(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\tiB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/A\u0014\u0001B2paf$raSA\u0012\u0003K\t9\u0003C\u0004@\u001fA\u0005\t\u0019A!\t\u000f\u0015{\u0001\u0013!a\u0001\u0003\"9qi\u0004I\u0001\u0002\u0004\t\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003[Q3!QA\u0018W\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001eq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0012Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\n\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0013\u0001\u00026bm\u0006LA!a\u0007\u0002N\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\f\t\u0004o\u0005u\u0013bAA0q\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019A+!\u001a\t\u0013\u0005\u001dT#!AA\u0002\u0005m\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002nA)\u0011qNA;)6\u0011\u0011\u0011\u000f\u0006\u0004\u0003gB\u0014AC2pY2,7\r^5p]&!\u0011qOA9\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u\u00141\u0011\t\u0004o\u0005}\u0014bAAAq\t9!i\\8mK\u0006t\u0007\u0002CA4/\u0005\u0005\t\u0019\u0001+\u0002\r\u0015\fX/\u00197t)\u0011\ti(!#\t\u0011\u0005\u001d\u0004$!AA\u0002QC3\u0003AAG\u0003'\u000b)*!'\u0002\u001c\u0006}\u0015\u0011UAS\u0003O\u00032\u0001MAH\u0013\r\t\t*\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9*A+`\rVs5i\u0018\u0015tiJd\u0003e]3be\u000eD7\f\f\u0011sKBd\u0017mY3^S\u0001j\u0003EU3qY\u0006\u001cWm\u001d\u0011bY2\u0004snY2veJ,gnY3tA=4\u0007\u0005Y:fCJ\u001c\u0007\u000e\u0019\u0011xSRD\u0007\u0005\u0019:fa2\f7-\u001a1/\u0003%\t'oZ;nK:$8/\t\u0002\u0002\u001e\u0006\u0011\tH\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tK\u0006\u00148\r\u001b\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/A%3\u0007\u0005Y:fCJ\u001c\u0007\u000e\u0019\u0011jg\u0002rw\u000e\u001e\u0011g_VtG\rI5oA\u0001\u001cHO\u001d1-A\u0001\u001cHO\u001d1!SN\u0004#/\u001a;ve:,G\rI;oG\"\fgnZ3e])\u0001\u0003\u0005\t\u0011!A)\u0002#/\u001a9mC\u000e,\u0007%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\f\u0011JM\u0002\u0002'/\u001a9mC\u000e,\u0007\rI5tA9|G\u000fI:qK\u000eLg-[3eA=\u0014\b%[:!C:\u0004S-\u001c9us\u0002\u001aHO]5oO2\u0002cn\u001c;iS:<\u0007E]3qY\u0006\u001cWm\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\b.\u001a\u0011tiJLgn\u001a\u0011uQ\u0006$\b%[:!e\u0016lwN^3eA\u0019\u0014x.\u001c\u0011agR\u0014\bM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002$\u0006q%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014B\u0005\u000e\u000b'mY\u0014-A\u001d\n'mY\u0014-A\u001d\"UIR\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n%i\u0011#F\r*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002*\u0006)!GL\u001a/a\u0005i1\u000b\u001e:j]\u001e\u0014V\r\u001d7bG\u0016\u0004\"\u0001\r\u000e\u0014\ti\t\t\f\u0010\t\t\u0003g\u000bI,Q!B\u00176\u0011\u0011Q\u0017\u0006\u0004\u0003oC\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003w\u000b)LA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!!,\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0013\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f-\u000b9-!3\u0002L\")q(\ba\u0001\u0003\")Q)\ba\u0001\u0003\")q)\ba\u0001\u0003\u00069QO\\1qa2LH\u0003BAi\u0003;\u0004RaNAj\u0003/L1!!69\u0005\u0019y\u0005\u000f^5p]B1q'!7B\u0003\u0006K1!a79\u0005\u0019!V\u000f\u001d7fg!A\u0011q\u001c\u0010\u0002\u0002\u0003\u00071*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u001d\t\u0005\u0003\u0017\n9/\u0003\u0003\u0002j\u00065#AB(cU\u0016\u001cG\u000f")
public class StringReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression srcExpr;
    private final Expression searchExpr;
    private final Expression replaceExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringReplace stringReplace) {
        return StringReplace$.MODULE$.unapply(stringReplace);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringReplace> tupled() {
        return StringReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringReplace>>> curried() {
        return StringReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcExpr() {
        return this.srcExpr;
    }

    public Expression searchExpr() {
        return this.searchExpr;
    }

    public Expression replaceExpr() {
        return this.replaceExpr;
    }

    @Override
    public Object nullSafeEval(Object srcEval, Object searchEval, Object replaceEval) {
        return ((UTF8String)srcEval).replace((UTF8String)searchEval, (UTF8String)replaceEval);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(src, search, replace) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)src).append(".replace(").append((String)search).append(", ").append((String)replace).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.srcExpr();
        Expression expression2 = this.searchExpr();
        Expression expression3 = this.replaceExpr();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "replace";
    }

    public StringReplace copy(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        return new StringReplace(srcExpr, searchExpr, replaceExpr);
    }

    public Expression copy$default$1() {
        return this.srcExpr();
    }

    public Expression copy$default$2() {
        return this.searchExpr();
    }

    public Expression copy$default$3() {
        return this.replaceExpr();
    }

    @Override
    public String productPrefix() {
        return "StringReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.srcExpr();
                break;
            }
            case 1: {
                expression = this.searchExpr();
                break;
            }
            case 2: {
                expression = this.replaceExpr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringReplace stringReplace = (StringReplace)x$1;
        Expression expression = this.srcExpr();
        Expression expression2 = stringReplace.srcExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.searchExpr();
        Expression expression4 = stringReplace.searchExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replaceExpr();
        Expression expression6 = stringReplace.replaceExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringReplace.canEqual(this)) return false;
        return true;
    }

    public StringReplace(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        this.srcExpr = srcExpr;
        this.searchExpr = searchExpr;
        this.replaceExpr = replaceExpr;
        ExpectsInputTypes.$init$(this);
    }

    public StringReplace(Expression srcExpr, Expression searchExpr) {
        this(srcExpr, searchExpr, Literal$.MODULE$.apply(""));
    }
}

