/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       map(\"a\":\"1\",\"b\":\"2\",\"c\":\"3\")\n      > SELECT _FUNC_('a');\n       map(\"a\":null)\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0011#\u0001>B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005q\t\u0003\u0005N\u0001\tE\t\u0015!\u0003I\u0011!q\u0005A!f\u0001\n\u00039\u0005\u0002C(\u0001\u0005#\u0005\u000b\u0011\u0002%\t\u000bA\u0003A\u0011A)\t\u000bA\u0003A\u0011\u0001,\t\u000bA\u0003A\u0011\u0001.\t\u000bq\u0003A\u0011I/\t\u000b)\u0004A\u0011I6\t\u000bM\u0004A\u0011\t;\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011q\u0003\u0001\u0005B\u0005e\u0001\"CA\u0016\u0001\u0005\u0005I\u0011AA\u0017\u0011%\t)\u0004AI\u0001\n\u0003\t9\u0004C\u0005\u0002N\u0001\t\n\u0011\"\u0001\u00028!I\u0011q\n\u0001\u0012\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'B\u0011\"a\u0019\u0001\u0003\u0003%\t!!\u001a\t\u0013\u00055\u0004!!A\u0005\u0002\u0005=\u0004\"CA;\u0001\u0005\u0005I\u0011IA<\u0011%\t)\tAA\u0001\n\u0003\t9\tC\u0005\u0002\u0012\u0002\t\t\u0011\"\u0011\u0002\u0014\u001eI\u00111\u0016\u0012\u0002\u0002#\u0005\u0011Q\u0016\u0004\tC\t\n\t\u0011#\u0001\u00020\"1\u0001k\u0007C\u0001\u0003{C\u0011\"a0\u001c\u0003\u0003%)%!1\t\u0013\u0005\r7$!A\u0005\u0002\u0006\u0015\u0007\"CAg7\u0005\u0005I\u0011QAh\u0011%\t\toGA\u0001\n\u0013\t\u0019OA\u0006TiJLgn\u001a+p\u001b\u0006\u0004(BA\u0012%\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00152\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dB\u0013aA:rY*\u0011\u0011FK\u0001\u0006gB\f'o\u001b\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001DGO\u001fD!\t\t$'D\u0001#\u0013\t\u0019$EA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0012\u0002\u000f\r|G-Z4f]&\u0011\u0011H\u000e\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011\u0011gO\u0005\u0003y\t\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010#\n\u0005\u0015{$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u0002;fqR,\u0012\u0001\u0013\t\u0003c%K!A\u0013\u0012\u0003\u0015\u0015C\bO]3tg&|g.A\u0003uKb$\b%A\u0005qC&\u0014H)\u001a7j[\u0006Q\u0001/Y5s\t\u0016d\u0017.\u001c\u0011\u0002\u001b-,\u0017PV1mk\u0016$U\r\\5n\u00039YW-\u001f,bYV,G)\u001a7j[\u0002\na\u0001P5oSRtD\u0003\u0002*T)V\u0003\"!\r\u0001\t\u000b\u0019;\u0001\u0019\u0001%\t\u000b1;\u0001\u0019\u0001%\t\u000b9;\u0001\u0019\u0001%\u0015\u0007I;\u0016\fC\u0003Y\u0011\u0001\u0007\u0001*A\u0003dQ&dG\rC\u0003M\u0011\u0001\u0007\u0001\n\u0006\u0002S7\")\u0001,\u0003a\u0001\u0011\u0006A1\r[5mIJ,g.F\u0001_!\ryv\r\u0013\b\u0003A\u0016t!!\u00193\u000e\u0003\tT!a\u0019\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0015B\u00014@\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001[5\u0003\u0007M+\u0017O\u0003\u0002g\u007f\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u00031\u00042aX4n!\tq\u0017/D\u0001p\u0015\t\u0001h%A\u0003usB,7/\u0003\u0002s_\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\tQ\u000f\u0005\u0002om&\u0011qo\u001c\u0002\t\t\u0006$\u0018\rV=qK\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t!\u0010\u0005\u0002|}6\tAP\u0003\u0002~I\u0005A\u0011M\\1msNL7/\u0003\u0002\u0000y\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0005\u0002\u0006\u0005-\u0011qBA\n!\rq\u0014qA\u0005\u0004\u0003\u0013y$aA!os\"9\u0011Q\u0002\bA\u0002\u0005\u0015\u0011aC5oaV$8\u000b\u001e:j]\u001eDq!!\u0005\u000f\u0001\u0004\t)!A\btiJLgn\u001a#fY&l\u0017\u000e^3s\u0011\u001d\t)B\u0004a\u0001\u0003\u000b\t\u0011c[3z-\u0006dW/\u001a#fY&l\u0017\u000e^3s\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u00037\u0001B!!\b\u0002&9!\u0011qDA\u0011!\t\tw(C\u0002\u0002$}\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0014\u0003S\u0011aa\u0015;sS:<'bAA\u0012\u007f\u0005!1m\u001c9z)\u001d\u0011\u0016qFA\u0019\u0003gAqA\u0012\t\u0011\u0002\u0003\u0007\u0001\nC\u0004M!A\u0005\t\u0019\u0001%\t\u000f9\u0003\u0002\u0013!a\u0001\u0011\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001dU\rA\u00151H\u0016\u0003\u0003{\u0001B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0005v]\u000eDWmY6fI*\u0019\u0011qI \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002L\u0005\u0005#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0005Y\u0006twM\u0003\u0002\u0002`\u0005!!.\u0019<b\u0013\u0011\t9#!\u0017\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0004c\u0001 \u0002j%\u0019\u00111N \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u0011\u0011\u000f\u0005\n\u0003g2\u0012\u0011!a\u0001\u0003O\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA=!\u0019\tY(!!\u0002\u00065\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fz\u0014AC2pY2,7\r^5p]&!\u00111QA?\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005%\u0015q\u0012\t\u0004}\u0005-\u0015bAAG\u007f\t9!i\\8mK\u0006t\u0007\"CA:1\u0005\u0005\t\u0019AA\u0003\u0003\u0019)\u0017/^1mgR!\u0011\u0011RAK\u0011%\t\u0019(GA\u0001\u0002\u0004\t)\u0001K\u0006\u0001\u00033\u000by*!)\u0002&\u0006\u001d\u0006cA\u0019\u0002\u001c&\u0019\u0011Q\u0014\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111U\u0001\u0002\u0006~3UKT\"`QQ,\u0007\u0010^.-AA\f\u0017N\u001d#fY&l7\f\f\u0011lKf4\u0016\r\\;f\t\u0016d\u0017.\\/^S\u0001j\u0003e\u0011:fCR,7\u000fI1![\u0006\u0004\b%\u00194uKJ\u00043\u000f\u001d7jiRLgn\u001a\u0011uQ\u0016\u0004C/\u001a=uA%tGo\u001c\u0011lKf|c/\u00197vK\u0002\u0002\u0018-\u001b:tAU\u001c\u0018N\\4!I\u0016d\u0017.\\5uKJ\u001ch\u0006\t#fM\u0006,H\u000e\u001e\u0011eK2LW.\u001b;feN\u0004\u0013M]3!O1:\u0003EZ8sA\u0001\u0004\u0018-\u001b:EK2LW\u000e\u0019\u0011b]\u0012\u0004sEO\u0014!M>\u0014\b\u0005Y6fsZ\u000bG.^3EK2LW\u000e\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!+\u0002\u0003[Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ1;c1\u0012'H\r\u0017duM:C\u0006I\u0014-O1\u0002sEO\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001j\u0017\r\u001d\u0015#C\nR$%\r\u0012-E\t\u0014#H\t\u001a#Y\t\u001a'E\u000f\u00124E%R\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ1(SmR\u0001\u0005\t\u0011!A\u0001\u0002S.\u00199)E\u0005\u0014#H\\;mY&R\u0001\u0005I\u0001\f'R\u0014\u0018N\\4U_6\u000b\u0007\u000f\u0005\u000227M!1$!-D!!\t\u0019,!/I\u0011\"\u0013VBAA[\u0015\r\t9lP\u0001\beVtG/[7f\u0013\u0011\tY,!.\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002.\u0006AAo\\*ue&tw\r\u0006\u0002\u0002V\u0005)\u0011\r\u001d9msR9!+a2\u0002J\u0006-\u0007\"\u0002$\u001f\u0001\u0004A\u0005\"\u0002'\u001f\u0001\u0004A\u0005\"\u0002(\u001f\u0001\u0004A\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003#\fi\u000eE\u0003?\u0003'\f9.C\u0002\u0002V~\u0012aa\u00149uS>t\u0007C\u0002 \u0002Z\"C\u0005*C\u0002\u0002\\~\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAp?\u0005\u0005\t\u0019\u0001*\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAs!\u0011\t9&a:\n\t\u0005%\u0018\u0011\f\u0002\u0007\u001f\nTWm\u0019;")
public class StringToMap
extends TernaryExpression
implements CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap stringToMap) {
        return StringToMap$.MODULE$.unapply(stringToMap);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.text(), this.pairDelim(), this.keyValueDelim()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(StringType$.MODULE$, StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.pairDelim(), this.keyValueDelim()}))).exists((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)StringToMap.$anonfun$checkInputDataTypes$7(x$29))) ? new TypeCheckResult.TypeCheckFailure(new java.lang.StringBuilder(31).append(this.prettyName()).append("'s delimiters must be foldable.").toString()) : ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        Iterator<Tuple2<UTF8String, UTF8String>> iterator = new Iterator<Tuple2<UTF8String, UTF8String>>(null, keyValueDelimiter, keyValues){
            private int index;
            private final UTF8String keyValueDelimiterUTF8String;
            private final UTF8String[] keyValues$1;

            public Iterator<Tuple2<UTF8String, UTF8String>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<UTF8String, UTF8String>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<UTF8String, UTF8String>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> filter(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<UTF8String, UTF8String>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> withFilter(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> filterNot(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<UTF8String, UTF8String>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> takeWhile(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<UTF8String, UTF8String>>, Iterator<Tuple2<UTF8String, UTF8String>>> partition(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<UTF8String, UTF8String>>, Iterator<Tuple2<UTF8String, UTF8String>>> span(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> dropWhile(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<UTF8String, UTF8String>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<UTF8String, UTF8String>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<UTF8String, UTF8String>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<UTF8String, UTF8String>> find(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<UTF8String, UTF8String>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Tuple2<UTF8String, UTF8String>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<UTF8String, UTF8String>>, Iterator<Tuple2<UTF8String, UTF8String>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Tuple2<UTF8String, UTF8String>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Tuple2<UTF8String, UTF8String>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Tuple2<UTF8String, UTF8String>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<UTF8String, UTF8String>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<UTF8String, UTF8String>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<UTF8String, UTF8String>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Tuple2<UTF8String, UTF8String>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Tuple2<UTF8String, UTF8String>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<UTF8String, UTF8String>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Tuple2<UTF8String, UTF8String>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<UTF8String, UTF8String>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Tuple2<UTF8String, UTF8String>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public int index() {
                return this.index;
            }

            public void index_$eq(int x$1) {
                this.index = x$1;
            }

            public UTF8String keyValueDelimiterUTF8String() {
                return this.keyValueDelimiterUTF8String;
            }

            public boolean hasNext() {
                return this.keyValues$1.length > this.index();
            }

            public Tuple2<UTF8String, UTF8String> next() {
                UTF8String[] keyValueArray = this.keyValues$1[this.index()].split(this.keyValueDelimiterUTF8String(), 2);
                this.index_$eq(this.index() + 1);
                return new Tuple2((Object)keyValueArray[0], keyValueArray.length < 2 ? null : keyValueArray[1]);
            }
            {
                this.keyValues$1 = keyValues$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.index = 0;
                this.keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter$1;
            }
        };
        return ArrayBasedMapData$.MODULE$.apply(iterator, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyValues)).size(), (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x), (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x));
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.text();
                break;
            }
            case 1: {
                expression = this.pairDelim();
                break;
            }
            case 2: {
                expression = this.keyValueDelim();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$7(Expression x$29) {
        return !x$29.foldable();
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

