/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.fs.Path;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.StringOps;
import scala.collection.parallel.ParSeq;
import scala.collection.parallel.ParSeq$;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.ThreadPoolTaskSupport;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class FileBasedWriteAheadLog$ {
    public static final FileBasedWriteAheadLog$ MODULE$;
    private final Regex logFileRegex;

    static {
        new FileBasedWriteAheadLog$();
    }

    public Regex logFileRegex() {
        return this.logFileRegex;
    }

    public String timeToLogFile(long startTime, long stopTime) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startTime), BoxesRunTime.boxToLong((long)stopTime)}));
    }

    public Option<String> getCallerName() {
        String[] stackTraceClasses = (String[])Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StackTraceElement x$7) {
                return x$7.getClassName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return Predef$.MODULE$.refArrayOps((Object[])stackTraceClasses).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$8) {
                return !x$8.contains("WriteAheadLog");
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(String x$9) {
                return Predef$.MODULE$.refArrayOps((Object[])x$9.split("\\.")).lastOption();
            }
        });
    }

    public Seq<FileBasedWriteAheadLog.LogInfo> logFilesTologInfo(Seq<Path> files) {
        return (Seq)((SeqLike)files.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<FileBasedWriteAheadLog.LogInfo> apply(Path file) {
                Option option;
                block4: {
                    Iterable iterable;
                    block3: {
                        block2: {
                            option = FileBasedWriteAheadLog$.MODULE$.logFileRegex().findFirstIn((CharSequence)file.getName());
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Object object = some.x();
                            Option option2 = FileBasedWriteAheadLog$.MODULE$.logFileRegex().unapplySeq(object);
                            if (option2.isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(2) != 0) break block2;
                            String startTimeStr = (String)((LinearSeqOptimized)option2.get()).apply(0);
                            String stopTimeStr = (String)((LinearSeqOptimized)option2.get()).apply(1);
                            long startTime = new StringOps(Predef$.MODULE$.augmentString(startTimeStr)).toLong();
                            long stopTime = new StringOps(Predef$.MODULE$.augmentString(stopTimeStr)).toLong();
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new FileBasedWriteAheadLog.LogInfo(startTime, stopTime, file.toString())));
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option3 = option;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }
                throw new MatchError((Object)option);
            }
        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(FileBasedWriteAheadLog.LogInfo x$10) {
                return x$10.startTime();
            }
        }, (Ordering)Ordering.Long$.MODULE$);
    }

    public <I, O> Iterator<O> seqToParIterator(ThreadPoolExecutor tpool, Seq<I> source, Function1<I, Iterator<O>> handler) {
        ThreadPoolTaskSupport taskSupport = new ThreadPoolTaskSupport(tpool);
        int groupSize = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(tpool.getMaximumPoolSize()), 8);
        return TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)source.grouped(groupSize).flatMap((Function1)new Serializable(handler, taskSupport){
            public static final long serialVersionUID = 0L;
            private final Function1 handler$1;
            private final ThreadPoolTaskSupport taskSupport$1;

            public final ParSeq<Iterator<O>> apply(Seq<I> group) {
                ParSeq parallelCollection = (ParSeq)group.par();
                parallelCollection.tasksupport_$eq((TaskSupport)this.taskSupport$1);
                return (ParSeq)parallelCollection.map(this.handler$1, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom());
            }
            {
                this.handler$1 = handler$1;
                this.taskSupport$1 = taskSupport$1;
            }
        }), (Function1)Predef$.MODULE$.conforms()).flatten();
    }

    private FileBasedWriteAheadLog$() {
        MODULE$ = this;
        this.logFileRegex = new StringOps(Predef$.MODULE$.augmentString("log-(\\d+)-(\\d+)")).r();
    }
}

