/*
 * Decompiled with CFR 0.152.
 */
package grizzled.net;

import grizzled.file.util$;
import grizzled.io.Implicits$;
import grizzled.net.URL;
import grizzled.net.URL$;
import grizzled.util.package$Implicits$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class URLUtil$ {
    public static URLUtil$ MODULE$;
    private Regex ExtRegexp;
    private volatile boolean bitmap$0;

    static {
        new URLUtil$();
    }

    private Regex ExtRegexp$lzycompute() {
        URLUtil$ uRLUtil$ = this;
        synchronized (uRLUtil$) {
            if (!this.bitmap$0) {
                this.ExtRegexp = new StringOps(Predef$.MODULE$.augmentString("^(.*)(\\.[^.]+)$")).r();
                this.bitmap$0 = true;
            }
        }
        return this.ExtRegexp;
    }

    private Regex ExtRegexp() {
        return !this.bitmap$0 ? this.ExtRegexp$lzycompute() : this.ExtRegexp;
    }

    public Future<File> download(String url, ExecutionContext ctx) {
        return package$Implicits$.MODULE$.RichTry(URL$.MODULE$.apply(url)).toFuture().flatMap((Function1 & Serializable & scala.Serializable)u -> this.download((URL)u, ctx).map((Function1 & Serializable & scala.Serializable)res -> res, ctx), ctx);
    }

    public Future<File> download(java.net.URL url, ExecutionContext ctx) {
        return this.download(URL$.MODULE$.apply(url), ctx);
    }

    public Future<File> download(URL url, ExecutionContext ctx) {
        return package$Implicits$.MODULE$.RichTry(this.getOutputFile(url)).toFuture().flatMap((Function1 & Serializable & scala.Serializable)output -> this.download(url, output.getPath(), ctx).map((Function1 & Serializable & scala.Serializable)_ -> output, ctx), ctx);
    }

    public Future<String> download(String url, String pathOut, ExecutionContext ctx) {
        return package$Implicits$.MODULE$.RichTry(URL$.MODULE$.apply(url)).toFuture().flatMap((Function1 & Serializable & scala.Serializable)u -> this.download((URL)u, new File(pathOut), ctx).map((Function1 & Serializable & scala.Serializable)f -> f.getPath(), ctx), ctx);
    }

    public Future<String> download(java.net.URL url, String pathOut, ExecutionContext ctx) {
        return this.download(URL$.MODULE$.apply(url), new File(pathOut), ctx).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath(), ctx);
    }

    public Future<String> download(URL url, String pathOut, ExecutionContext ctx) {
        return this.download(url, new File(pathOut), ctx).map((Function1 & Serializable & scala.Serializable)f -> f.getPath(), ctx);
    }

    public Future<String> download(String url, File pathOut, ExecutionContext ctx) {
        return package$Implicits$.MODULE$.RichTry(URL$.MODULE$.apply(url)).toFuture().flatMap((Function1 & Serializable & scala.Serializable)u -> this.download((URL)u, pathOut, ctx).map((Function1 & Serializable & scala.Serializable)_ -> pathOut.getPath(), ctx), ctx);
    }

    public Future<File> download(URL url, File pathOut, ExecutionContext ctx) {
        return URLUtil$.validateAndGetParentDir$1(pathOut, pathOut).flatMap((Function1 & Serializable & scala.Serializable)parentDir -> URLUtil$.openInputAndOutput$1(url, pathOut, pathOut, ctx).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)URLUtil$.$anonfun$download$18(check$ifrefutable$1)), ctx).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputStream in = (InputStream)tuple2._1();
            OutputStream out = (OutputStream)tuple2._2();
            Future future = URLUtil$.doCopy$1(in, out, ctx).map((Function1 & Serializable & scala.Serializable)_ -> {
                out.close();
                in.close();
                return pathOut;
            }, ctx);
            return future;
        }, ctx), ctx);
    }

    public <T> Try<T> withDownloadedFile(String url, Duration timeout, Function1<File, T> block, ExecutionContext ctx) {
        return URL$.MODULE$.apply(url).flatMap((Function1 & Serializable & scala.Serializable)u -> this.withDownloadedFile((URL)u, timeout, block, ctx).map((Function1 & Serializable & scala.Serializable)res -> res));
    }

    public <T> Try<T> withDownloadedFile(java.net.URL url, Duration timeout, Function1<File, T> block, ExecutionContext ctx) {
        return this.withDownloadedFile(URL$.MODULE$.apply(url), timeout, block, ctx);
    }

    public <T> Try<T> withDownloadedFile(URL url, Duration timeout, Function1<File, T> block, ExecutionContext ctx) {
        Future fut = this.download(url, ctx).map((Function1 & Serializable & scala.Serializable)res -> block.apply(res), ctx);
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Await$.MODULE$.result((Awaitable)fut, timeout));
    }

    public Try<File> getOutputFile(URL url) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (File)url.path().map((Function1 & Serializable & scala.Serializable)pathStr -> {
            File file;
            String ext;
            String string = pathStr;
            Option option = this.ExtRegexp().unapplySeq((CharSequence)string);
            String string2 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0 ? (ext = (String)((LinearSeqOptimized)option.get()).apply(1)) : ".dat";
            String extension = string2;
            char c = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(pathStr)).last());
            switch (c) {
                case '/': {
                    file = File.createTempFile("urldownload", extension);
                    break;
                }
                default: {
                    file = new File(util$.MODULE$.joinPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{System.getProperty("java.io.tmpdir"), util$.MODULE$.basename((String)pathStr, util$.MODULE$.basename$default$2())})));
                    break;
                }
            }
            return file;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> File.createTempFile("urldownload", ".dat")));
    }

    private static final Future validateAndGetParentDir$1(File path, File pathOut$1) {
        File dir;
        return path.isDirectory() ? Future$.MODULE$.failed((Throwable)new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output file \"", "\" exists and is a directory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathOut$1})))) : (!(dir = grizzled.file.Implicits$.MODULE$.GrizzledFile(pathOut$1).dirname()).exists() && !dir.mkdirs() ? Future$.MODULE$.failed((Throwable)new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't create target directory '", "' or one of its parents."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir})))) : Future$.MODULE$.successful((Object)dir));
    }

    private static final Future openInputAndOutput$1(URL url, File path, File pathOut$1, ExecutionContext ctx$2) {
        return package$Implicits$.MODULE$.RichTry(url.openStream()).toFuture().flatMap((Function1 & Serializable & scala.Serializable)urlIn -> package$Implicits$.MODULE$.RichTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new BufferedInputStream((InputStream)urlIn))).toFuture().flatMap((Function1 & Serializable & scala.Serializable)in -> package$Implicits$.MODULE$.RichTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new BufferedOutputStream(new FileOutputStream(pathOut$1)))).toFuture().map((Function1 & Serializable & scala.Serializable)out -> new Tuple2(in, out), ctx$2), ctx$2), ctx$2);
    }

    private static final Future doCopy$1(InputStream in, OutputStream out, ExecutionContext ctx$2) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Implicits$.MODULE$.RichInputStream(in).copyTo(out), ctx$2);
    }

    public static final /* synthetic */ boolean $anonfun$download$18(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private URLUtil$() {
        MODULE$ = this;
    }
}

