/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.ordering.MajorMinorIncrementalFilter;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="use-latest-versions", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class UseLatestVersionsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates;

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            DependencyManagement dependencyManagement;
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel(this.getProject()).getDependencyManagement()) != null) {
                this.useLatestVersions(pom, dependencyManagement.getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useLatestVersions(pom, this.getProject().getDependencies());
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                Dependency dependency = new Dependency();
                dependency.setArtifactId(this.getProject().getParent().getArtifactId());
                dependency.setGroupId(this.getProject().getParent().getGroupId());
                dependency.setVersion(this.getProject().getParent().getVersion());
                dependency.setType("pom");
                ArrayList<Dependency> list = new ArrayList<Dependency>();
                list.add(dependency);
                this.useLatestVersions(pom, list);
            }
        }
        catch (IOException | ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void useLatestVersions(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        int segment = this.determineUnchangedSegment(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates);
        MajorMinorIncrementalFilter majorMinorIncfilter = new MajorMinorIncrementalFilter(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates);
        for (Dependency dep : dependencies) {
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            DefaultArtifactVersion selectedVersion = new DefaultArtifactVersion(version);
            this.getLog().debug((CharSequence)("Selected version:" + selectedVersion));
            this.getLog().debug((CharSequence)("Looking for newer versions of " + this.toString(dep)));
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            ArtifactVersion[] newerVersions = versions.getNewerVersions(version, segment, this.allowSnapshots);
            ArtifactVersion[] filteredVersions = majorMinorIncfilter.filter((ArtifactVersion)selectedVersion, newerVersions);
            if (filteredVersions.length <= 0) continue;
            String newVersion = filteredVersions[filteredVersions.length - 1].toString();
            if (this.getProject().getParent() != null) {
                Artifact parentArtifact = this.getProject().getParentArtifact();
                if (artifact.getId().equals(parentArtifact.getId()) && this.isProcessingParent() && PomHelper.setProjectParentVersion(pom, newVersion)) {
                    this.getLog().debug((CharSequence)("Made parent update from " + version + " to " + newVersion));
                    this.getChangeRecorder().recordUpdate("useLatestVersions", parentArtifact.getGroupId(), parentArtifact.getArtifactId(), version, newVersion);
                }
            }
            if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, newVersion, this.getProject().getModel())) continue;
            this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + newVersion));
            this.getChangeRecorder().recordUpdate("useLatestVersions", dep.getGroupId(), dep.getArtifactId(), version, newVersion);
        }
    }
}

