/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.cyclonedx.maven.BaseCycloneDxMojo;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makeBom", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresOnline=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class CycloneDxMojo
extends BaseCycloneDxMojo {
    @Parameter(property="analyzer", defaultValue="default")
    private String analyzer;
    @org.apache.maven.plugins.annotations.Component
    private PlexusContainer plexusContainer;
    protected ProjectDependencyAnalyzer dependencyAnalyzer;

    private ProjectDependencyAnalyzer getProjectDependencyAnalyzer() throws MojoExecutionException {
        if (this.dependencyAnalyzer == null) {
            try {
                this.dependencyAnalyzer = (ProjectDependencyAnalyzer)this.plexusContainer.lookup(ProjectDependencyAnalyzer.class, this.analyzer);
            }
            catch (ComponentLookupException cle) {
                throw new MojoExecutionException("Failed to instantiate ProjectDependencyAnalyser with role-hint " + this.analyzer, (Exception)((Object)cle));
            }
        }
        return this.dependencyAnalyzer;
    }

    protected ProjectDependencyAnalysis doProjectDependencyAnalysis(MavenProject mavenProject) throws MojoExecutionException {
        try {
            return this.getProjectDependencyAnalyzer().analyze(mavenProject);
        }
        catch (ProjectDependencyAnalyzerException pdae) {
            this.getLog().debug((CharSequence)("Could not analyze " + mavenProject.getId()), (Throwable)pdae);
            return null;
        }
    }

    @Override
    protected String extractComponentsAndDependencies(Set<String> topLevelComponents, Map<String, Component> components, Map<String, Dependency> dependencies) throws MojoExecutionException {
        this.getLog().info((CharSequence)"CycloneDX: Resolving Dependencies");
        Map<String, Dependency> projectDependencies = this.extractBOMDependencies(this.getProject());
        Component projectBomComponent = this.convert(this.getProject().getArtifact());
        components.put(projectBomComponent.getPurl(), projectBomComponent);
        topLevelComponents.add(projectBomComponent.getPurl());
        this.populateComponents(topLevelComponents, components, this.getProject().getArtifacts(), this.doProjectDependencyAnalysis(this.getProject()));
        projectDependencies.forEach(dependencies::putIfAbsent);
        return "makeBom";
    }
}

