/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jgit.junit.LocalDiskRepositoryTestCase;
import org.eclipse.jgit.junit.TestRepository;
import org.eclipse.jgit.junit.http.AccessEvent;
import org.eclipse.jgit.junit.http.AppServer;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.junit.Assert;

public abstract class HttpTestCase
extends LocalDiskRepositoryTestCase {
    protected static final String master = "refs/heads/master";
    protected AppServer server;

    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer();
    }

    public void tearDown() throws Exception {
        this.server.tearDown();
        super.tearDown();
    }

    protected AppServer createServer() {
        return new AppServer();
    }

    protected TestRepository<Repository> createTestRepository() throws IOException {
        return new TestRepository((Repository)this.createBareRepository());
    }

    protected URIish toURIish(String path) throws URISyntaxException {
        URI u = this.server.getURI().resolve(path);
        return new URIish(u.toString());
    }

    protected URIish toURIish(ServletContextHandler app, String name) throws URISyntaxException {
        String p = app.getContextPath();
        if (!p.endsWith("/") && !name.startsWith("/")) {
            p = p + "/";
        }
        p = p + name;
        return this.toURIish(p);
    }

    protected List<AccessEvent> getRequests() {
        return this.server.getRequests();
    }

    protected List<AccessEvent> getRequests(URIish base, String path) {
        return this.server.getRequests(base, path);
    }

    protected List<AccessEvent> getRequests(String path) {
        return this.server.getRequests(path);
    }

    protected static void fsck(Repository db, RevObject ... tips) throws Exception {
        TestRepository tr = new TestRepository(db);
        tr.fsck(tips);
    }

    protected static Set<RefSpec> mirror(String ... refs) {
        HashSet<RefSpec> r = new HashSet<RefSpec>();
        for (String name : refs) {
            RefSpec rs = new RefSpec(name);
            rs = rs.setDestination(name);
            rs = rs.setForceUpdate(true);
            r.add(rs);
        }
        return r;
    }

    protected static Collection<RemoteRefUpdate> push(TestRepository from, RevCommit q) throws IOException {
        Repository db = from.getRepository();
        String srcExpr = q.name();
        String dstName = master;
        boolean forceUpdate = true;
        String localName = null;
        ObjectId oldId = null;
        RemoteRefUpdate u = new RemoteRefUpdate(db, srcExpr, master, true, localName, oldId);
        return Collections.singleton(u);
    }

    public static String loose(URIish base, AnyObjectId id) {
        String objectName = id.name();
        String d = objectName.substring(0, 2);
        String f = objectName.substring(2);
        return HttpTestCase.join(base, "objects/" + d + "/" + f);
    }

    public static String join(URIish base, String path) {
        String dir;
        if (path.startsWith("/")) {
            Assert.fail((String)("Cannot join absolute path " + path + " to URIish " + base));
        }
        if (!(dir = base.getPath()).endsWith("/")) {
            dir = dir + "/";
        }
        return dir + path;
    }

    protected static String rewriteUrl(String url, String newProtocol, int newPort) {
        int schemeEnd;
        String newUrl = url;
        if (newProtocol != null && !newProtocol.isEmpty() && (schemeEnd = newUrl.indexOf("://")) >= 0) {
            newUrl = newProtocol + newUrl.substring(schemeEnd);
        }
        newUrl = newPort > 0 ? newUrl.replaceFirst(":\\d+/", ":" + newPort + "/") : newUrl.replaceFirst(":\\d+/", "/");
        return newUrl;
    }

    protected static URIish extendPath(URIish uri, String pathComponents) throws URISyntaxException {
        String raw = uri.toString();
        String newComponents = pathComponents;
        if (!newComponents.startsWith("/")) {
            newComponents = '/' + newComponents;
        }
        if (!newComponents.endsWith("/")) {
            newComponents = newComponents + '/';
        }
        int i = raw.lastIndexOf(47);
        raw = raw.substring(0, i) + newComponents + raw.substring(i + 1);
        return new URIish(raw);
    }
}

