/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.datafeed;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ChunkingConfig
implements ToXContentObject {
    public static final ParseField MODE_FIELD = new ParseField("mode", new String[0]);
    public static final ParseField TIME_SPAN_FIELD = new ParseField("time_span", new String[0]);
    public static final ConstructingObjectParser<ChunkingConfig, Void> PARSER = new ConstructingObjectParser("chunking_config", true, a -> new ChunkingConfig((Mode)((Object)((Object)a[0])), (TimeValue)a[1]));
    private final Mode mode;
    private final TimeValue timeSpan;

    ChunkingConfig(Mode mode, @Nullable TimeValue timeSpan) {
        this.mode = Objects.requireNonNull(mode, MODE_FIELD.getPreferredName());
        this.timeSpan = timeSpan;
    }

    @Nullable
    public TimeValue getTimeSpan() {
        return this.timeSpan;
    }

    Mode getMode() {
        return this.mode;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODE_FIELD.getPreferredName(), (Enum)this.mode);
        if (this.timeSpan != null) {
            builder.field(TIME_SPAN_FIELD.getPreferredName(), this.timeSpan.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.timeSpan});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkingConfig other = (ChunkingConfig)obj;
        return Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals(this.timeSpan, other.timeSpan);
    }

    public static ChunkingConfig newAuto() {
        return new ChunkingConfig(Mode.AUTO, null);
    }

    public static ChunkingConfig newOff() {
        return new ChunkingConfig(Mode.OFF, null);
    }

    public static ChunkingConfig newManual(TimeValue timeSpan) {
        return new ChunkingConfig(Mode.MANUAL, timeSpan);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Mode::fromString, MODE_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), text -> TimeValue.parseTimeValue((String)text, (String)TIME_SPAN_FIELD.getPreferredName()), TIME_SPAN_FIELD);
    }

    public static enum Mode {
        AUTO,
        MANUAL,
        OFF;


        public static Mode fromString(String value) {
            return Mode.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

