/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.flowable.common.engine.api.FlowableException;

public class IoUtil {
    public static byte[] readInputStream(InputStream inputStream, String inputStreamName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        try {
            int bytesRead = inputStream.read(buffer);
            while (bytesRead != -1) {
                outputStream.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
        catch (Exception e) {
            throw new FlowableException("couldn't read input stream " + inputStreamName, (Throwable)e);
        }
        return outputStream.toByteArray();
    }

    public static String readFileAsString(String filePath) {
        byte[] buffer = new byte[(int)IoUtil.getFile(filePath).length()];
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(IoUtil.getFile(filePath)));
            inputStream.read(buffer);
        }
        catch (Exception e) {
            try {
                throw new FlowableException("Couldn't read file " + filePath + ": " + e.getMessage());
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(inputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently(inputStream);
        return new String(buffer);
    }

    public static File getFile(String filePath) {
        URL url = IoUtil.class.getClassLoader().getResource(filePath);
        try {
            return new File(url.toURI());
        }
        catch (Exception e) {
            throw new FlowableException("Couldn't get file " + filePath + ": " + e.getMessage());
        }
    }

    public static void writeStringToFile(String content, String filePath) {
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(IoUtil.getFile(filePath)));
            outputStream.write(content.getBytes());
            outputStream.flush();
        }
        catch (Exception e) {
            try {
                throw new FlowableException("Couldn't write file " + filePath, (Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(outputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently(outputStream);
    }

    public static void closeSilently(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

