/*
 * Decompiled with CFR 0.152.
 */
package breeze.signal;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.numerics.package$isEven$;
import breeze.signal.OptDesignMethod;
import breeze.signal.OptDesignMethod$Firwin$;
import breeze.signal.OptFilterTaps;
import breeze.signal.OptFilterTaps$Automatic$;
import breeze.signal.OptMethod;
import breeze.signal.OptMethod$Automatic$;
import breeze.signal.OptOverhang;
import breeze.signal.OptOverhang$None$;
import breeze.signal.OptOverhang$PreserveLength$;
import breeze.signal.OptPadding;
import breeze.signal.OptPadding$Boundary$;
import breeze.signal.OptPadding$Zero$;
import breeze.signal.OptRange;
import breeze.signal.OptRange$All$;
import breeze.signal.OptWindowFunction;
import breeze.signal.OptWindowFunction$Hamming$;
import breeze.signal.fourierShift$;
import breeze.signal.fourierTr$;
import breeze.signal.iFourierTr$;
import breeze.signal.support.CanConvolve;
import breeze.signal.support.CanDesignFilterDecimation;
import breeze.signal.support.CanFilter;
import breeze.signal.support.CanFilterBPBS;
import breeze.signal.support.CanFilterLPHP;
import breeze.signal.support.CanFilterMedian;
import breeze.signal.support.CanFirwin;
import breeze.signal.support.CanHaarTr;
import breeze.signal.support.CanIHaarTr;
import breeze.signal.support.FIRKernel1D;
import breeze.storage.Zero$DoubleZero$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Range;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class package$ {
    public static final package$ MODULE$;
    private final fourierTr$ fft;
    private final iFourierTr$ ifft;
    private final fourierTr$ fourierTransform;
    private final iFourierTr$ inverseFourierTransform;

    static {
        new package$();
    }

    public fourierTr$ fft() {
        return this.fft;
    }

    public iFourierTr$ ifft() {
        return this.ifft;
    }

    public fourierTr$ fourierTransform() {
        return this.fourierTransform;
    }

    public iFourierTr$ inverseFourierTransform() {
        return this.inverseFourierTransform;
    }

    public DenseVector<Object> fourierFreq(int windowLength, double fs, double dt, boolean shifted) {
        Predef$.MODULE$.require(fs > 0.0 || dt > 0.0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Must specify either a valid fs or a valid dt argument.";
            }
        });
        if (fs > 0.0 && dt > 0.0) {
            Predef$.MODULE$.require(fs == 1.0 / dt, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "If fs and dt are both specified, fs == 1.0/dt must be true. Otherwise, they are incompatible";
                }
            });
        }
        double realFs = fs < 0.0 && dt > 0.0 ? 1.0 / dt : fs;
        DenseVector<Object> shiftedFreq = BoxesRunTime.unboxToBoolean((Object)package$isEven$.MODULE$.apply(BoxesRunTime.boxToInteger((int)windowLength), package$isEven$.MODULE$.isEvenImpl_Int())) ? DenseVector$.MODULE$.vertcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseVector[]{(DenseVector)DenseVector$.MODULE$.tabulate$mDc$sp((Range)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), windowLength / 2 - 1), (Function1<Object, Object>)new Serializable(windowLength, realFs){
            public static final long serialVersionUID = 0L;
            private final int windowLength$1;
            private final double realFs$1;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return (double)i * this.realFs$1 / (double)this.windowLength$1;
            }
            {
                this.windowLength$1 = windowLength$1;
                this.realFs$1 = realFs$1;
            }
        }, (ClassTag<Object>)ClassTag$.MODULE$.Double()), (DenseVector)DenseVector$.MODULE$.tabulate$mDc$sp((Range)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-windowLength / 2), -1), (Function1<Object, Object>)new Serializable(windowLength, realFs){
            public static final long serialVersionUID = 0L;
            private final int windowLength$1;
            private final double realFs$1;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return (double)i * this.realFs$1 / (double)this.windowLength$1;
            }
            {
                this.windowLength$1 = windowLength$1;
                this.realFs$1 = realFs$1;
            }
        }, (ClassTag<Object>)ClassTag$.MODULE$.Double())}), DenseVector$.MODULE$.canSetD(), ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$) : DenseVector$.MODULE$.vertcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseVector[]{(DenseVector)DenseVector$.MODULE$.tabulate$mDc$sp((Range)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), (windowLength - 1) / 2), (Function1<Object, Object>)new Serializable(windowLength, realFs){
            public static final long serialVersionUID = 0L;
            private final int windowLength$1;
            private final double realFs$1;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return (double)i * this.realFs$1 / (double)this.windowLength$1;
            }
            {
                this.windowLength$1 = windowLength$1;
                this.realFs$1 = realFs$1;
            }
        }, (ClassTag<Object>)ClassTag$.MODULE$.Double()), (DenseVector)DenseVector$.MODULE$.tabulate$mDc$sp((Range)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-(windowLength - 1) / 2), -1), (Function1<Object, Object>)new Serializable(windowLength, realFs){
            public static final long serialVersionUID = 0L;
            private final int windowLength$1;
            private final double realFs$1;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return (double)i * this.realFs$1 / (double)this.windowLength$1;
            }
            {
                this.windowLength$1 = windowLength$1;
                this.realFs$1 = realFs$1;
            }
        }, (ClassTag<Object>)ClassTag$.MODULE$.Double())}), DenseVector$.MODULE$.canSetD(), ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$);
        return shifted ? fourierShift$.MODULE$.apply(shiftedFreq, fourierShift$.MODULE$.implFourierShift_Double()) : shiftedFreq;
    }

    public double fourierFreq$default$2() {
        return -1.0;
    }

    public double fourierFreq$default$3() {
        return -1.0;
    }

    public boolean fourierFreq$default$4() {
        return false;
    }

    public <Input, KernelType, Output> Output convolve(Input data, KernelType kernel, OptRange range, OptOverhang overhang, OptPadding padding, OptMethod method, CanConvolve<Input, KernelType, Output> canConvolve) {
        return canConvolve.apply(data, kernel, range, false, overhang, padding, method);
    }

    public <Input, KernelType, Output> OptRange convolve$default$3() {
        return OptRange$All$.MODULE$;
    }

    public <Input, KernelType, Output> OptOverhang convolve$default$4() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, KernelType, Output> OptPadding convolve$default$5() {
        return OptPadding$Zero$.MODULE$;
    }

    public <Input, KernelType, Output> OptMethod convolve$default$6() {
        return OptMethod$Automatic$.MODULE$;
    }

    public <Input, KernelType, Output> Output correlate(Input data, KernelType kernel, OptRange range, OptOverhang overhang, OptPadding padding, OptMethod method, CanConvolve<Input, KernelType, Output> canConvolve) {
        return canConvolve.apply(data, kernel, range, true, overhang, padding, method);
    }

    public <Input, KernelType, Output> OptRange correlate$default$3() {
        return OptRange$All$.MODULE$;
    }

    public <Input, KernelType, Output> OptOverhang correlate$default$4() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, KernelType, Output> OptPadding correlate$default$5() {
        return OptPadding$Zero$.MODULE$;
    }

    public <Input, KernelType, Output> OptMethod correlate$default$6() {
        return OptMethod$Automatic$.MODULE$;
    }

    public <Input, Kernel, Output> Output filter(Input data, Kernel kernel, OptOverhang overhang, OptPadding padding, CanFilter<Input, Kernel, Output> canFilter) {
        return canFilter.apply(data, kernel, overhang, padding);
    }

    public <Input, Kernel, Output> OptOverhang filter$default$3() {
        return OptOverhang$PreserveLength$.MODULE$;
    }

    public <Input, Kernel, Output> OptPadding filter$default$4() {
        return OptPadding$Zero$.MODULE$;
    }

    public <Input, Output> Output filterBP(Input data, Tuple2<Object, Object> omegas, double sampleRate, int taps, OptDesignMethod kernelDesign, OptOverhang overhang, OptPadding padding, CanFilterBPBS<Input, Output> canFilterBPBS) {
        return canFilterBPBS.apply(data, omegas, sampleRate, taps, false, kernelDesign, overhang, padding);
    }

    public <Input, Output> double filterBP$default$3() {
        return 2.0;
    }

    public <Input, Output> int filterBP$default$4() {
        return 512;
    }

    public <Input, Output> OptDesignMethod filterBP$default$5() {
        return OptDesignMethod$Firwin$.MODULE$;
    }

    public <Input, Output> OptOverhang filterBP$default$6() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, Output> OptPadding filterBP$default$7() {
        return OptPadding$Boundary$.MODULE$;
    }

    public <Input, Output> Output filterBS(Input data, Tuple2<Object, Object> omegas, double sampleRate, int taps, OptDesignMethod kernelDesign, OptOverhang overhang, OptPadding padding, CanFilterBPBS<Input, Output> canFilterBPBS) {
        return canFilterBPBS.apply(data, omegas, sampleRate, taps, true, kernelDesign, overhang, padding);
    }

    public <Input, Output> double filterBS$default$3() {
        return 2.0;
    }

    public <Input, Output> int filterBS$default$4() {
        return 512;
    }

    public <Input, Output> OptDesignMethod filterBS$default$5() {
        return OptDesignMethod$Firwin$.MODULE$;
    }

    public <Input, Output> OptOverhang filterBS$default$6() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, Output> OptPadding filterBS$default$7() {
        return OptPadding$Boundary$.MODULE$;
    }

    public <Input, Output> Output filterLP(Input data, double omega, double sampleRate, int taps, OptDesignMethod kernelDesign, OptOverhang overhang, OptPadding padding, CanFilterLPHP<Input, Output> canFilterLPHP) {
        return canFilterLPHP.apply(data, omega, sampleRate, taps, true, kernelDesign, overhang, padding);
    }

    public <Input, Output> double filterLP$default$3() {
        return 2.0;
    }

    public <Input, Output> int filterLP$default$4() {
        return 512;
    }

    public <Input, Output> OptDesignMethod filterLP$default$5() {
        return OptDesignMethod$Firwin$.MODULE$;
    }

    public <Input, Output> OptOverhang filterLP$default$6() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, Output> OptPadding filterLP$default$7() {
        return OptPadding$Boundary$.MODULE$;
    }

    public <Input, Output> Output filterHP(Input data, double omega, double sampleRate, int taps, OptDesignMethod kernelDesign, OptOverhang overhang, OptPadding padding, CanFilterLPHP<Input, Output> canFilterLPHP) {
        return canFilterLPHP.apply(data, omega, sampleRate, taps, false, kernelDesign, overhang, padding);
    }

    public <Input, Output> double filterHP$default$3() {
        return 2.0;
    }

    public <Input, Output> int filterHP$default$4() {
        return 512;
    }

    public <Input, Output> OptDesignMethod filterHP$default$5() {
        return OptDesignMethod$Firwin$.MODULE$;
    }

    public <Input, Output> OptOverhang filterHP$default$6() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, Output> OptPadding filterHP$default$7() {
        return OptPadding$Boundary$.MODULE$;
    }

    public <Output> FIRKernel1D<Output> designFilterFirwin(int taps, DenseVector<Object> omegas, double nyquist, boolean zeroPass, boolean scale, double multiplier, OptWindowFunction optWindow, CanFirwin<Output> canFirwin) {
        return canFirwin.apply(taps, omegas, nyquist, zeroPass, scale, multiplier, optWindow);
    }

    public <Output> double designFilterFirwin$default$3() {
        return 1.0;
    }

    public <Output> boolean designFilterFirwin$default$4() {
        return true;
    }

    public <Output> boolean designFilterFirwin$default$5() {
        return true;
    }

    public <Output> double designFilterFirwin$default$6() {
        return 1.0;
    }

    public <Output> OptWindowFunction designFilterFirwin$default$7() {
        return new OptWindowFunction.Hamming(OptWindowFunction$Hamming$.MODULE$.apply$default$1(), OptWindowFunction$Hamming$.MODULE$.apply$default$2());
    }

    public <Output> Output designFilterDecimation(int factor, double multiplier, OptDesignMethod optDesignMethod, OptWindowFunction optWindow, OptFilterTaps optFilterOrder, CanDesignFilterDecimation<Output> canDesignFilterDecimation) {
        return canDesignFilterDecimation.apply(factor, multiplier, optDesignMethod, optWindow, optFilterOrder);
    }

    public <Output> double designFilterDecimation$default$2() {
        return 1.0;
    }

    public <Output> OptDesignMethod designFilterDecimation$default$3() {
        return OptDesignMethod$Firwin$.MODULE$;
    }

    public <Output> OptWindowFunction designFilterDecimation$default$4() {
        return new OptWindowFunction.Hamming(OptWindowFunction$Hamming$.MODULE$.apply$default$1(), OptWindowFunction$Hamming$.MODULE$.apply$default$2());
    }

    public <Output> OptFilterTaps designFilterDecimation$default$5() {
        return OptFilterTaps$Automatic$.MODULE$;
    }

    public <Input> DenseVector<Input> filterMedian(DenseVector<Input> data, int windowLength, OptOverhang overhang, CanFilterMedian<Input> canFilterMedian) {
        return canFilterMedian.apply(data, windowLength, overhang);
    }

    public <Input> DenseVector<Input> filterMedian(DenseVector<Input> data, int windowLength, CanFilterMedian<Input> canFilterMedian) {
        return canFilterMedian.apply(data, windowLength, OptOverhang$PreserveLength$.MODULE$);
    }

    public <Input> OptOverhang filterMedian$default$3() {
        return OptOverhang$PreserveLength$.MODULE$;
    }

    public <Input, Output> Output haarTr(Input v, CanHaarTr<Input, Output> canHaarTransform) {
        return canHaarTransform.apply(v);
    }

    public <Input, Output> Output haarTransform(Input v, CanHaarTr<Input, Output> canHaarTransform) {
        return canHaarTransform.apply(v);
    }

    public <Input, Output> Output iHaarTr(Input v, CanIHaarTr<Input, Output> canInverseHaarTransform) {
        return canInverseHaarTransform.apply(v);
    }

    public <Input, Output> Output inverseHaarTransform(Input v, CanIHaarTr<Input, Output> canInverseHaarTransform) {
        return canInverseHaarTransform.apply(v);
    }

    private package$() {
        MODULE$ = this;
        this.fft = fourierTr$.MODULE$;
        this.ifft = iFourierTr$.MODULE$;
        this.fourierTransform = fourierTr$.MODULE$;
        this.inverseFourierTransform = iFourierTr$.MODULE$;
    }
}

