/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.razorvine.pickle.PickleException;
import net.razorvine.pyro.Config;
import net.razorvine.pyro.IOUtil;
import net.razorvine.pyro.Message;
import net.razorvine.pyro.PyroException;
import net.razorvine.pyro.PyroURI;
import net.razorvine.pyro.serializer.PyroSerializer;

public class PyroProxy
implements Serializable {
    private static final long serialVersionUID = -5675423476693913030L;
    public String hostname;
    public int port;
    public String objectid;
    private transient int sequenceNr = 0;
    private transient Socket sock;
    private transient OutputStream sock_out;
    private transient InputStream sock_in;

    public PyroProxy() {
    }

    public PyroProxy(PyroURI pyroURI) throws UnknownHostException, IOException {
        this(pyroURI.host, pyroURI.port, pyroURI.objectid);
    }

    public PyroProxy(String string, int n, String string2) throws UnknownHostException, IOException {
        this.hostname = string;
        this.port = n;
        this.objectid = string2;
    }

    protected void connect() throws UnknownHostException, IOException {
        if (this.sock == null) {
            this.sock = new Socket(this.hostname, this.port);
            this.sock.setKeepAlive(true);
            this.sock.setTcpNoDelay(true);
            this.sock_out = this.sock.getOutputStream();
            this.sock_in = this.sock.getInputStream();
            this.sequenceNr = 0;
            this.handshake();
        }
    }

    public Object call(String string, Object ... objectArray) throws PickleException, PyroException, IOException {
        return this.call(string, 0, objectArray);
    }

    public void call_oneway(String string, Object ... objectArray) throws PickleException, PyroException, IOException {
        this.call(string, 4, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object call(String string, int n, Object ... objectArray) throws PickleException, PyroException, IOException {
        Object object;
        Object object2;
        Message message;
        Object object3 = this;
        synchronized (object3) {
            this.connect();
            this.sequenceNr = this.sequenceNr + 1 & 0xFFFF;
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        object3 = PyroSerializer.getFor(Config.SERIALIZER);
        byte[] byArray = ((PyroSerializer)object3).serializeCall(this.objectid, string, objectArray, Collections.<String, Object>emptyMap());
        Message message2 = new Message(4, byArray, ((PyroSerializer)object3).getSerializerId(), n, this.sequenceNr, null);
        Object object4 = this.sock;
        synchronized (object4) {
            IOUtil.send(this.sock_out, message2.to_bytes());
            if (Config.MSG_TRACE_DIR != null) {
                Message.TraceMessageSend(this.sequenceNr, message2.get_header_bytes(), message2.get_annotations_bytes(), message2.data);
            }
            byArray = null;
            if ((n & 4) != 0) {
                return null;
            }
            message = Message.recv(this.sock_in, new int[]{5});
        }
        if (message.seq != this.sequenceNr) {
            throw new PyroException("result msg out of sync");
        }
        if ((message.flags & 2) != 0) {
            object4 = new Inflater();
            ((Inflater)object4).setInput(message.data);
            object2 = new ByteArrayOutputStream(message.data.length);
            object = new byte[8192];
            try {
                while (!((Inflater)object4).finished()) {
                    int n2 = ((Inflater)object4).inflate((byte[])object);
                    ((ByteArrayOutputStream)object2).write((byte[])object, 0, n2);
                }
                message.data = ((ByteArrayOutputStream)object2).toByteArray();
                ((Inflater)object4).end();
            }
            catch (DataFormatException dataFormatException) {
                throw new PyroException("invalid compressed data: ", dataFormatException);
            }
        }
        if ((message.flags & 1) != 0) {
            object4 = (Throwable)((PyroSerializer)object3).deserializeData(message.data);
            if (object4 instanceof PyroException) {
                throw (PyroException)object4;
            }
            object2 = new PyroException("remote exception occurred", (Throwable)object4);
            try {
                String string2;
                object = object4.getClass().getDeclaredField("_pyroTraceback");
                ((PyroException)object2)._pyroTraceback = string2 = (String)((Field)object).get(object4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw object2;
        }
        return ((PyroSerializer)object3).deserializeData(message.data);
    }

    public void close() {
        if (this.sock != null) {
            try {
                this.sock_in.close();
                this.sock_out.close();
                this.sock.close();
                this.sock = null;
                this.sock_in = null;
                this.sock_out = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void finalize() {
        this.close();
    }

    protected void handshake() throws IOException {
        Message.recv(this.sock_in, new int[]{2});
    }

    public void __setstate__(Object[] objectArray) throws IOException {
        PyroURI pyroURI = (PyroURI)objectArray[0];
        this.hostname = pyroURI.host;
        this.port = pyroURI.port;
        this.objectid = pyroURI.objectid;
        this.sock = null;
        this.sock_in = null;
        this.sock_out = null;
    }
}

