/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import org.apache.catalina.core.AprLifecycleListener;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.embedded.tomcat.TomcatReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.util.Assert;

public class TomcatReactiveWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<TomcatReactiveWebServerFactory> {
    private final ServerProperties serverProperties;

    public TomcatReactiveWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void customize(TomcatReactiveWebServerFactory factory) {
        ServerProperties.Tomcat tomcatProperties = this.serverProperties.getTomcat();
        factory.setDisableMBeanRegistry(!tomcatProperties.getMbeanregistry().isEnabled());
        factory.setUseApr(this.getUseApr(tomcatProperties.getUseApr()));
    }

    private boolean getUseApr(ServerProperties.Tomcat.UseApr useApr) {
        return switch (useApr) {
            default -> throw new IncompatibleClassChangeError();
            case ServerProperties.Tomcat.UseApr.ALWAYS -> {
                Assert.state((boolean)this.isAprAvailable(), (String)"APR has been configured to 'ALWAYS', but it's not available");
                yield true;
            }
            case ServerProperties.Tomcat.UseApr.WHEN_AVAILABLE -> this.isAprAvailable();
            case ServerProperties.Tomcat.UseApr.NEVER -> false;
        };
    }

    private boolean isAprAvailable() {
        new AprLifecycleListener();
        return AprLifecycleListener.isAprAvailable();
    }
}

