/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.http.matcher;

import org.springframework.cloud.alibaba.dubbo.http.matcher.MediaTypeExpression;
import org.springframework.http.MediaType;

public class AbstractMediaTypeExpression
implements MediaTypeExpression,
Comparable<AbstractMediaTypeExpression> {
    private final MediaType mediaType;
    private final boolean negated;

    AbstractMediaTypeExpression(String expression) {
        if (expression.startsWith("!")) {
            this.negated = true;
            expression = expression.substring(1);
        } else {
            this.negated = false;
        }
        this.mediaType = MediaType.parseMediaType((String)expression);
    }

    AbstractMediaTypeExpression(MediaType mediaType, boolean negated) {
        this.mediaType = mediaType;
        this.negated = negated;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public int compareTo(AbstractMediaTypeExpression other) {
        return MediaType.SPECIFICITY_COMPARATOR.compare(this.getMediaType(), other.getMediaType());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractMediaTypeExpression otherExpr = (AbstractMediaTypeExpression)other;
        return this.mediaType.equals((Object)otherExpr.mediaType) && this.negated == otherExpr.negated;
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.negated) {
            builder.append('!');
        }
        builder.append(this.mediaType.toString());
        return builder.toString();
    }
}

