/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.metadata.repository;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.dubbo.common.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.alibaba.dubbo.env.DubboCloudProperties;
import org.springframework.cloud.alibaba.dubbo.http.DefaultHttpRequest;
import org.springframework.cloud.alibaba.dubbo.http.matcher.RequestMetadataMatcher;
import org.springframework.cloud.alibaba.dubbo.metadata.DubboRestServiceMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.RequestMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.RestMethodMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.ServiceRestMetadata;
import org.springframework.cloud.alibaba.dubbo.service.DubboMetadataService;
import org.springframework.cloud.alibaba.dubbo.service.DubboMetadataServiceExporter;
import org.springframework.cloud.alibaba.dubbo.service.DubboMetadataServiceProxy;
import org.springframework.cloud.alibaba.dubbo.util.JSONUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.http.HttpRequest;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

@Repository
public class DubboServiceMetadataRepository {
    public static final String DUBBO_METADATA_SERVICE_PREFIX = "dubbo.metadata-service.";
    public static final String DUBBO_METADATA_SERVICE_URLS_PROPERTY_NAME = "dubbo.metadata-service.urls";
    public static final String DUBBO_PROTOCOLS_PORT_PROPERTY_NAME_PATTERN = "dubbo.protocols.%s.port";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final MultiValueMap<String, URL> allExportedURLs = new LinkedMultiValueMap();
    private Set<String> subscribedServices;
    private final MultiValueMap<String, URL> subscribedDubboMetadataServiceURLs = new LinkedMultiValueMap();
    private final Set<ServiceRestMetadata> serviceRestMetadata = new LinkedHashSet<ServiceRestMetadata>();
    private Map<String, Map<RequestMetadataMatcher, DubboRestServiceMetadata>> dubboRestServiceMetadataRepository = DubboServiceMetadataRepository.newHashMap();
    @Autowired
    private DubboCloudProperties dubboCloudProperties;
    @Autowired
    private DubboMetadataServiceProxy dubboMetadataConfigServiceProxy;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private JSONUtils jsonUtils;
    @Value(value="${spring.application.name}")
    private String currentApplicationName;
    @Autowired
    private DubboMetadataServiceExporter dubboMetadataServiceExporter;

    @PostConstruct
    public void init() {
        this.initSubscribedServices();
        this.initSubscribedDubboMetadataServices();
        this.initDubboRestServiceMetadataRepository();
    }

    public Map<String, String> getDubboMetadataServiceMetadata() {
        List<URL> dubboMetadataServiceURLs = this.dubboMetadataServiceExporter.export();
        this.removeDubboMetadataServiceURLs(dubboMetadataServiceURLs);
        Map<String, String> metadata = DubboServiceMetadataRepository.newHashMap();
        this.addDubboMetadataServiceURLsMetadata(metadata, dubboMetadataServiceURLs);
        this.addDubboProtocolsPortMetadata(metadata);
        return Collections.unmodifiableMap(metadata);
    }

    private void removeDubboMetadataServiceURLs(List<URL> dubboMetadataServiceURLs) {
        dubboMetadataServiceURLs.forEach(this::unexportURL);
    }

    private void addDubboMetadataServiceURLsMetadata(Map<String, String> metadata, List<URL> dubboMetadataServiceURLs) {
        String dubboMetadataServiceURLsJSON = this.jsonUtils.toJSON(dubboMetadataServiceURLs);
        metadata.put(DUBBO_METADATA_SERVICE_URLS_PROPERTY_NAME, dubboMetadataServiceURLsJSON);
    }

    private void addDubboProtocolsPortMetadata(Map<String, String> metadata) {
        this.allExportedURLs.values().stream().flatMap(v -> v.stream()).forEach(url -> {
            String protocol = url.getProtocol();
            String propertyName = this.getDubboProtocolPropertyName(protocol);
            String propertyValue = String.valueOf(url.getPort());
            metadata.put(propertyName, propertyValue);
        });
    }

    public String getDubboProtocolPropertyName(String protocol) {
        return String.format(DUBBO_PROTOCOLS_PORT_PROPERTY_NAME_PATTERN, protocol);
    }

    public void publishServiceRestMetadata(Set<ServiceRestMetadata> serviceRestMetadataSet) {
        for (ServiceRestMetadata serviceRestMetadata : serviceRestMetadataSet) {
            if (CollectionUtils.isEmpty(serviceRestMetadata.getMeta())) continue;
            this.serviceRestMetadata.add(serviceRestMetadata);
        }
    }

    public Set<ServiceRestMetadata> getServiceRestMetadata() {
        return Collections.unmodifiableSet(this.serviceRestMetadata);
    }

    public List<URL> findSubscribedDubboMetadataServiceURLs(String serviceName, String group, String version, String protocol) {
        String serviceKey = URL.buildKey((String)serviceName, (String)group, (String)version);
        List urls = (List)this.subscribedDubboMetadataServiceURLs.get((Object)serviceKey);
        if (CollectionUtils.isEmpty((Collection)urls)) {
            return Collections.emptyList();
        }
        return StringUtils.hasText((String)protocol) ? urls.stream().filter(url -> url.getProtocol().equalsIgnoreCase(protocol)).collect(Collectors.toList()) : Collections.unmodifiableList(urls);
    }

    public boolean isSubscribedService(String serviceName) {
        return this.subscribedServices.contains(serviceName);
    }

    public void exportURL(URL url) {
        this.allExportedURLs.add((Object)url.getServiceKey(), (Object)url);
    }

    public void unexportURL(URL url) {
        String key = url.getServiceKey();
        List urls = (List)this.allExportedURLs.get((Object)key);
        urls.remove(url);
        this.allExportedURLs.addAll((Object)key, urls);
    }

    public Map<String, List<URL>> getAllExportedUrls() {
        return Collections.unmodifiableMap(this.allExportedURLs);
    }

    public Set<String> getAllServiceKeys() {
        return this.allExportedURLs.keySet();
    }

    public List<URL> getDubboMetadataServiceURLs(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        String dubboURLsJSON = (String)metadata.get(DUBBO_METADATA_SERVICE_URLS_PROPERTY_NAME);
        return this.jsonUtils.toURLs(dubboURLsJSON);
    }

    public Integer getDubboProtocolPort(ServiceInstance serviceInstance, String protocol) {
        String protocolProperty = this.getDubboProtocolPropertyName(protocol);
        Map metadata = serviceInstance.getMetadata();
        String protocolPort = (String)metadata.get(protocolProperty);
        return StringUtils.hasText((String)protocolPort) ? Integer.valueOf(protocolPort) : null;
    }

    public List<URL> getExportedURLs(String serviceInterface, String group, String version) {
        String serviceKey = URL.buildKey((String)serviceInterface, (String)group, (String)version);
        return (List)this.allExportedURLs.getOrDefault((Object)serviceKey, Collections.emptyList());
    }

    public void initialize(String serviceName) {
        if (this.dubboRestServiceMetadataRepository.containsKey(serviceName)) {
            return;
        }
        Set<ServiceRestMetadata> serviceRestMetadataSet = this.getServiceRestMetadataSet(serviceName);
        if (CollectionUtils.isEmpty(serviceRestMetadataSet)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("The Spring application[name : {}] does not expose The REST metadata in the Dubbo services.", (Object)serviceName);
            }
            return;
        }
        Map<RequestMetadataMatcher, DubboRestServiceMetadata> metadataMap = this.getMetadataMap(serviceName);
        for (ServiceRestMetadata serviceRestMetadata : serviceRestMetadataSet) {
            serviceRestMetadata.getMeta().forEach(restMethodMetadata -> {
                RequestMetadata requestMetadata = restMethodMetadata.getRequest();
                RequestMetadataMatcher matcher = new RequestMetadataMatcher(requestMetadata);
                DubboRestServiceMetadata metadata = new DubboRestServiceMetadata(serviceRestMetadata, (RestMethodMetadata)restMethodMetadata);
                metadataMap.put(matcher, metadata);
            });
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The REST metadata in the dubbo services has been loaded in the Spring application[name : {}]", (Object)serviceName);
        }
    }

    public DubboRestServiceMetadata get(String serviceName, RequestMetadata requestMetadata) {
        return (DubboRestServiceMetadata)this.match(this.dubboRestServiceMetadataRepository, serviceName, requestMetadata);
    }

    public Set<String> getSubscribedServices() {
        return Collections.unmodifiableSet(this.subscribedServices);
    }

    private <T> T match(Map<String, Map<RequestMetadataMatcher, T>> repository, String serviceName, RequestMetadata requestMetadata) {
        RequestMetadataMatcher matcher;
        Map<RequestMetadataMatcher, T> map = repository.get(serviceName);
        T object = null;
        if (!CollectionUtils.isEmpty(map) && (object = (T)map.get(matcher = new RequestMetadataMatcher(requestMetadata))) == null) {
            HttpRequest request = DefaultHttpRequest.builder().method(requestMetadata.getMethod()).path(requestMetadata.getPath()).params((Map<String, List<String>>)requestMetadata.getParams()).headers(requestMetadata.getHeaders()).build();
            for (Map.Entry<RequestMetadataMatcher, T> entry : map.entrySet()) {
                RequestMetadataMatcher possibleMatcher = entry.getKey();
                if (!possibleMatcher.match(request)) continue;
                object = entry.getValue();
                break;
            }
        }
        if (object == null && this.logger.isWarnEnabled()) {
            this.logger.warn("DubboServiceMetadata can't be found in the Spring application [%s] and %s", (Object)serviceName, (Object)requestMetadata);
        }
        return object;
    }

    private Map<RequestMetadataMatcher, DubboRestServiceMetadata> getMetadataMap(String serviceName) {
        return DubboServiceMetadataRepository.getMap(this.dubboRestServiceMetadataRepository, serviceName);
    }

    private Set<ServiceRestMetadata> getServiceRestMetadataSet(String serviceName) {
        Set metadata;
        block4: {
            metadata = Collections.emptySet();
            DubboMetadataService dubboMetadataService = this.dubboMetadataConfigServiceProxy.getProxy(serviceName);
            if (dubboMetadataService != null) {
                try {
                    String serviceRestMetadataJsonConfig = dubboMetadataService.getServiceRestMetadata();
                    if (StringUtils.hasText((String)serviceRestMetadataJsonConfig)) {
                        metadata = (Set)this.objectMapper.readValue(serviceRestMetadataJsonConfig, (JavaType)TypeFactory.defaultInstance().constructCollectionType(LinkedHashSet.class, ServiceRestMetadata.class));
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block4;
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return metadata;
    }

    private static <K, V> Map<K, V> getMap(Map<String, Map<K, V>> repository, String key) {
        return DubboServiceMetadataRepository.getOrDefault(repository, key, DubboServiceMetadataRepository.newHashMap());
    }

    private static <K, V> V getOrDefault(Map<K, V> source, K key, V defaultValue) {
        V value = source.get(key);
        if (value == null) {
            value = defaultValue;
            source.put(key, value);
        }
        return value;
    }

    private static <K, V> Map<K, V> newHashMap() {
        return new LinkedHashMap();
    }

    private void initSubscribedServices() {
        if ("*".equals(this.dubboCloudProperties.getSubscribedServices())) {
            List services = this.discoveryClient.getServices();
            this.subscribedServices = new HashSet<String>(services);
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Current application will subscribe all services(size:{}) in registry, a lot of memory and CPU cycles may be used, thus it's strongly recommend you using the externalized property '{}' to specify the services", (Object)this.subscribedServices.size(), (Object)"dubbo.cloud.subscribed-services");
            }
        } else {
            this.subscribedServices = new HashSet<String>(this.dubboCloudProperties.subscribedServices());
        }
        this.excludeSelf(this.subscribedServices);
    }

    private void excludeSelf(Set<String> subscribedServices) {
        subscribedServices.remove(this.currentApplicationName);
    }

    private void initSubscribedDubboMetadataServices() {
        this.subscribedDubboMetadataServiceURLs.clear();
        this.subscribedServices.stream().map(arg_0 -> ((DiscoveryClient)this.discoveryClient).getInstances(arg_0)).filter(this::isNotEmpty).forEach(serviceInstances -> {
            ServiceInstance serviceInstance = (ServiceInstance)serviceInstances.get(0);
            this.getDubboMetadataServiceURLs(serviceInstance).forEach(dubboMetadataServiceURL -> {
                this.initSubscribedDubboMetadataServiceURLs((URL)dubboMetadataServiceURL);
                this.initDubboMetadataServiceProxy((URL)dubboMetadataServiceURL);
            });
        });
    }

    private void initSubscribedDubboMetadataServiceURLs(URL dubboMetadataServiceURL) {
        String serviceKey = dubboMetadataServiceURL.getServiceKey();
        this.subscribedDubboMetadataServiceURLs.add((Object)serviceKey, (Object)dubboMetadataServiceURL);
    }

    private void initDubboMetadataServiceProxy(URL dubboMetadataServiceURL) {
        String serviceName = dubboMetadataServiceURL.getParameter("application");
        String version = dubboMetadataServiceURL.getParameter("version");
        this.dubboMetadataConfigServiceProxy.initProxy(serviceName, version);
    }

    private void initDubboRestServiceMetadataRepository() {
        this.subscribedServices.forEach(this::initialize);
    }

    private boolean isNotEmpty(Collection collection) {
        return !CollectionUtils.isEmpty((Collection)collection);
    }
}

